/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.vanilla.render;

public final class ColorKt {
    public static final int getColor(long l2) {
        return (int)l2;
    }

    public static final int getAlpha(int n2) {
        return n2 >>> 24;
    }

    public static final int getRed(int n2) {
        return n2 >> 16 & 0xFF;
    }

    public static final int getGreen(int n2) {
        return n2 >> 8 & 0xFF;
    }

    public static final int getBlue(int n2) {
        return n2 & 0xFF;
    }

    public static final int getOpaque(int n2) {
        return 0xFF000000 | n2;
    }

    public static final int getTransparent(int n2) {
        return 0xFFFFFF & n2;
    }

    public static final int asAlpha(int n2) {
        return (n2 & 0xFF) << 24;
    }

    public static final int asRed(int n2) {
        return (n2 & 0xFF) << 16;
    }

    public static final int asGreen(int n2) {
        return (n2 & 0xFF) << 8;
    }

    public static final int asBlue(int n2) {
        return n2 & 0xFF;
    }

    public static final int dropAlpha(int n2) {
        return ColorKt.getTransparent(n2);
    }

    public static final int dropRed(int n2) {
        return 0xFF00FFFF & n2;
    }

    public static final int dropGreen(int n2) {
        return 0xFFFF00FF & n2;
    }

    public static final int dropBlue(int n2) {
        return 0xFFFFFF00 & n2;
    }

    public static final int alpha(int n2, int n3) {
        n2 = ColorKt.dropAlpha(n2);
        n3 = ColorKt.asAlpha(n3);
        return n2 | n3;
    }

    public static final int red(int n2, int n3) {
        n2 = ColorKt.dropRed(n2);
        n3 = ColorKt.asRed(n3);
        return n2 | n3;
    }

    public static final int green(int n2, int n3) {
        n2 = ColorKt.dropGreen(n2);
        n3 = ColorKt.asGreen(n3);
        return n2 | n3;
    }

    public static final int blue(int n2, int n3) {
        n2 = ColorKt.dropBlue(n2);
        n3 = ColorKt.asBlue(n3);
        return n2 | n3;
    }

    public static final int rgb(int n2, int n3) {
        return ColorKt.alpha(n3, n2);
    }

    public static final int r(int n2, int n3) {
        return ColorKt.red(ColorKt.alpha(0, n2), n3);
    }

    public static final int g(int n2, int n3) {
        return ColorKt.green(n2, n3);
    }

    public static final int b(int n2, int n3) {
        return ColorKt.blue(n2, n3);
    }

    public static final int color(int n2, int n3, int n4) {
        return ColorKt.b(ColorKt.g(ColorKt.r(255, n2), n3), n4);
    }

    public static final int color(int n2, int n3, int n4, int n5) {
        return ColorKt.b(ColorKt.g(ColorKt.r(n2, n3), n4), n5);
    }

    public static final int color(int n2, int n3) {
        return ColorKt.rgb(n2, n3);
    }

    public static final int alpha(int n2, float f2) {
        return ColorKt.alpha(n2, (int)((double)(f2 * 255.0f) + 0.5));
    }

    public static final int red(int n2, float f2) {
        return ColorKt.red(n2, (int)((double)(f2 * 255.0f) + 0.5));
    }

    public static final int green(int n2, float f2) {
        return ColorKt.green(n2, (int)((double)(f2 * 255.0f) + 0.5));
    }

    public static final int blue(int n2, float f2) {
        return ColorKt.blue(n2, (int)((double)(f2 * 255.0f) + 0.5));
    }
}

