/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.forge;

import io.github.jsnimda.common.vanilla.Vanilla;
import io.github.jsnimda.common.vanilla.VanillaUtil;
import io.github.jsnimda.inventoryprofiles.config.Tweaks;
import io.github.jsnimda.inventoryprofiles.event.GameEventHandler;
import io.github.jsnimda.inventoryprofiles.gui.inject.ContainerScreenHandler;
import io.github.jsnimda.inventoryprofiles.gui.inject.InjectWidget;
import io.github.jsnimda.inventoryprofiles.inventory.GeneralInventoryActions;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ForgeEventHandler {
    PlayerController pc = null;
    Field blockHitDelayField = null;
    Field rightClickDelayTimerField = null;

    @SubscribeEvent
    public void onDrawForeground(GuiContainerEvent.DrawForeground drawForeground) {
    }

    @SubscribeEvent
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post post) {
    }

    @SubscribeEvent
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post post) {
        if (post.getGui() instanceof ContainerScreen) {
            if (Vanilla.INSTANCE.screen() != post.getGui()) {
                return;
            }
            for (InjectWidget injectWidget : ContainerScreenHandler.INSTANCE.getContainerInjector((ContainerScreen)post.getGui())) {
                post.addWidget((Widget)injectWidget);
            }
        }
    }

    @SubscribeEvent
    public void postScreenRender(GuiScreenEvent.DrawScreenEvent.Post post) {
        GameEventHandler.INSTANCE.postScreenRender();
    }

    @SubscribeEvent
    public void clientClick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START) {
            this.onTickPre();
            return;
        }
        this.onTickPost();
    }

    public void onTickPost() {
        GameEventHandler.INSTANCE.onTick();
    }

    @SubscribeEvent
    public void joinWorld(WorldEvent.Load load) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            GameEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent itemCraftedEvent) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            GameEventHandler.INSTANCE.onCrafted();
        }
    }

    @SubscribeEvent
    public void preRenderTooltip(RenderTooltipEvent.Pre pre) {
        GameEventHandler.INSTANCE.preRenderTooltip();
    }

    @SubscribeEvent
    public void preScreenRender(GuiScreenEvent.DrawScreenEvent.Pre pre) {
        GameEventHandler.INSTANCE.preScreenRender();
    }

    @SubscribeEvent
    public void onGuiKeyPressedPre(GuiScreenEvent.KeyboardKeyPressedEvent.Pre pre) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        InputMappings.Input input = InputMappings.func_197954_a((int)pre.getKeyCode(), (int)pre.getScanCode());
        if (Tweaks.INSTANCE.getPREVENT_CLOSE_GUI_DROP_ITEM().getBooleanValue() && (pre.getKeyCode() == 256 || Vanilla.INSTANCE.mc().field_71474_y.field_151445_Q.isActiveAndMatches(input))) {
            GeneralInventoryActions.INSTANCE.handleCloseContainer();
        }
    }

    public void onTickPre() {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        if (Tweaks.INSTANCE.getDISABLE_BLOCK_BREAKING_COOLDOWN().getBooleanValue()) {
            if (this.pc == null || this.pc != Vanilla.INSTANCE.interactionManager()) {
                this.pc = Vanilla.INSTANCE.interactionManager();
                this.blockHitDelayField = ObfuscationReflectionHelper.findField(PlayerController.class, (String)"field_78781_i");
            }
            try {
                FieldUtils.writeField((Field)this.blockHitDelayField, (Object)this.pc, (Object)0, (boolean)true);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        if (Tweaks.INSTANCE.getDISABLE_ITEM_USE_COOLDOWN().getBooleanValue()) {
            if (this.rightClickDelayTimerField == null) {
                this.rightClickDelayTimerField = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_71467_ac");
            }
            try {
                FieldUtils.writeField((Field)this.rightClickDelayTimerField, (Object)Vanilla.INSTANCE.mc(), (Object)0, (boolean)true);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

