/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.item.rule.file;

import io.github.jsnimda.common.Log;
import io.github.jsnimda.common.a.a.a.d;
import io.github.jsnimda.common.a.a.d.a.a;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.inventoryprofiles.item.rule.EmptyRule;
import io.github.jsnimda.inventoryprofiles.item.rule.Parameter;
import io.github.jsnimda.inventoryprofiles.item.rule.Rule;
import io.github.jsnimda.inventoryprofiles.item.rule.file.CustomRule;
import io.github.jsnimda.inventoryprofiles.item.rule.file.RuleDefinition;
import io.github.jsnimda.inventoryprofiles.item.rule.file.RuleFile;
import io.github.jsnimda.inventoryprofiles.item.rule.file.RuleFileRegister$RuleFinder;
import io.github.jsnimda.inventoryprofiles.item.rule.file.RuleFileRegister$searchAndPutCustomRule$1;
import io.github.jsnimda.inventoryprofiles.item.rule.native.NativeRules;
import io.github.jsnimda.inventoryprofiles.item.rule.parameter.NativeParameters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuleFileRegister {
    @NotNull
    private static final Set loadedFileNames;
    private static final List ruleFiles;
    private static final Map cachedRules;
    private static final Set names;
    public static final RuleFileRegister INSTANCE;

    @NotNull
    public final Set getLoadedFileNames() {
        return loadedFileNames;
    }

    public final void reloadRuleFiles(@NotNull List list3) {
        j.b(list3, "ruleFiles");
        Log.INSTANCE.trace("[-] Rule file parsing...");
        Log.INSTANCE.trace("    step: (1) parse indent -> (2) parse rule -> syntax ok");
        Log.INSTANCE.indent();
        Iterator iterator = ((Iterable)list3).iterator();
        while (iterator.hasNext()) {
            ((RuleFile)iterator.next()).parseContent();
        }
        Log.INSTANCE.unindent();
        this.clear();
        ruleFiles.addAll(list3);
        this.checkOverrides();
        this.validateRules();
    }

    private final void clear() {
        loadedFileNames.clear();
        ruleFiles.clear();
        cachedRules.clear();
        names.clear();
    }

    private final void checkOverrides() {
        Log.INSTANCE.trace("[-] Check overrides...");
        for (RuleFile ruleFile : ruleFiles) {
            for (String string : ruleFile.getRulesMap().keySet()) {
                if (names.contains(string)) {
                    Log.INSTANCE.info("Rule @" + string + " overrode by file " + ruleFile.getFileName());
                }
                names.add(string);
            }
        }
    }

    private final void validateRules() {
        Log.INSTANCE.trace("[-] Validate rules...");
        Log.INSTANCE.indent();
        for (String string : names) {
            Log.INSTANCE.trace("[-] Validating rule @".concat(String.valueOf(string)));
            Log.INSTANCE.indent();
            if (this.getCustomRule(string) == null) {
                Log.INSTANCE.debug("rule @" + string + " failed to parse");
            }
            Log.INSTANCE.unindent();
        }
        Log.INSTANCE.unindent();
    }

    @NotNull
    public final Rule getCustomRuleOrEmpty(@NotNull String string) {
        j.b(string, "ruleName");
        CustomRule customRule = this.getCustomRule(string);
        if (customRule != null) {
            return customRule;
        }
        EmptyRule emptyRule = EmptyRule.INSTANCE;
        Log.INSTANCE.warn("Rule @" + string + " not found");
        return emptyRule;
    }

    @Nullable
    public final CustomRule getCustomRule(@NotNull String string) {
        j.b(string, "ruleName");
        RuleDefinition ruleDefinition = cachedRules.containsKey(string) ? (RuleDefinition)d.a(cachedRules, (Object)string) : this.searchAndPutCustomRule(string);
        if (ruleDefinition != null) {
            return ruleDefinition.createCustomRule();
        }
        return null;
    }

    @Nullable
    public final Rule getNativeRule(@NotNull String string) {
        j.b(string, "ruleName");
        a a2 = (a)NativeRules.INSTANCE.getMap().get(string);
        if (a2 != null) {
            return (Rule)a2.invoke();
        }
        return null;
    }

    @Nullable
    public final Parameter getParameter(@NotNull String string) {
        j.b(string, "parameterName");
        return (Parameter)NativeParameters.INSTANCE.getMap().get(string);
    }

    private final RuleDefinition searchAndPutCustomRule(String string) {
        Log.INSTANCE.trace("[-] Searching rule @" + string + "...");
        Log.INSTANCE.indent();
        RuleDefinition ruleDefinition = new RuleFileRegister$RuleFinder(string).searchCustomRule();
        Log.INSTANCE.unindent();
        if (cachedRules.containsKey(string)) {
            Log.INSTANCE.trace(">> rule " + string + " already exist in cached map... skip putting");
        } else {
            cachedRules.put(string, ruleDefinition);
        }
        d.a(ruleFiles, RuleFileRegister$searchAndPutCustomRule$1.INSTANCE);
        return ruleDefinition;
    }

    private RuleFileRegister() {
    }

    static {
        INSTANCE = new RuleFileRegister();
        loadedFileNames = new LinkedHashSet();
        ruleFiles = new ArrayList();
        cachedRules = new LinkedHashMap();
        names = new LinkedHashSet();
    }

    public static final /* synthetic */ List access$getRuleFiles$p(RuleFileRegister ruleFileRegister) {
        return ruleFiles;
    }
}

