/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.common.CommonProxy;
import cpw.mods.ironchest.common.ICContent;
import cpw.mods.ironchest.common.network.MessageCrystalChestSync;
import cpw.mods.ironchest.common.network.MessageCrystalShulkerSync;
import cpw.mods.ironchest.common.util.MissingMappingsHandler;
import cpw.mods.ironchest.common.util.OcelotsSitOnChestsHandler;
import java.util.Properties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ironchest", name="Iron Chests", dependencies="required-after:forge@[13.19.0.2142,)", acceptedMinecraftVersions="[1.11, 1.12)")
public class IronChest {
    public static final String MOD_ID = "ironchest";
    @Mod.Instance(value="ironchest")
    public static IronChest instance;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.common.CommonProxy")
    public static CommonProxy proxy;
    public static final SimpleNetworkWrapper packetHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Properties properties = event.getVersionProperties();
        if (properties != null) {
            String major = properties.getProperty("IronChest.build.major.number");
            String minor = properties.getProperty("IronChest.build.minor.number");
            String rev = properties.getProperty("IronChest.build.revision.number");
            String build = properties.getProperty("IronChest.build.number");
            event.getModMetadata().version = String.format("%s.%s.%s build %s", major, minor, rev, build);
        }
        ICContent.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        MinecraftForge.EVENT_BUS.register((Object)new OcelotsSitOnChestsHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int messageId = 0;
        packetHandler.registerMessage(MessageCrystalChestSync.Handler.class, MessageCrystalChestSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageCrystalShulkerSync.Handler.class, MessageCrystalShulkerSync.class, messageId++, Side.CLIENT);
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        MissingMappingsHandler.onMissingMappings(event);
    }

    static {
        packetHandler = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
    }
}

