/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.client;

import cpw.mods.ironchest.client.gui.chest.GUIChest;
import cpw.mods.ironchest.client.gui.shulker.GUIShulkerChest;
import cpw.mods.ironchest.client.renderer.chest.TileEntityIronChestRenderer;
import cpw.mods.ironchest.client.renderer.shulker.TileEntityIronShulkerBoxRenderer;
import cpw.mods.ironchest.common.CommonProxy;
import cpw.mods.ironchest.common.ICContent;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.items.ChestChangerType;
import cpw.mods.ironchest.common.items.ShulkerBoxChangerType;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void registerRenderInformation() {
        Item chestItem = Item.func_150898_a((Block)ICContent.ironChestBlock);
        for (IronChestType ironChestType : IronChestType.values()) {
            if (ironChestType != IronChestType.WOOD) {
                ModelLoader.setCustomModelResourceLocation((Item)chestItem, (int)ironChestType.ordinal(), (ModelResourceLocation)new ModelResourceLocation(chestItem.getRegistryName(), "variant=" + ironChestType.func_176610_l()));
            }
            ClientRegistry.bindTileEntitySpecialRenderer(ironChestType.clazz, (TileEntitySpecialRenderer)new TileEntityIronChestRenderer());
        }
        for (Enum enum_ : ChestChangerType.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)((ChestChangerType)enum_).item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("ironchest", "iron_chest_upgrades"), "variant=" + ((ChestChangerType)enum_).itemName.toLowerCase()));
        }
        for (Block shulker : ICContent.SHULKER_BLOCKS) {
            Item shulkerBoxItem = Item.func_150898_a((Block)shulker);
            for (IronShulkerBoxType type : IronShulkerBoxType.values()) {
                if (type == IronShulkerBoxType.VANILLA) continue;
                ModelLoader.setCustomModelResourceLocation((Item)shulkerBoxItem, (int)type.ordinal(), (ModelResourceLocation)new ModelResourceLocation(shulkerBoxItem.getRegistryName(), "variant=" + type.func_176610_l()));
            }
        }
        for (IronShulkerBoxType ironShulkerBoxType : IronShulkerBoxType.values()) {
            ClientRegistry.bindTileEntitySpecialRenderer(ironShulkerBoxType.clazz, (TileEntitySpecialRenderer)new TileEntityIronShulkerBoxRenderer());
        }
        for (ShulkerBoxChangerType shulkerBoxChangerType : ShulkerBoxChangerType.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)shulkerBoxChangerType.item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("ironchest", "iron_shulker_box_upgrades"), "variant=" + shulkerBoxChangerType.itemName.toLowerCase()));
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te != null && te instanceof TileEntityIronChest) {
            return GUIChest.GUI.buildGUI(IronChestType.values()[ID], (IInventory)player.field_71071_by, (TileEntityIronChest)te);
        }
        if (te != null && te instanceof TileEntityIronShulkerBox) {
            return GUIShulkerChest.GUI.buildGUI(IronShulkerBoxType.values()[ID], (IInventory)player.field_71071_by, (TileEntityIronShulkerBox)te);
        }
        return null;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

