/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.blocks.shulker;

import cpw.mods.ironchest.common.blocks.shulker.BlockIronShulkerBox;
import cpw.mods.ironchest.common.crafting.IronShulkerBoxRecipe;
import cpw.mods.ironchest.common.gui.shulker.slot.ValidatingShulkerBoxSlot;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityCopperShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityCrystalShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityDiamondShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityGoldShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityObsidianShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntitySilverShulkerBox;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum IronShulkerBoxType implements IStringSerializable
{
    IRON(54, 9, true, "_iron.png", TileEntityIronShulkerBox.class, 184, 202, Arrays.asList("ingotIron", "ingotRefinedIron"), "mmmmPmmmm", "mGmG3GmGm"),
    GOLD(81, 9, true, "_gold.png", TileEntityGoldShulkerBox.class, 184, 256, Collections.singleton("ingotGold"), "mmmmPmmmm", "mGmG4GmGm"),
    DIAMOND(108, 12, true, "_diamond.png", TileEntityDiamondShulkerBox.class, 184, 256, Collections.singleton("gemDiamond"), "GGGmPmGGG", "GGGG4Gmmm"),
    COPPER(45, 9, false, "_copper.png", TileEntityCopperShulkerBox.class, 184, 184, Collections.singleton("ingotCopper"), "mmmmSmmmm"),
    SILVER(72, 9, false, "_silver.png", TileEntitySilverShulkerBox.class, 184, 238, Collections.singleton("ingotSilver"), "mmmm3mmmm", "mGmG0GmGm"),
    CRYSTAL(108, 12, true, "_crystal.png", TileEntityCrystalShulkerBox.class, 238, 256, Collections.singleton("blockGlass"), "GGGGPGGGG"),
    OBSIDIAN(108, 12, false, "_obsidian.png", TileEntityObsidianShulkerBox.class, 238, 256, Collections.singleton("obsidian"), "mmmm2mmmm"),
    VANILLA(0, 0, false, "", null, 0, 0, Collections.singleton("shulkerShell"), new String[0]);

    public static final IronShulkerBoxType[] VALUES;
    public final String name = this.name().toLowerCase();
    public final int size;
    public final int rowLength;
    public final boolean tieredShulkerBox;
    public final String modelTexture;
    public final Class<? extends TileEntityIronShulkerBox> clazz;
    public final int xSize;
    public final int ySize;
    public final Collection<String> matList;
    public final Collection<String> recipes;
    private String breakTexture;

    private IronShulkerBoxType(int size, int rowLength, boolean tieredShulkerBox, String modelTexture, Class<? extends TileEntityIronShulkerBox> clazz, int xSize, int ySize, Collection<String> mats, String ... recipes) {
        this.size = size;
        this.rowLength = rowLength;
        this.tieredShulkerBox = tieredShulkerBox;
        this.modelTexture = modelTexture;
        this.clazz = clazz;
        this.xSize = xSize;
        this.ySize = ySize;
        this.matList = Collections.unmodifiableCollection(mats);
        this.recipes = Collections.unmodifiableCollection(Arrays.asList(recipes));
    }

    public String func_176610_l() {
        return this.name;
    }

    public String getBreakTexture() {
        if (this.breakTexture == null) {
            switch (this) {
                case OBSIDIAN: {
                    this.breakTexture = "minecraft:blocks/obsidian";
                    break;
                }
                case VANILLA: {
                    this.breakTexture = "minecraft:blocks/planks_oak";
                    break;
                }
                default: {
                    this.breakTexture = "ironchest:blocks/" + this.func_176610_l() + "break";
                }
            }
        }
        return this.breakTexture;
    }

    public static void registerBlocksAndRecipes(BlockIronShulkerBox blockResult, BlockShulkerBox shulkerBox) {
        BlockShulkerBox previous = shulkerBox;
        for (IronShulkerBoxType typ : IronShulkerBoxType.values()) {
            IronShulkerBoxType.generateRecipesForType(blockResult, previous, typ, shulkerBox);
            ItemStack newShulkerBox = new ItemStack((Block)blockResult, 1, typ.ordinal());
            if (!typ.tieredShulkerBox) continue;
            previous = newShulkerBox;
        }
    }

    public static void generateRecipesForType(BlockIronShulkerBox blockResult, Object previousTier, IronShulkerBoxType type, BlockShulkerBox shulkerBox) {
        for (String recipe : type.recipes) {
            String[] recipeSplit = new String[]{recipe.substring(0, 3), recipe.substring(3, 6), recipe.substring(6, 9)};
            Object mainMaterial = null;
            for (String mat : type.matList) {
                mainMaterial = IronShulkerBoxType.translateOreName(mat);
                IronShulkerBoxType.addRecipe(new ItemStack((Block)blockResult, 1, type.ordinal()), recipeSplit, Character.valueOf('m'), mainMaterial, Character.valueOf('P'), previousTier, Character.valueOf('G'), "blockGlass", Character.valueOf('S'), shulkerBox, Character.valueOf('0'), new ItemStack((Block)blockResult, 1, 0), Character.valueOf('1'), new ItemStack((Block)blockResult, 1, 1), Character.valueOf('2'), new ItemStack((Block)blockResult, 1, 2), Character.valueOf('3'), new ItemStack((Block)blockResult, 1, 3), Character.valueOf('4'), new ItemStack((Block)blockResult, 1, 4));
            }
        }
    }

    public static Object translateOreName(String mat) {
        if (mat.equals("shulkerShell")) {
            return Items.field_190930_cZ;
        }
        if (mat.equals("obsidian")) {
            return Blocks.field_150343_Z;
        }
        return mat;
    }

    public static void addRecipe(ItemStack is, Object ... parts) {
        IronShulkerBoxRecipe oreRecipe = new IronShulkerBoxRecipe(is, parts);
        GameRegistry.addRecipe((IRecipe)oreRecipe);
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    public boolean isValidForCreativeMode() {
        return this != VANILLA;
    }

    public boolean isExplosionResistant() {
        return this == OBSIDIAN;
    }

    public Slot makeSlot(IInventory chestInventory, int index, int x, int y) {
        return new ValidatingShulkerBoxSlot(chestInventory, index, x, y);
    }

    public TileEntityIronShulkerBox makeEntity(EnumDyeColor colorIn) {
        switch (this) {
            case IRON: {
                return new TileEntityIronShulkerBox(colorIn);
            }
            case GOLD: {
                return new TileEntityGoldShulkerBox(colorIn);
            }
            case DIAMOND: {
                return new TileEntityDiamondShulkerBox(colorIn);
            }
            case COPPER: {
                return new TileEntityCopperShulkerBox(colorIn);
            }
            case SILVER: {
                return new TileEntitySilverShulkerBox(colorIn);
            }
            case CRYSTAL: {
                return new TileEntityCrystalShulkerBox(colorIn);
            }
            case OBSIDIAN: {
                return new TileEntityObsidianShulkerBox(colorIn);
            }
        }
        return null;
    }

    static {
        VALUES = IronShulkerBoxType.values();
    }
}

