/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.items;

import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.items.chest.ItemChestChanger;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public enum ChestChangerType {
    IRON_GOLD(IronChestType.IRON, IronChestType.GOLD, "iron_gold_chest_upgrade", "mmm", "msm", "mmm"),
    GOLD_DIAMOND(IronChestType.GOLD, IronChestType.DIAMOND, "gold_diamond_chest_upgrade", "GGG", "msm", "GGG"),
    COPPER_SILVER(IronChestType.COPPER, IronChestType.SILVER, "copper_silver_chest_upgrade", "mmm", "msm", "mmm"),
    SILVER_GOLD(IronChestType.SILVER, IronChestType.GOLD, "silver_gold_chest_upgrade", "mGm", "GsG", "mGm"),
    COPPER_IRON(IronChestType.COPPER, IronChestType.IRON, "copper_iron_chest_upgrade", "mGm", "GsG", "mGm"),
    DIAMOND_CRYSTAL(IronChestType.DIAMOND, IronChestType.CRYSTAL, "diamond_crystal_chest_upgrade", "GGG", "GOG", "GGG"),
    WOOD_IRON(IronChestType.WOOD, IronChestType.IRON, "wood_iron_chest_upgrade", "mmm", "msm", "mmm"),
    WOOD_COPPER(IronChestType.WOOD, IronChestType.COPPER, "wood_copper_chest_upgrade", "mmm", "msm", "mmm"),
    DIAMOND_OBSIDIAN(IronChestType.DIAMOND, IronChestType.OBSIDIAN, "diamond_obsidian_chest_upgrade", "mmm", "mGm", "mmm");

    public static final ChestChangerType[] VALUES;
    public final IronChestType source;
    public final IronChestType target;
    public final String itemName;
    public ItemChestChanger item;
    private String[] recipe;

    private ChestChangerType(IronChestType source, IronChestType target, String itemName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(IronChestType from) {
        return from == this.source;
    }

    public ItemChestChanger buildItem() {
        this.item = new ItemChestChanger(this);
        this.item.setRegistryName(this.itemName);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.matList) {
            for (String targetMat : this.target.matList) {
                Object targetMaterial = IronChestType.translateOreName(targetMat);
                Object sourceMaterial = IronChestType.translateOreName(sourceMat);
                IronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), "blockGlass", Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (ChestChangerType type : VALUES) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (ChestChangerType item : VALUES) {
            item.addRecipes();
        }
    }

    static {
        VALUES = ChestChangerType.values();
    }
}

