/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.items;

import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.items.shulker.ItemShulkerBoxChanger;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public enum ShulkerBoxChangerType {
    IRON_GOLD(IronShulkerBoxType.IRON, IronShulkerBoxType.GOLD, "iron_gold_shulker_upgrade", "mmm", "msm", "mmm"),
    GOLD_DIAMOND(IronShulkerBoxType.GOLD, IronShulkerBoxType.DIAMOND, "gold_diamond_shulker_upgrade", "GGG", "msm", "GGG"),
    COPPER_SILVER(IronShulkerBoxType.COPPER, IronShulkerBoxType.SILVER, "copper_silver_shulker_upgrade", "mmm", "msm", "mmm"),
    SILVER_GOLD(IronShulkerBoxType.SILVER, IronShulkerBoxType.GOLD, "silver_gold_shulker_upgrade", "mGm", "GsG", "mGm"),
    COPPER_IRON(IronShulkerBoxType.COPPER, IronShulkerBoxType.IRON, "copper_iron_shulker_upgrade", "mGm", "GsG", "mGm"),
    DIAMOND_CRYSTAL(IronShulkerBoxType.DIAMOND, IronShulkerBoxType.CRYSTAL, "diamond_crystal_shulker_upgrade", "GGG", "GOG", "GGG"),
    VANILLA_IRON(IronShulkerBoxType.VANILLA, IronShulkerBoxType.IRON, "vanilla_iron_shulker_upgrade", "mmm", "msm", "mmm"),
    VANILLA_COPPER(IronShulkerBoxType.VANILLA, IronShulkerBoxType.COPPER, "vanilla_copper_shulker_upgrade", "mmm", "msm", "mmm"),
    DIAMOND_OBSIDIAN(IronShulkerBoxType.DIAMOND, IronShulkerBoxType.OBSIDIAN, "diamond_obsidian_shulker_upgrade", "mmm", "mGm", "mmm");

    public static final ShulkerBoxChangerType[] VALUES;
    public final IronShulkerBoxType source;
    public final IronShulkerBoxType target;
    public final String itemName;
    public ItemShulkerBoxChanger item;
    private String[] recipe;

    private ShulkerBoxChangerType(IronShulkerBoxType source, IronShulkerBoxType target, String itemName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(IronShulkerBoxType from) {
        return from == this.source;
    }

    public ItemShulkerBoxChanger buildItem() {
        this.item = new ItemShulkerBoxChanger(this);
        this.item.setRegistryName(this.itemName);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.matList) {
            for (String targetMat : this.target.matList) {
                Object targetMaterial = IronShulkerBoxType.translateOreName(targetMat);
                Object sourceMaterial = IronShulkerBoxType.translateOreName(sourceMat);
                IronShulkerBoxType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), "blockGlass", Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (ShulkerBoxChangerType type : VALUES) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (ShulkerBoxChangerType item : VALUES) {
            item.addRecipes();
        }
    }

    static {
        VALUES = ShulkerBoxChangerType.values();
    }
}

