/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIronChest
extends Block {
    public static final PropertyEnum<IronChestType> VARIANT_PROP = PropertyEnum.func_177709_a((String)"variant", IronChestType.class);
    protected static final AxisAlignedBB IRON_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final EnumFacing[] validRotationAxes = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};

    public BlockIronChest() {
        super(Material.field_151573_f);
        this.setRegistryName(new ResourceLocation("IronChest", "BlockIronChest"));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.IRON)));
        this.func_149711_c(3.0f);
        this.func_149663_c("IronChest");
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return IRON_CHEST_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing direction, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityIronChest)) {
            return true;
        }
        if (world.isSideSolid(pos.func_177982_a(0, 1, 0), EnumFacing.DOWN)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)IronChest.instance, ((TileEntityIronChest)te).getType().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).makeEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (IronChestType type : IronChestType.VALUES) {
            if (!type.isValidForCreativeMode()) continue;
            list.add(new ItemStack(itemIn, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((IronChestType)((Object)blockState.func_177229_b(VARIANT_PROP))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROP});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState blockState) {
        super.func_176213_c(world, pos, blockState);
        world.func_184138_a(pos, blockState, blockState, 3);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState blockState, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronChest) {
            TileEntityIronChest teic = (TileEntityIronChest)te;
            teic.wasPlaced(entityliving, itemStack);
            teic.setFacing(entityliving.func_174811_aO().func_176734_d());
            world.func_184138_a(pos, blockState, blockState, 3);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).ordinal();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        TileEntityIronChest tileentitychest = (TileEntityIronChest)world.func_175625_s(pos);
        if (tileentitychest != null) {
            tileentitychest.removeAdornments();
            this.dropContent(0, tileentitychest, world, tileentitychest.func_174877_v());
        }
        super.func_180663_b(world, pos, blockState);
    }

    public void dropContent(int newSize, IInventory chest, World world, BlockPos pos) {
        Random random = world.field_73012_v;
        for (int l = newSize; l < chest.func_70302_i_(); ++l) {
            ItemStack itemstack = chest.func_70301_a(l);
            if (itemstack == null) continue;
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int i1 = random.nextInt(21) + 10;
                if (i1 > itemstack.field_77994_a) {
                    i1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= i1;
                EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + (float)(newSize > 0 ? 1 : 0) + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), i1, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityIronChest teic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronChest && (teic = (TileEntityIronChest)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == EnumFacing.UP || axis == EnumFacing.DOWN) {
            TileEntity tileEntity = worldObj.func_175625_s(pos);
            if (tileEntity instanceof TileEntityIronChest) {
                TileEntityIronChest icte = (TileEntityIronChest)tileEntity;
                icte.rotateAround();
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }
}

