/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ContainerIronChest;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityIronChest
extends TileEntityLockable
implements ITickable,
IInventory {
    private int ticksSinceSync = -1;
    public float prevLidAngle;
    public float lidAngle;
    private int numPlayersUsing;
    public ItemStack[] chestContents;
    private ItemStack[] topStacks;
    private EnumFacing facing;
    private boolean inventoryTouched;
    private boolean hadStuff;
    private String customName;
    private IronChestType chestType;

    public TileEntityIronChest() {
        this(IronChestType.IRON);
    }

    protected TileEntityIronChest(IronChestType type) {
        this.chestType = type;
        this.chestContents = new ItemStack[type.size];
        this.topStacks = new ItemStack[8];
        this.facing = EnumFacing.NORTH;
    }

    public void setContents(ItemStack[] contents) {
        this.chestContents = new ItemStack[this.getType().size];
        for (int i = 0; i < contents.length; ++i) {
            if (i >= this.chestContents.length) continue;
            this.chestContents[i] = contents[i];
        }
        this.inventoryTouched = true;
    }

    public int func_70302_i_() {
        return this.chestContents.length;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public IronChestType getType() {
        IBlockState state;
        IronChestType type = IronChestType.IRON;
        if (this.func_145830_o() && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == IronChest.ironChestBlock) {
            type = (IronChestType)((Object)state.func_177229_b(BlockIronChest.VARIANT_PROP));
        }
        return type;
    }

    public ItemStack func_70301_a(int index) {
        this.inventoryTouched = true;
        return this.chestContents[index];
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sortTopStacks();
    }

    protected void sortTopStacks() {
        int i;
        if (!this.getType().isTransparent() || this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack[] tempCopy = new ItemStack[this.func_70302_i_()];
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.chestContents[i] == null) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                if (!tempCopy[j].func_77969_a(this.chestContents[i])) continue;
                tempCopy[j].field_77994_a += this.chestContents[i].field_77994_a;
                continue block0;
            }
            tempCopy[compressedIdx++] = this.chestContents[i].func_77946_l();
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.topStacks.length; ++i) {
                this.topStacks[i] = null;
            }
            if (this.field_145850_b != null) {
                IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            }
            return;
        }
        this.hadStuff = true;
        Arrays.sort(tempCopy, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o2.field_77994_a - o1.field_77994_a;
            }
        });
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element == null || element.field_77994_a <= 0) continue;
            this.topStacks[p++] = element;
            if (p == this.topStacks.length) break;
        }
        for (int i2 = p; i2 < this.topStacks.length; ++i2) {
            this.topStacks[i2] = null;
        }
        if (this.field_145850_b != null) {
            IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
        }
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.chestContents[index] != null) {
            if (this.chestContents[index].field_77994_a <= count) {
                ItemStack stack = this.chestContents[index];
                this.chestContents[index] = null;
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.chestContents[index].func_77979_a(count);
            if (this.chestContents[index].field_77994_a == 0) {
                this.chestContents[index] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.chestContents[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.getType().name();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList tagList = compound.func_150295_c("Items", 10);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.chestContents.length) continue;
            this.chestContents[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
        this.sortTopStacks();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.chestContents.length; ++slot) {
            if (this.chestContents[slot] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)slot);
            this.chestContents[slot].func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p()) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - f), (double)((float)this.field_174879_c.func_177956_o() - f), (double)((float)this.field_174879_c.func_177952_p() - f), (double)((float)(this.field_174879_c.func_177958_n() + 1) + f), (double)((float)(this.field_174879_c.func_177956_o() + 1) + f), (double)((float)(this.field_174879_c.func_177952_p() + 1) + f)))) {
                if (!(player.field_71070_bA instanceof ContainerIronChest)) continue;
                ++this.numPlayersUsing;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 3, this.numPlayersUsing << 3 & 0xF8 | this.facing.ordinal() & 7);
        }
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float angle = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y = (double)this.field_174879_c.func_177956_o() + 0.5;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float maxAngle;
            float currentAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += angle) : (this.lidAngle -= angle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (maxAngle = 0.5f) && currentAngle >= maxAngle) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5;
                double y = (double)this.field_174879_c.func_177956_o() + 0.5;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
        } else if (id == 2) {
            this.facing = EnumFacing.field_82609_l[type];
        } else if (id == 3) {
            this.facing = EnumFacing.field_82609_l[type & 7];
            this.numPlayersUsing = (type & 0xF8) >> 3;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145850_b == null) {
                return;
            }
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 1, this.numPlayersUsing);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145850_b == null) {
                return;
            }
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 1, this.numPlayersUsing);
        }
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public ItemStack[] getTopItemStacks() {
        return this.topStacks;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        ItemStack[] stacks = this.buildItemStackDataList();
        if (stacks != null) {
            NBTTagList tagList = new NBTTagList();
            for (int slot = 0; slot < stacks.length; ++slot) {
                if (stacks[slot] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)slot);
                stacks[slot].func_77955_b(tag);
                tagList.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a("stacks", (NBTBase)tagList);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            NBTTagCompound compound = pkt.func_148857_g();
            this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
            NBTTagList tagList = compound.func_150295_c("stacks", 10);
            ItemStack[] stacks = new ItemStack[this.topStacks.length];
            for (int item = 0; item < stacks.length; ++item) {
                NBTTagCompound itemStack = tagList.func_150305_b(item);
                int slot = itemStack.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= stacks.length) continue;
                stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemStack);
            }
            if (this.getType().isTransparent() && stacks != null) {
                int pos = 0;
                for (int i = 0; i < this.topStacks.length; ++i) {
                    this.topStacks[i] = stacks[pos] != null ? stacks[pos] : null;
                    ++pos;
                }
            }
        }
    }

    public ItemStack[] buildItemStackDataList() {
        if (this.getType().isTransparent()) {
            ItemStack[] sortList = new ItemStack[this.topStacks.length];
            int pos = 0;
            for (ItemStack is : this.topStacks) {
                sortList[pos++] = is != null ? is : null;
            }
            return sortList;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.chestContents[index] != null) {
            ItemStack stack = this.chestContents[index];
            this.chestContents[index] = null;
            return stack;
        }
        return null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getType().acceptsStack(stack);
    }

    public void rotateAround() {
        this.setFacing(this.facing.func_176746_e());
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 2, this.facing.ordinal());
    }

    public void wasPlaced(EntityLivingBase entityliving, ItemStack stack) {
    }

    public void removeAdornments() {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.chestContents.length; ++slot) {
            this.chestContents[slot] = null;
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIronChest((IInventory)playerInventory, this, this.chestType, this.chestType.xSize, this.chestType.ySize);
    }

    public String func_174875_k() {
        return "IronChest:" + this.getType().name();
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

