/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.physics;

import com.creativemd.creativecore.common.utils.sorting.SortingList;
import com.creativemd.creativecore.common.utils.stack.InfoFuel;
import com.creativemd.creativecore.common.utils.stack.InfoName;
import com.creativemd.itemphysic.ItemDummyContainer;
import com.creativemd.itemphysic.physics.CommonPhysic;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ServerPhysic {
    public static Random rand = new Random();
    public static SortingList swimmingItems = new SortingList();
    public static SortingList burningItems = new SortingList();
    public static SortingList undestroyableItems = new SortingList();
    public static SortingList ignitingItems = new SortingList();
    public static DataParameter<Optional<ItemStack>> ITEM = null;
    public static Fluid fluid;

    public static void loadItemList() {
        swimmingItems.addSortingObjects(new Object[]{Material.field_151575_d, Material.field_151580_n, Material.field_151583_m, Material.field_151598_x, Material.field_151588_w, Material.field_151584_j, Material.field_151585_k, Material.field_151593_r, Material.field_151597_y, Material.field_151570_A, Material.field_151568_F, Material.field_151582_l, Material.field_151569_G, Blocks.field_150433_aE, new InfoName("wooden"), Items.field_151034_e, Items.field_151031_f, Items.field_151054_z, Items.field_151032_g, Items.field_151034_e, Items.field_151007_F, Items.field_151008_G, Items.field_151015_O, Items.field_151025_P, Items.field_151159_an, Items.field_151155_ap, Items.field_185153_aK, Items.field_179572_au, Items.field_185154_aL, Items.field_179571_av, Items.field_185151_aI, Items.field_179568_as, Items.field_185152_aJ, Items.field_179567_at, Items.field_151124_az, Items.field_179570_aq, Items.field_185150_aH, Items.field_179569_ar, Items.field_151141_av, Items.field_151103_aS, Items.field_151102_aT, Items.field_151110_aK, Items.field_151112_aM, Items.field_151100_aR, Items.field_151105_aU, Items.field_151104_aV, Items.field_151127_ba, Items.field_151097_aZ, Items.field_151172_bF, Items.field_151174_bG, Items.field_151170_bI, Items.field_151168_bH, Items.field_151158_bO, Items.field_185160_cR, Items.field_179561_bm, Items.field_179557_bn, Items.field_179558_bo, Items.field_179559_bp, Items.field_179560_bq, Items.field_185164_cV, Items.field_185163_cU, Items.field_185165_cW, Items.field_185159_cQ, Items.field_151014_N, Items.field_151080_bb, Items.field_151081_bc, Items.field_151126_ay});
        burningItems.addSortingObjects(new Object[]{Material.field_151575_d, Material.field_151580_n, Material.field_151583_m, Material.field_151598_x, Material.field_151588_w, Material.field_151584_j, Material.field_151585_k, Material.field_151593_r, Material.field_151597_y, Material.field_151570_A, Material.field_151568_F, Material.field_151582_l, Material.field_151569_G, Material.field_151577_b, Blocks.field_150433_aE, new InfoName("axe"), new InfoName("wooden"), new InfoName("shovel"), new InfoName("hoe"), new InfoName("sword"), Items.field_151034_e, Items.field_151031_f, Items.field_151054_z, Items.field_151032_g, Items.field_151034_e, Items.field_151007_F, Items.field_151008_G, Items.field_151015_O, Items.field_151025_P, Items.field_151116_aA, Items.field_151021_T, Items.field_151027_R, Items.field_151024_Q, Items.field_151026_S, Items.field_151058_ca, Items.field_151159_an, Items.field_151155_ap, Items.field_185153_aK, Items.field_179572_au, Items.field_185154_aL, Items.field_179571_av, Items.field_185151_aI, Items.field_179568_as, Items.field_185152_aJ, Items.field_179567_at, Items.field_151124_az, Items.field_179570_aq, Items.field_185150_aH, Items.field_179569_ar, Items.field_151141_av, Items.field_151103_aS, Items.field_151102_aT, Items.field_151121_aF, Items.field_151122_aG, Items.field_151110_aK, Items.field_151112_aM, Items.field_151100_aR, Items.field_151105_aU, Items.field_151104_aV, Items.field_151127_ba, Items.field_151097_aZ, Items.field_151099_bA, Items.field_151164_bB, Items.field_151172_bF, Items.field_151174_bG, Items.field_151170_bI, Items.field_151168_bH, Items.field_151148_bJ, Items.field_151158_bO, Items.field_151057_cb, Items.field_151134_bR, Items.field_185160_cR, Items.field_179561_bm, Items.field_179557_bn, Items.field_179558_bo, Items.field_179559_bp, Items.field_179560_bq, Items.field_185164_cV, Items.field_185163_cU, Items.field_185165_cW, Items.field_185159_cQ, Items.field_151014_N, Items.field_151080_bb, Items.field_151081_bc, new InfoFuel(), Items.field_151070_bp, Items.field_151078_bh, Items.field_151126_ay});
        undestroyableItems.addSortingObjects(new Object[]{Items.field_151156_bN, Blocks.field_150357_h, Blocks.field_150343_Z, Material.field_175972_I});
        ignitingItems.addSortingObjects(new Object[]{Material.field_151587_i, Blocks.field_150478_aa, Items.field_151129_at, Items.field_151065_br});
    }

    public static void updatePre(EntityItem item) {
        ItemStack stack = item.func_92059_d();
        float f = 0.98f;
        fluid = CommonPhysic.getFluid(item);
        if (fluid == null) {
            item.field_70181_x -= 0.04;
        } else {
            double maxSpeedReduction;
            double speedreduction;
            double density = (double)fluid.getDensity() / 1000.0;
            double speed = -1.0 / density * 0.01;
            if (swimmingItems.canPass(stack)) {
                speed = 0.05;
            }
            if ((speedreduction = (speed - item.field_70181_x) / 2.0) < -(maxSpeedReduction = 0.05)) {
                speedreduction = -maxSpeedReduction;
            }
            if (speedreduction > maxSpeedReduction) {
                speedreduction = maxSpeedReduction;
            }
            item.field_70181_x += speedreduction;
            f = (float)(1.0 / density / 1.2);
        }
    }

    public static void updateBurn(EntityItem item) {
        IBlockState state;
        if (item.field_70170_p.func_180495_p(new BlockPos((Entity)item)).func_185904_a() == Material.field_151587_i && burningItems.canPass(item.func_92059_d())) {
            item.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + rand.nextFloat() * 0.4f);
            for (int i = 0; i < 100; ++i) {
                item.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, item.field_70165_t, item.field_70163_u, item.field_70161_v, (double)rand.nextFloat() * 0.1 - 0.05, 0.2 * rand.nextDouble(), (double)rand.nextFloat() * 0.1 - 0.05, new int[0]);
            }
        }
        if (ItemDummyContainer.enableIgniting && !item.field_70170_p.field_72995_K && item.field_70122_E && Math.random() <= 0.1 && ignitingItems.canPass(item.func_92059_d()) && (state = item.field_70170_p.func_180495_p(new BlockPos((Entity)item).func_177977_b())).func_185904_a().func_76217_h()) {
            item.field_70170_p.func_175656_a(new BlockPos((Entity)item), Blocks.field_150480_ab.func_176223_P());
        }
    }

    public static void updatePost(EntityItem item) {
        if (fluid == null) {
            item.field_70181_x *= 0.98;
            if (item.field_70122_E) {
                item.field_70181_x *= -0.5;
            }
        } else {
            item.field_70159_w /= (double)fluid.getDensity() / 950.0;
            item.field_70179_y /= (double)fluid.getDensity() / 950.0;
        }
        if (item.lifespan == 6000 && item.lifespan != ItemDummyContainer.despawnItem) {
            item.lifespan = ItemDummyContainer.despawnItem;
        }
    }

    public static int getAge(EntityItem item) {
        return (Integer)ReflectionHelper.getPrivateValue(EntityItem.class, (Object)item, (String[])new String[]{"age", "field_70292_b"});
    }

    public static void updateFallState(EntityItem item, double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (onGroundIn && item.field_70143_R > 0.0f) {
            item.func_184185_a(SoundEvents.field_187548_af, Math.min(1.0f, item.field_70143_R / 10.0f), (float)Math.random() * 1.0f + 1.0f);
        }
    }

    public static boolean onCollideWithPlayer(EntityItem item, EntityPlayer par1EntityPlayer) {
        if (ItemDummyContainer.customPickup && !par1EntityPlayer.func_70093_af()) {
            return true;
        }
        return item.field_70170_p.field_72995_K || item.func_174874_s();
    }

    public static void onCollideWithPlayer(EntityItem item, EntityPlayer player, boolean needsSneak) {
        if (ItemDummyContainer.customPickup && needsSneak && !player.func_70093_af()) {
            return;
        }
        if (!item.field_70170_p.field_72995_K) {
            if (!ItemDummyContainer.customPickup && item.func_174874_s()) {
                return;
            }
            ItemStack itemstack = item.func_92059_d();
            int i = itemstack.field_77994_a;
            int hook = ForgeEventFactory.onItemPickup((EntityItem)item, (EntityPlayer)player, (ItemStack)itemstack);
            if (hook < 0) {
                return;
            }
            if (!(item.func_174874_s() && !ItemDummyContainer.customPickup || item.func_145798_i() != null && item.lifespan - ServerPhysic.getAge(item) > 200 && !item.func_145798_i().equals(player.func_70005_c_()) || hook != 1 && i > 0 && !player.field_71071_by.func_70441_a(itemstack))) {
                EntityPlayer entityplayer;
                if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150364_r)) {
                    player.func_71029_a((StatBase)AchievementList.field_187983_g);
                }
                if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150363_s)) {
                    player.func_71029_a((StatBase)AchievementList.field_187983_g);
                }
                if (itemstack.func_77973_b() == Items.field_151116_aA) {
                    player.func_71029_a((StatBase)AchievementList.field_76022_t);
                }
                if (itemstack.func_77973_b() == Items.field_151045_i) {
                    player.func_71029_a((StatBase)AchievementList.field_187995_w);
                }
                if (itemstack.func_77973_b() == Items.field_151072_bj) {
                    player.func_71029_a((StatBase)AchievementList.field_187969_A);
                }
                if (itemstack.func_77973_b() == Items.field_151045_i && item.func_145800_j() != null && (entityplayer = item.field_70170_p.func_72924_a(item.func_145800_j())) != null && entityplayer != player) {
                    entityplayer.func_71029_a((StatBase)AchievementList.field_187996_x);
                }
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, item);
                if (!item.func_174814_R()) {
                    item.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                player.func_71001_a((Entity)item, i);
                if (itemstack.field_77994_a <= 0) {
                    item.func_70106_y();
                }
                player.func_71064_a(StatList.func_188056_d((Item)itemstack.func_77973_b()), i);
            }
        }
    }

    public static boolean processInitialInteract(EntityItem item, EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (ItemDummyContainer.customPickup) {
            ServerPhysic.onCollideWithPlayer(item, player, false);
            return true;
        }
        return false;
    }

    public static boolean attackEntityFrom(EntityItem item, DamageSource source, float amount) {
        if (item.func_180431_b(source)) {
            return false;
        }
        if (item.func_92059_d() != null && undestroyableItems.canPass(item.func_92059_d())) {
            return false;
        }
        if (source == DamageSource.field_76371_c | source == DamageSource.field_76370_b | source == DamageSource.field_76372_a && !burningItems.canPass(item.func_92059_d())) {
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        try {
            ReflectionHelper.findMethod(Entity.class, (Object)item, (String[])new String[]{"setBeenAttacked", "func_70018_K"}, (Class[])new Class[0]).invoke((Object)item, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Field health = ReflectionHelper.findField(EntityItem.class, (String[])new String[]{"health", "field_70291_e"});
            health.setInt(item, (int)((float)health.getInt(item) - amount));
            if (health.getInt(item) <= 0) {
                item.func_70106_y();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isItemBurning(EntityItem item) {
        boolean flag = item.field_70170_p != null && item.field_70170_p.field_72995_K;
        try {
            if (item.func_70045_F() || (Integer)ReflectionHelper.getPrivateValue(Entity.class, (Object)item, (String[])new String[]{"fire", "field_70151_c"}) <= 0 && (!flag || !((Boolean)ReflectionHelper.findMethod(Entity.class, (Object)item, (String[])new String[]{"getFlag", "func_70083_f"}, (Class[])new Class[]{Integer.TYPE}).invoke((Object)item, 0)).booleanValue())) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return burningItems.canPass(item.func_92059_d());
    }
}

