/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;

@OnlyIn(value=Dist.CLIENT)
public class ItemPhysicClient {
    public static KeyBinding pickup = new KeyBinding("key.pickup.item", InputMappings.field_197958_a.func_197937_c(), "key.categories.gameplay");
    public static Minecraft mc;
    public static long lastTickTime;
    public static int throwingPower;

    public static void init(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)pickup);
        mc = (Minecraft)event.getMinecraftSupplier().get();
        MinecraftForge.EVENT_BUS.register(ItemPhysicClient.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            lastTickTime = System.nanoTime();
        }
        ItemPhysicClient.renderTickFull();
    }

    public static boolean renderItem(ItemEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, ItemRenderer itemRenderer, Random random) {
        boolean applyEffects;
        if (entityIn.func_174872_o() == 0) {
            return false;
        }
        matrixStackIn.func_227860_a_();
        ItemStack itemstack = entityIn.func_92059_d();
        int i = itemstack.func_190926_b() ? 187 : Item.func_150891_b((Item)itemstack.func_77973_b()) + itemstack.func_77952_i();
        random.setSeed(i);
        IBakedModel ibakedmodel = itemRenderer.func_184393_a(itemstack, entityIn.field_70170_p, (LivingEntity)null);
        boolean flag = ibakedmodel.func_177556_c();
        int j = ItemPhysicClient.getModelCount(itemstack);
        float rotateBy = (float)(System.nanoTime() - lastTickTime) / 2.0E8f;
        if (mc.func_147113_T()) {
            rotateBy = 0.0f;
        }
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(1.5707964f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(entityIn.field_70177_z));
        boolean bl = applyEffects = entityIn.func_174872_o() != 0 && (flag || ItemPhysicClient.mc.func_175598_ae().field_78733_k != null);
        if (applyEffects) {
            Fluid fluid;
            if (flag) {
                if (!entityIn.field_70122_E) {
                    rotateBy *= 2.0f;
                    fluid = CommonPhysic.getFluid(entityIn);
                    if (fluid == null) {
                        fluid = CommonPhysic.getFluid(entityIn, true);
                    }
                    if (fluid != null) {
                        rotateBy /= (float)(fluid.getAttributes().getDensity() / 1000 * 10);
                    }
                    entityIn.field_70125_A += rotateBy;
                }
            } else if (!(entityIn == null || Double.isNaN(entityIn.func_226277_ct_()) || Double.isNaN(entityIn.func_226278_cu_()) || Double.isNaN(entityIn.func_226281_cx_()) || entityIn.field_70170_p == null)) {
                if (entityIn.field_70122_E) {
                    if (!flag) {
                        entityIn.field_70125_A = 0.0f;
                    }
                } else {
                    rotateBy *= 2.0f;
                    fluid = CommonPhysic.getFluid(entityIn);
                    if (fluid != null) {
                        rotateBy /= (float)(fluid.getAttributes().getDensity() / 1000 * 10);
                    }
                    entityIn.field_70125_A += rotateBy;
                }
            }
            if (flag) {
                matrixStackIn.func_227861_a_(0.0, -0.2, -0.08);
            } else if (entityIn.field_70170_p.func_180495_p(entityIn.func_180425_c()).func_177230_c() == Blocks.field_150433_aE || entityIn.field_70170_p.func_180495_p(entityIn.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150425_aM) {
                matrixStackIn.func_227861_a_(0.0, 0.0, -0.14);
            } else {
                matrixStackIn.func_227861_a_(0.0, 0.0, -0.04);
            }
            double height = 0.2;
            if (flag) {
                matrixStackIn.func_227861_a_(0.0, height, 0.0);
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(entityIn.field_70125_A));
            if (flag) {
                matrixStackIn.func_227861_a_(0.0, -height, 0.0);
            }
        }
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            matrixStackIn.func_227861_a_((double)f7, (double)f8, (double)f9);
        }
        for (int k = 0; k < j; ++k) {
            matrixStackIn.func_227860_a_();
            if (k > 0 && flag) {
                float f11 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float f13 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float f10 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                matrixStackIn.func_227861_a_((double)f11, (double)f13, (double)f10);
            }
            itemRenderer.func_229111_a_(itemstack, ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, ibakedmodel);
            matrixStackIn.func_227865_b_();
            if (flag) continue;
            matrixStackIn.func_227861_a_(0.0, 0.0, (double)0.05375f);
        }
        matrixStackIn.func_227865_b_();
        return true;
    }

    public static int getModelCount(ItemStack stack) {
        if (stack.func_190916_E() > 48) {
            return 5;
        }
        if (stack.func_190916_E() > 32) {
            return 4;
        }
        if (stack.func_190916_E() > 16) {
            return 3;
        }
        if (stack.func_190916_E() > 1) {
            return 2;
        }
        return 1;
    }

    public static boolean onPlayerInteractClient(World world, PlayerEntity player, boolean rightClick) {
        RayTraceResult result = ItemPhysicClient.getEntityItem((PlayerEntity)ItemPhysicClient.mc.field_71439_g);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            ItemEntity entity = (ItemEntity)((EntityRayTraceResult)result).func_216348_a();
            if (world.field_72995_K && entity != null) {
                player.func_184609_a(Hand.MAIN_HAND);
                ItemPhysic.NETWORK.sendToServer((CreativePacket)new PickupPacket(entity.func_110124_au(), rightClick));
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        World world = event.getWorld();
        if ((event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteract) && world.field_72995_K && ItemPhysic.CONFIG.pickup.customPickup) {
            if (!pickup.getKey().equals((Object)InputMappings.field_197958_a)) {
                return;
            }
            if (ItemPhysicClient.onPlayerInteractClient(world, event.getPlayer(), event instanceof PlayerInteractEvent.RightClickBlock) && event instanceof PlayerInteractEvent.RightClickBlock) {
                ((PlayerInteractEvent.RightClickBlock)event).setUseBlock(Event.Result.DENY);
                ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static RayTraceResult getEntityItem(PlayerEntity player) {
        Vec3d vec3d3;
        double d2;
        AxisAlignedBB axisalignedbb;
        EntityRayTraceResult entityraytraceresult;
        double distance = CommonPhysic.getReachDistance(player);
        float partialTicks = mc.func_184121_ak();
        Vec3d position = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d look = position.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        BlockRayTraceResult result = ItemPhysicClient.mc.field_71441_e.func_217299_a(new RayTraceContext(position, look, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (result != null) {
            distance = result.func_216347_e().func_72436_e(position);
        }
        if ((entityraytraceresult = ProjectileHelper.func_221273_a((Entity)player, (Vec3d)position, (Vec3d)look, (AxisAlignedBB)(axisalignedbb = player.func_174813_aQ().func_216361_a(vec3d1.func_186678_a(distance)).func_72314_b(1.0, 1.0, 1.0)), p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), (double)distance)) != null && ((d2 = position.func_72436_e(vec3d3 = entityraytraceresult.func_216347_e())) < distance || result == null)) {
            result = entityraytraceresult;
            distance = d2;
        }
        return CommonPhysic.getEntityItem(player, position, position.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance), distance);
    }

    public static void renderTickFull() {
        if (mc != null && ItemPhysicClient.mc.field_71439_g != null && !mc.func_147113_T()) {
            RayTraceResult result;
            if (ItemPhysic.CONFIG.pickup.customPickup && (result = ItemPhysicClient.getEntityItem((PlayerEntity)ItemPhysicClient.mc.field_71439_g)) != null && result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                ItemEntity entity;
                if (pickup.func_151470_d()) {
                    ItemPhysicClient.onPlayerInteractClient((World)ItemPhysicClient.mc.field_71441_e, (PlayerEntity)ItemPhysicClient.mc.field_71439_g, false);
                }
                if ((entity = (ItemEntity)((EntityRayTraceResult)result).func_216348_a()) != null && ItemPhysic.CONFIG.rendering.showPickupTooltip) {
                    String text;
                    int i;
                    int space = 15;
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        entity.func_92059_d().func_77973_b().func_77624_a(entity.func_92059_d(), ItemPhysicClient.mc.field_71439_g.field_70170_p, list, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                        list.add(entity.func_92059_d().func_200301_q());
                    }
                    catch (Exception e) {
                        list = new ArrayList();
                        list.add(new StringTextComponent("ERRORED"));
                    }
                    int width = 0;
                    for (i = 0; i < list.size(); ++i) {
                        text = ((ITextComponent)list.get(i)).getString();
                        width = Math.max(width, ItemPhysicClient.mc.field_71466_p.func_78256_a(text) + 10);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.enableAlphaTest();
                    RenderSystem.enableTexture();
                    for (i = 0; i < list.size(); ++i) {
                        text = ((ITextComponent)list.get(i)).getString();
                        ItemPhysicClient.mc.field_71466_p.func_211126_b(text, (float)(mc.func_228018_at_().func_198107_o() / 2 - ItemPhysicClient.mc.field_71466_p.func_78256_a(text) / 2), (float)(mc.func_228018_at_().func_198087_p() / 2 + (list.size() / 2 * space - space * (i + 1))), 0xFCFCFC);
                    }
                }
            }
            if (ItemPhysic.CONFIG.general.customThrow && !ItemPhysic.CONFIG.rendering.disableThrowHUD && throwingPower > 0) {
                int renderPower = throwingPower;
                if ((renderPower /= 6) < 1) {
                    renderPower = 1;
                }
                if (renderPower > 6) {
                    renderPower = 6;
                }
                String text = "Power: " + renderPower;
                ItemPhysicClient.mc.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(text), true);
            }
        }
    }

    @SubscribeEvent
    public static void gameTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ItemPhysicClient.mc.field_71439_g != null && ItemPhysicClient.mc.field_71439_g.func_184614_ca() != null && ItemPhysic.CONFIG.general.customThrow) {
            if (ItemPhysicClient.mc.field_71474_y.field_74316_C.func_151470_d()) {
                ++throwingPower;
            } else {
                if (throwingPower > 0) {
                    if ((throwingPower /= 6) < 1) {
                        throwingPower = 1;
                    }
                    if (throwingPower > 6) {
                        throwingPower = 6;
                    }
                    boolean dropAll = Screen.hasControlDown();
                    ItemPhysic.NETWORK.sendToServer((CreativePacket)new DropPacket(throwingPower));
                    CPlayerDiggingPacket.Action cplayerdiggingpacket$action = dropAll ? CPlayerDiggingPacket.Action.DROP_ALL_ITEMS : CPlayerDiggingPacket.Action.DROP_ITEM;
                    ItemPhysicClient.mc.field_71439_g.field_71174_a.func_147297_a((IPacket)new CPlayerDiggingPacket(cplayerdiggingpacket$action, BlockPos.field_177992_a, Direction.DOWN));
                    if (ItemPhysicClient.mc.field_71439_g.field_71071_by.func_70298_a(ItemPhysicClient.mc.field_71439_g.field_71071_by.field_70461_c, dropAll && !ItemPhysicClient.mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b() ? ItemPhysicClient.mc.field_71439_g.field_71071_by.func_70448_g().func_190916_E() : 1) != ItemStack.field_190927_a) {
                        ItemPhysicClient.mc.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                    }
                }
                throwingPower = 0;
            }
        }
    }

    public static boolean dropItem(boolean dropAll) {
        return ItemPhysic.CONFIG.general.customThrow;
    }
}

