/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.keybinding.FabricKeyBinding;
import net.fabricmc.fabric.api.client.keybinding.KeyBindingRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.client.KeyParser;
import ru.bulldog.justmap.client.config.ConfigFactory;
import ru.bulldog.justmap.map.Worldmap;
import ru.bulldog.justmap.map.waypoint.WaypointsList;

public final class KeyHandler {
    private static List<KeyParser> parsers;

    private KeyHandler() {
    }

    public static void initKeyBindings() {
        parsers = new ArrayList<KeyParser>();
        KeyBindingRegistry.INSTANCE.addCategory("justmap");
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("create_waypoint", 66)){

            @Override
            public void onKeyUp() {
                JustMapClient.MAP.createWaypoint();
            }

            @Override
            public boolean isListening() {
                return 1.MC.field_1724 != null && 1.MC.field_1755 == null;
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("toggle_map_visible", 72)){

            @Override
            public void onKeyUp() {
                JustMapClient.CONFIG.setBoolean("map_visible", !JustMapClient.CONFIG.getBoolean("map_visible"));
                JustMapClient.CONFIG.saveChanges();
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("toggle_big_map", 78)){

            @Override
            public void onKeyUp() {
                JustMapClient.CONFIG.setBoolean("show_big_map", !JustMapClient.CONFIG.getBoolean("show_big_map"));
                JustMapClient.CONFIG.saveChanges();
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("toggle_show_caves", 75)){

            @Override
            public void onKeyUp() {
                JustMapClient.CONFIG.setBoolean("show_caves", !JustMapClient.CONFIG.getBoolean("show_caves"));
                JustMapClient.CONFIG.saveChanges();
            }

            @Override
            public boolean isListening() {
                return JustMapClient.MAP.isMapVisible();
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("toggle_show_entities", 89)){

            @Override
            public void onKeyUp() {
                JustMapClient.CONFIG.setBoolean("show_entities", !JustMapClient.CONFIG.getBoolean("show_entities"));
                JustMapClient.CONFIG.saveChanges();
            }

            @Override
            public boolean isListening() {
                return JustMapClient.MAP.isMapVisible();
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("waypoints_list", 85)){

            @Override
            public void onKeyUp() {
                MC.method_1507((class_437)new WaypointsList(null));
            }

            @Override
            public boolean isListening() {
                return 6.MC.field_1724 != null && 6.MC.field_1755 == null;
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("show_config", 74)){

            @Override
            public void onKeyUp() {
                MC.method_1507(ConfigFactory.getConfigScreen(null));
            }

            @Override
            public boolean isListening() {
                return 7.MC.field_1755 == null;
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("show_worldmap", 77)){

            @Override
            public void onKeyUp() {
                MC.method_1507((class_437)Worldmap.getScreen());
            }

            @Override
            public boolean isListening() {
                return 8.MC.field_1724 != null && 8.MC.field_1755 == null;
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("reduce_scale", 91)){

            @Override
            public void onKeyUp() {
                JustMapClient.CONFIG.setRanged("map_scale", Float.valueOf(JustMapClient.CONFIG.getFloat("map_scale") - 0.25f));
                JustMapClient.CONFIG.saveChanges();
            }

            @Override
            public boolean isListening() {
                return JustMapClient.MAP.isMapVisible();
            }
        });
        KeyHandler.registerKey(new KeyParser(KeyHandler.createKeyBinding("increase_scale", 93)){

            @Override
            public void onKeyUp() {
                JustMapClient.CONFIG.setRanged("map_scale", Float.valueOf(JustMapClient.CONFIG.getFloat("map_scale") + 0.25f));
                JustMapClient.CONFIG.saveChanges();
            }

            @Override
            public boolean isListening() {
                return JustMapClient.MAP.isMapVisible();
            }
        });
    }

    public static void update() {
        for (KeyParser kp : parsers) {
            if (!kp.isListening()) continue;
            if (kp.keyBinding.method_1436()) {
                kp.onKeyUp();
                continue;
            }
            if (!kp.keyBinding.method_1434()) continue;
            kp.onKeyDown();
        }
    }

    private static void registerKey(KeyParser parser) {
        KeyBindingRegistry.INSTANCE.register(parser.keyBinding);
        parsers.add(parser);
    }

    private static FabricKeyBinding createKeyBinding(String name, int key) {
        return FabricKeyBinding.Builder.create((class_2960)new class_2960("justmap", name), (class_3675.class_307)class_3675.class_307.field_1668, (int)key, (String)"justmap").build();
    }
}

