/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client.config;

import com.google.gson.JsonObject;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.config.Config;
import ru.bulldog.justmap.config.ConfigKeeper;
import ru.bulldog.justmap.config.ConfigWriter;
import ru.bulldog.justmap.map.DirectionArrow;
import ru.bulldog.justmap.map.minimap.MapPosition;

public class ClientConfig
extends Config {
    private static ClientConfig instance;

    public static ClientConfig get() {
        if (instance == null) {
            instance = new ClientConfig();
        }
        return instance;
    }

    private ClientConfig() {
        KEEPER.registerEntry("map_visible", new ConfigKeeper.BooleanEntry(ClientParams.mapVisible, b -> {
            ClientParams.mapVisible = b;
        }, () -> ClientParams.mapVisible));
        KEEPER.registerEntry("map_position", new ConfigKeeper.EnumEntry<MapPosition>(ClientParams.mapPosition, e -> {
            ClientParams.mapPosition = e;
        }, () -> ClientParams.mapPosition));
        KEEPER.registerEntry("arrow_type", new ConfigKeeper.EnumEntry<DirectionArrow.Type>(ClientParams.arrowIconType, e -> {
            ClientParams.arrowIconType = e;
        }, () -> ClientParams.arrowIconType));
        KEEPER.registerEntry("map_offset", new ConfigKeeper.IntegerEntry(ClientParams.positionOffset, i -> {
            ClientParams.positionOffset = i;
        }, () -> ClientParams.positionOffset));
        KEEPER.registerEntry("map_size", new ConfigKeeper.IntegerRange(ClientParams.mapSize, i -> {
            ClientParams.mapSize = i;
        }, () -> ClientParams.mapSize, 16, 256));
        KEEPER.registerEntry("big_map_size", new ConfigKeeper.IntegerRange(ClientParams.bigMapSize, i -> {
            ClientParams.bigMapSize = i;
        }, () -> ClientParams.bigMapSize, 256, 400));
        KEEPER.registerEntry("map_scale", new ConfigKeeper.FloatRange(Float.valueOf(ClientParams.mapScale), f -> {
            ClientParams.mapScale = f.floatValue();
        }, () -> Float.valueOf(ClientParams.mapScale), Float.valueOf(0.25f), Float.valueOf(2.0f)));
        KEEPER.registerEntry("map_saturation", new ConfigKeeper.IntegerRange(ClientParams.mapSaturation, i -> {
            ClientParams.mapSaturation = i;
        }, () -> ClientParams.mapSaturation, -50, 50));
        KEEPER.registerEntry("map_brightness", new ConfigKeeper.IntegerRange(ClientParams.mapBrightness, i -> {
            ClientParams.mapBrightness = i;
        }, () -> ClientParams.mapBrightness, -50, 50));
        KEEPER.registerEntry("rotate_map", new ConfigKeeper.BooleanEntry(ClientParams.rotateMap, b -> {
            ClientParams.rotateMap = b;
        }, () -> ClientParams.rotateMap));
        KEEPER.registerEntry("show_caves", new ConfigKeeper.BooleanEntry(ClientParams.drawCaves, b -> {
            ClientParams.drawCaves = b;
        }, () -> ClientParams.drawCaves));
        KEEPER.registerEntry("hide_plants", new ConfigKeeper.BooleanEntry(ClientParams.hidePlants, b -> {
            ClientParams.hidePlants = b;
        }, () -> ClientParams.hidePlants));
        KEEPER.registerEntry("hide_water", new ConfigKeeper.BooleanEntry(ClientParams.hideWater, b -> {
            ClientParams.hideWater = b;
        }, () -> ClientParams.hideWater));
        KEEPER.registerEntry("show_position", new ConfigKeeper.BooleanEntry(ClientParams.showPosition, b -> {
            ClientParams.showPosition = b;
        }, () -> ClientParams.showPosition));
        KEEPER.registerEntry("show_FPS", new ConfigKeeper.BooleanEntry(ClientParams.showFPS, b -> {
            ClientParams.showFPS = b;
        }, () -> ClientParams.showFPS));
        KEEPER.registerEntry("show_biome", new ConfigKeeper.BooleanEntry(ClientParams.showBiome, b -> {
            ClientParams.showBiome = b;
        }, () -> ClientParams.showBiome));
        KEEPER.registerEntry("show_time", new ConfigKeeper.BooleanEntry(ClientParams.showTime, b -> {
            ClientParams.showTime = b;
        }, () -> ClientParams.showTime));
        KEEPER.registerEntry("move_effects", new ConfigKeeper.BooleanEntry(ClientParams.moveEffects, b -> {
            ClientParams.moveEffects = b;
        }, () -> ClientParams.moveEffects));
        KEEPER.registerEntry("show_effect_timers", new ConfigKeeper.BooleanEntry(ClientParams.showEffectTimers, b -> {
            ClientParams.showEffectTimers = b;
        }, () -> ClientParams.showEffectTimers));
        KEEPER.registerEntry("alternate_color_render", new ConfigKeeper.BooleanEntry(ClientParams.alternateColorRender, b -> {
            ClientParams.alternateColorRender = b;
        }, () -> ClientParams.alternateColorRender));
        KEEPER.registerEntry("texture_filter", new ConfigKeeper.BooleanEntry(ClientParams.textureFilter, b -> {
            ClientParams.textureFilter = b;
        }, () -> ClientParams.textureFilter));
        KEEPER.registerEntry("water_tint", new ConfigKeeper.BooleanEntry(ClientParams.waterTint, b -> {
            ClientParams.waterTint = b;
        }, () -> ClientParams.waterTint));
        KEEPER.registerEntry("use_skins", new ConfigKeeper.BooleanEntry(ClientParams.useSkins, b -> {
            ClientParams.useSkins = b;
        }, () -> ClientParams.useSkins));
        KEEPER.registerEntry("simple_direction_arrow", new ConfigKeeper.BooleanEntry(ClientParams.simpleArrow, b -> {
            ClientParams.simpleArrow = b;
        }, () -> ClientParams.simpleArrow));
        KEEPER.registerEntry("current_skin", new ConfigKeeper.IntegerEntry(ClientParams.currentSkin, i -> {
            ClientParams.currentSkin = i;
        }, () -> ClientParams.currentSkin));
        KEEPER.registerEntry("chunk_update_interval", new ConfigKeeper.IntegerRange(ClientParams.chunkUpdateInterval, i -> {
            ClientParams.chunkUpdateInterval = i;
        }, () -> ClientParams.chunkUpdateInterval, 500, 5000));
        KEEPER.registerEntry("chunk_level_update_interval", new ConfigKeeper.IntegerRange(ClientParams.chunkLevelUpdateInterval, i -> {
            ClientParams.chunkLevelUpdateInterval = i;
        }, () -> ClientParams.chunkLevelUpdateInterval, 500, 10000));
        KEEPER.registerEntry("purge_delay", new ConfigKeeper.IntegerRange(ClientParams.purgeDelay, i -> {
            ClientParams.purgeDelay = i;
        }, () -> ClientParams.purgeDelay, 1, 600));
        KEEPER.registerEntry("purge_amount", new ConfigKeeper.IntegerRange(ClientParams.purgeAmount, i -> {
            ClientParams.purgeAmount = i;
        }, () -> ClientParams.purgeAmount, 100, 50000));
        KEEPER.registerEntry("show_terrain", new ConfigKeeper.BooleanEntry(ClientParams.showTerrain, b -> {
            ClientParams.showTerrain = b;
        }, () -> ClientParams.showTerrain));
        KEEPER.registerEntry("terrain_strength", new ConfigKeeper.IntegerRange(ClientParams.terrainStrength, i -> {
            ClientParams.terrainStrength = i;
        }, () -> ClientParams.terrainStrength, 2, 9));
        KEEPER.registerEntry("draw_chunk_grid", new ConfigKeeper.BooleanEntry(ClientParams.showGrid, b -> {
            ClientParams.showGrid = b;
        }, () -> ClientParams.showGrid));
        KEEPER.registerEntry("show_in_chat", new ConfigKeeper.BooleanEntry(ClientParams.showInChat, b -> {
            ClientParams.showInChat = b;
        }, () -> ClientParams.showInChat));
        KEEPER.registerEntry("waypoints_tracking", new ConfigKeeper.BooleanEntry(ClientParams.waypointsTracking, b -> {
            ClientParams.waypointsTracking = b;
        }, () -> ClientParams.waypointsTracking));
        KEEPER.registerEntry("waypoints_world_render", new ConfigKeeper.BooleanEntry(ClientParams.waypointsWorldRender, b -> {
            ClientParams.waypointsWorldRender = b;
        }, () -> ClientParams.waypointsWorldRender));
        KEEPER.registerEntry("render_light_beam", new ConfigKeeper.BooleanEntry(ClientParams.renderLightBeam, b -> {
            ClientParams.renderLightBeam = b;
        }, () -> ClientParams.renderLightBeam));
        KEEPER.registerEntry("render_markers", new ConfigKeeper.BooleanEntry(ClientParams.renderMarkers, b -> {
            ClientParams.renderMarkers = b;
        }, () -> ClientParams.renderMarkers));
        KEEPER.registerEntry("render_animation", new ConfigKeeper.BooleanEntry(ClientParams.renderAnimation, b -> {
            ClientParams.renderAnimation = b;
        }, () -> ClientParams.renderAnimation));
        KEEPER.registerEntry("min_render_dist", new ConfigKeeper.IntegerRange(ClientParams.minRenderDist, i -> {
            ClientParams.minRenderDist = i;
        }, () -> ClientParams.minRenderDist, 1, 100));
        KEEPER.registerEntry("max_render_dist", new ConfigKeeper.IntegerRange(ClientParams.maxRenderDist, i -> {
            ClientParams.maxRenderDist = i;
        }, () -> ClientParams.maxRenderDist, 10, 3000));
        KEEPER.registerEntry("show_entities", new ConfigKeeper.BooleanEntry(ClientParams.showEntities, b -> {
            ClientParams.showEntities = b;
        }, () -> ClientParams.showEntities));
        KEEPER.registerEntry("show_entity_heads", new ConfigKeeper.BooleanEntry(ClientParams.showEntityHeads, b -> {
            ClientParams.showEntityHeads = b;
        }, () -> ClientParams.showEntityHeads));
        KEEPER.registerEntry("show_hostile", new ConfigKeeper.BooleanEntry(ClientParams.showHostile, b -> {
            ClientParams.showHostile = b;
        }, () -> ClientParams.showHostile));
        KEEPER.registerEntry("show_creatures", new ConfigKeeper.BooleanEntry(ClientParams.showCreatures, b -> {
            ClientParams.showCreatures = b;
        }, () -> ClientParams.showCreatures));
        KEEPER.registerEntry("show_players", new ConfigKeeper.BooleanEntry(ClientParams.showPlayers, b -> {
            ClientParams.showPlayers = b;
        }, () -> ClientParams.showPlayers));
        KEEPER.registerEntry("show_player_heads", new ConfigKeeper.BooleanEntry(ClientParams.showPlayerHeads, b -> {
            ClientParams.showPlayerHeads = b;
        }, () -> ClientParams.showPlayerHeads));
        KEEPER.registerEntry("show_player_names", new ConfigKeeper.BooleanEntry(ClientParams.showPlayerNames, b -> {
            ClientParams.showPlayerNames = b;
        }, () -> ClientParams.showPlayerNames));
        KEEPER.registerEntry("render_entity_model", new ConfigKeeper.BooleanEntry(ClientParams.renderEntityModel, b -> {
            ClientParams.renderEntityModel = b;
        }, () -> ClientParams.renderEntityModel));
        KEEPER.registerEntry("show_icons_outline", new ConfigKeeper.BooleanEntry(ClientParams.showIconsOutline, b -> {
            ClientParams.showIconsOutline = b;
        }, () -> ClientParams.showIconsOutline));
        KEEPER.registerEntry("show_big_map", new ConfigKeeper.BooleanEntry(ClientParams.showBigMap, b -> {
            ClientParams.showBigMap = b;
        }, () -> ClientParams.showBigMap));
        KEEPER.registerEntry("entity_icon_size", new ConfigKeeper.IntegerRange(ClientParams.entityIconSize, i -> {
            ClientParams.entityIconSize = i;
        }, () -> ClientParams.entityIconSize, 2, 16));
        KEEPER.registerEntry("entity_model_size", new ConfigKeeper.IntegerRange(ClientParams.entityModelSize, i -> {
            ClientParams.entityModelSize = i;
        }, () -> ClientParams.entityModelSize, 2, 16));
        KEEPER.registerEntry("arrow_size", new ConfigKeeper.IntegerRange(ClientParams.arrowIconSize, i -> {
            ClientParams.arrowIconSize = i;
        }, () -> ClientParams.arrowIconSize, 6, 16));
        KEEPER.registerEntry("worldmap_icon_size", new ConfigKeeper.IntegerRange(ClientParams.worldmapIconSize, i -> {
            ClientParams.worldmapIconSize = i;
        }, () -> ClientParams.worldmapIconSize, 8, 16));
        JsonObject config = ConfigWriter.load();
        if (config.size() > 0) {
            KEEPER.fromJson(config);
        } else {
            ConfigWriter.save(KEEPER.toJson());
        }
    }

    @Override
    public void saveChanges() {
        ConfigWriter.save(KEEPER.toJson());
        JustMapClient.MAP.updateMapParams();
    }
}

