/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client.config;

import java.util.Arrays;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.config.ConfigKeeper;
import ru.bulldog.justmap.map.DirectionArrow;
import ru.bulldog.justmap.map.minimap.MapPosition;
import ru.bulldog.justmap.map.minimap.MapSkin;

public final class ConfigFactory {
    private static ConfigBuilder configBuilder;

    private static String lang(String key) {
        return new class_2588("justmap.configuration." + key, new Object[0]).getString();
    }

    public static class_437 getConfigScreen(class_437 parent) {
        if (configBuilder == null) {
            ConfigFactory.initConfigBuilder();
        }
        configBuilder.setParentScreen(parent);
        return configBuilder.build();
    }

    private static void initConfigBuilder() {
        configBuilder = ConfigBuilder.create().setTitle("Just Map Configuration");
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        ConfigCategory general = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.general"));
        ConfigKeeper.EnumEntry drawPosConfig = (ConfigKeeper.EnumEntry)JustMapClient.CONFIG.getEntry("map_position");
        EnumSelectorBuilder drawPosEntry = entryBuilder.startEnumSelector(ConfigFactory.lang("map_position"), MapPosition.class, (Enum)drawPosConfig.getValue());
        drawPosEntry.setSaveConsumer(val -> drawPosConfig.setValue(val)).setDefaultValue((Enum)drawPosConfig.getDefault());
        general.addEntry((AbstractConfigListEntry)drawPosEntry.build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ConfigFactory.lang("map_offset"), JustMapClient.CONFIG.getInt("map_offset")).setSaveConsumer(val -> JustMapClient.CONFIG.setInt("map_offset", (int)val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("map_offset")).intValue()).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu(ConfigFactory.lang("map_size"), (Object)JustMapClient.CONFIG.getInt("map_size"), val -> {
            if (val.equals("")) {
                return 0;
            }
            return Integer.valueOf(val);
        }).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("map_size", val)).setDefaultValue((Object)((Integer)JustMapClient.CONFIG.getDefault("map_size"))).setSelections(Arrays.asList(32, 64, 96, 128, 160, 192, 224, 256)).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_big_map"), JustMapClient.CONFIG.getBoolean("show_big_map")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_big_map", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_big_map")).booleanValue()).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu(ConfigFactory.lang("big_map_size"), (Object)JustMapClient.CONFIG.getInt("big_map_size"), val -> {
            if (val.equals("")) {
                return 0;
            }
            return Integer.valueOf(val);
        }).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("big_map_size", val)).setDefaultValue((Object)((Integer)JustMapClient.CONFIG.getDefault("big_map_size"))).setSelections(Arrays.asList(256, 272, 288, 304, 320, 336, 352, 368, 384, 400)).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_in_chat"), JustMapClient.CONFIG.getBoolean("show_in_chat")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_in_chat", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_in_chat")).booleanValue()).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("move_effects"), JustMapClient.CONFIG.getBoolean("move_effects")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("move_effects", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("move_effects")).booleanValue()).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_effect_timers"), JustMapClient.CONFIG.getBoolean("show_effect_timers")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_effect_timers", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_effect_timers")).booleanValue()).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("rotate_map"), JustMapClient.CONFIG.getBoolean("rotate_map")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("rotate_map", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("rotate_map")).booleanValue()).build());
        ConfigCategory mapDetails = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.details"));
        mapDetails.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_caves"), JustMapClient.CONFIG.getBoolean("show_caves")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_caves", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_caves")).booleanValue()).build());
        mapDetails.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_terrain"), JustMapClient.CONFIG.getBoolean("show_terrain")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_terrain", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_terrain")).booleanValue()).build());
        mapDetails.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("terrain_strength"), JustMapClient.CONFIG.getInt("terrain_strength"), 2, 9).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("terrain_strength", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("terrain_strength")).intValue()).build());
        mapDetails.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_grid"), JustMapClient.CONFIG.getBoolean("draw_chunk_grid")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("draw_chunk_grid", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("draw_chunk_grid")).booleanValue()).build());
        mapDetails.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("hide_plants"), JustMapClient.CONFIG.getBoolean("hide_plants")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("hide_plants", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("hide_plants")).booleanValue()).build());
        mapDetails.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("hide_water"), JustMapClient.CONFIG.getBoolean("hide_water")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("hide_water", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("hide_water")).booleanValue()).build());
        ConfigKeeper.EnumEntry arrowTypeConfig = (ConfigKeeper.EnumEntry)JustMapClient.CONFIG.getEntry("arrow_type");
        EnumSelectorBuilder arrowTypeEntry = entryBuilder.startEnumSelector(ConfigFactory.lang("arrow_type"), DirectionArrow.Type.class, (Enum)arrowTypeConfig.getValue());
        arrowTypeEntry.setSaveConsumer(val -> arrowTypeConfig.setValue(val)).setDefaultValue((Enum)arrowTypeConfig.getDefault());
        ConfigCategory mapAppearance = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.appearance"));
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("use_skins"), JustMapClient.CONFIG.getBoolean("use_skins")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("use_skins", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("use_skins")).booleanValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu(ConfigFactory.lang("current_skin"), (Object)MapSkin.getCurrentSkin(), MapSkin::getSkinByName, MapSkin::getName).setSaveConsumer(val -> JustMapClient.CONFIG.setInt("current_skin", val.id)).setDefaultValue((Object)MapSkin.getSkin((Integer)JustMapClient.CONFIG.getDefault("current_skin"))).setSelections(MapSkin.getSkins()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)arrowTypeEntry.build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("simple_arrow"), JustMapClient.CONFIG.getBoolean("simple_direction_arrow")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("simple_direction_arrow", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("simple_direction_arrow")).booleanValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("arrow_size"), JustMapClient.CONFIG.getInt("arrow_size"), 6, 16).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("arrow_size", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("arrow_size")).intValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("worldmap_icon_size"), JustMapClient.CONFIG.getInt("worldmap_icon_size"), 8, 16).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("worldmap_icon_size", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("worldmap_icon_size")).intValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("alternate_color_render"), JustMapClient.CONFIG.getBoolean("alternate_color_render")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("alternate_color_render", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("alternate_color_render")).booleanValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("water_tint"), JustMapClient.CONFIG.getBoolean("water_tint")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("water_tint", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("water_tint")).booleanValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("texture_filter"), JustMapClient.CONFIG.getBoolean("texture_filter")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("texture_filter", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("texture_filter")).booleanValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("map_saturation"), JustMapClient.CONFIG.getInt("map_saturation"), -50, 50).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("map_saturation", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("map_saturation")).intValue()).build());
        mapAppearance.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("map_brightness"), JustMapClient.CONFIG.getInt("map_brightness"), -50, 50).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("map_brightness", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("map_brightness")).intValue()).build());
        ConfigCategory waypoints = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.waypoints"));
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("waypoints_tracking"), JustMapClient.CONFIG.getBoolean("waypoints_tracking")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("waypoints_tracking", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("waypoints_tracking")).booleanValue()).build());
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("waypoints_render"), JustMapClient.CONFIG.getBoolean("waypoints_world_render")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("waypoints_world_render", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("waypoints_world_render")).booleanValue()).build());
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("render_light_beam"), JustMapClient.CONFIG.getBoolean("render_light_beam")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("render_light_beam", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("render_light_beam")).booleanValue()).build());
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("render_markers"), JustMapClient.CONFIG.getBoolean("render_markers")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("render_markers", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("render_markers")).booleanValue()).build());
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("render_animation"), JustMapClient.CONFIG.getBoolean("render_animation")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("render_animation", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("render_animation")).booleanValue()).build());
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("min_render_dist"), JustMapClient.CONFIG.getInt("min_render_dist"), 1, 100).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("min_render_dist", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("min_render_dist")).intValue()).build());
        waypoints.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("max_render_dist"), JustMapClient.CONFIG.getInt("max_render_dist"), 10, 3000).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("max_render_dist", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("max_render_dist")).intValue()).build());
        ConfigCategory entityRadar = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.entity_radar"));
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_entities"), JustMapClient.CONFIG.getBoolean("show_entities")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_entities", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_entities")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_entity_heads"), JustMapClient.CONFIG.getBoolean("show_entity_heads")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_entity_heads", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_entity_heads")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("entity_icon_size"), JustMapClient.CONFIG.getInt("entity_icon_size"), 2, 16).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("entity_icon_size", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("entity_icon_size")).intValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_hostile"), JustMapClient.CONFIG.getBoolean("show_hostile")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_hostile", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_hostile")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_creatures"), JustMapClient.CONFIG.getBoolean("show_creatures")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_creatures", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_creatures")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_players"), JustMapClient.CONFIG.getBoolean("show_players")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_players", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_players")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_player_heads"), JustMapClient.CONFIG.getBoolean("show_player_heads")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_player_heads", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_player_heads")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_player_names"), JustMapClient.CONFIG.getBoolean("show_player_names")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_player_names", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_player_names")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_icons_outline"), JustMapClient.CONFIG.getBoolean("show_icons_outline")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_icons_outline", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_icons_outline")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("render_entity_model"), JustMapClient.CONFIG.getBoolean("render_entity_model")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("render_entity_model", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("render_entity_model")).booleanValue()).build());
        entityRadar.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider(ConfigFactory.lang("entity_model_size"), JustMapClient.CONFIG.getInt("entity_model_size"), 2, 16).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("entity_model_size", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("entity_model_size")).intValue()).build());
        ConfigCategory mapInfo = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.info"));
        mapInfo.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_position"), JustMapClient.CONFIG.getBoolean("show_position")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_position", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_position")).booleanValue()).build());
        mapInfo.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_biome"), JustMapClient.CONFIG.getBoolean("show_biome")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_biome", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_biome")).booleanValue()).build());
        mapInfo.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_fps"), JustMapClient.CONFIG.getBoolean("show_FPS")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_FPS", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_FPS")).booleanValue()).build());
        mapInfo.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ConfigFactory.lang("show_game_time"), JustMapClient.CONFIG.getBoolean("show_time")).setSaveConsumer(val -> JustMapClient.CONFIG.setBoolean("show_time", (boolean)val)).setDefaultValue(((Boolean)JustMapClient.CONFIG.getDefault("show_time")).booleanValue()).build());
        ConfigCategory optimization = configBuilder.getOrCreateCategory(ConfigFactory.lang("category.optimization"));
        optimization.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ConfigFactory.lang("chunk_update_interval"), JustMapClient.CONFIG.getInt("chunk_update_interval")).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("chunk_update_interval", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("chunk_update_interval")).intValue()).setMin(500).setMax(5000).build());
        optimization.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ConfigFactory.lang("chunk_level_update_interval"), JustMapClient.CONFIG.getInt("chunk_level_update_interval")).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("chunk_level_update_interval", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("chunk_level_update_interval")).intValue()).setMin(500).setMax(10000).build());
        optimization.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ConfigFactory.lang("purge_delay"), JustMapClient.CONFIG.getInt("purge_delay")).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("purge_delay", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("purge_delay")).intValue()).setMin(10).setMax(600).build());
        optimization.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ConfigFactory.lang("purge_amount"), JustMapClient.CONFIG.getInt("purge_amount")).setSaveConsumer(val -> JustMapClient.CONFIG.setRanged("purge_amount", val)).setDefaultValue(((Integer)JustMapClient.CONFIG.getDefault("purge_amount")).intValue()).setMin(100).setMax(5000).build());
        configBuilder.setDoesConfirmSave(false);
        configBuilder.transparentBackground();
        configBuilder.setSavingRunnable(JustMapClient.CONFIG::saveChanges);
    }
}

