/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1480;
import net.minecraft.class_1510;
import net.minecraft.class_1571;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.util.math.MathUtil;

public class EntityModelRenderer {
    private static class_310 minecraftClient = class_310.method_1551();
    private static class_898 renderDispatcher = minecraftClient.method_1561();
    private static class_4597.class_4598 consumerProvider = minecraftClient.method_22940().method_23000();

    public static void renderModel(class_1297 entity, double x, double y) {
        class_1309 livingEntity = (class_1309)entity;
        float headYaw = livingEntity.field_6241;
        float bodyYaw = livingEntity.field_6283;
        float prevHeadYaw = livingEntity.field_6259;
        float prevBodyYaw = livingEntity.field_6220;
        float pitch = livingEntity.field_5965;
        float prevPitch = livingEntity.field_6004;
        EntityModelRenderer.setPitchAndYaw(livingEntity);
        float scale = EntityModelRenderer.getScale(livingEntity);
        class_4587 matrixStack = new class_4587();
        int modelSize = ClientParams.entityModelSize;
        matrixStack.method_22903();
        matrixStack.method_22904(x, y, 0.0);
        matrixStack.method_22904((double)(modelSize / 4), (double)(modelSize / 2), 0.0);
        if (ClientParams.rotateMap) {
            float rotation = MathUtil.correctAngle(EntityModelRenderer.minecraftClient.field_1724.field_6241);
            matrixStack.method_22907(class_1160.field_20707.method_23214(rotation));
        } else {
            matrixStack.method_22907(class_1160.field_20703.method_23214(180.0f));
        }
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, scale);
        class_308.method_22890();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderDispatcher.method_3953((class_1297)livingEntity).method_3936((class_1297)livingEntity, 0.0f, 0.0f, matrixStack, (class_4597)consumerProvider, 0xF000F0);
        class_308.method_1450();
        matrixStack.method_22909();
        matrixStack.method_22909();
        livingEntity.field_5965 = pitch;
        livingEntity.field_6241 = headYaw;
        livingEntity.field_6283 = bodyYaw;
        livingEntity.field_6004 = prevPitch;
        livingEntity.field_6259 = prevHeadYaw;
        livingEntity.field_6220 = prevBodyYaw;
    }

    private static float getScale(class_1309 livingEntity) {
        int modelSize = ClientParams.entityModelSize;
        float mapScale = JustMapClient.MAP.getScale();
        modelSize = (int)Math.min((float)modelSize, (float)modelSize / mapScale);
        float scaleX = (float)modelSize / Math.max(livingEntity.method_17681(), 1.0f);
        float scaleY = (float)modelSize / Math.max(livingEntity.method_17682(), 1.0f);
        float scale = Math.max(Math.min(scaleX, scaleY), (float)modelSize);
        if (livingEntity instanceof class_1571 || livingEntity instanceof class_1510) {
            scale = (float)modelSize / 3.0f;
        }
        if (livingEntity instanceof class_1480) {
            scale = (float)modelSize / 1.35f;
        }
        if (livingEntity.method_6113()) {
            scale = modelSize;
        }
        return scale;
    }

    private static void setPitchAndYaw(class_1309 livingEntity) {
        livingEntity.field_5965 = 0.0f;
        livingEntity.field_6004 = 0.0f;
        switch (livingEntity.method_5755()) {
            case field_11043: {
                livingEntity.field_6241 = 0.0f;
                livingEntity.field_6283 = 0.0f;
                livingEntity.field_6259 = 0.0f;
                livingEntity.field_6220 = 0.0f;
                break;
            }
            case field_11039: {
                livingEntity.field_6241 = 135.0f;
                livingEntity.field_6283 = 135.0f;
                livingEntity.field_6259 = 135.0f;
                livingEntity.field_6220 = 135.0f;
                break;
            }
            case field_11034: {
                livingEntity.field_6241 = 225.0f;
                livingEntity.field_6283 = 225.0f;
                livingEntity.field_6259 = 225.0f;
                livingEntity.field_6220 = 225.0f;
                break;
            }
            default: {
                livingEntity.field_6241 = 180.0f;
                livingEntity.field_6283 = 180.0f;
                livingEntity.field_6259 = 180.0f;
                livingEntity.field_6220 = 180.0f;
            }
        }
    }
}

