/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.DirectionArrow;
import ru.bulldog.justmap.map.data.MapCache;
import ru.bulldog.justmap.map.data.MapRegion;
import ru.bulldog.justmap.map.icon.EntityIcon;
import ru.bulldog.justmap.map.icon.PlayerHeadIcon;
import ru.bulldog.justmap.map.icon.PlayerIcon;
import ru.bulldog.justmap.map.icon.WaypointIcon;
import ru.bulldog.justmap.map.minimap.MapPosition;
import ru.bulldog.justmap.map.minimap.MapSkin;
import ru.bulldog.justmap.map.minimap.MapText;
import ru.bulldog.justmap.map.minimap.Minimap;
import ru.bulldog.justmap.map.minimap.TextManager;
import ru.bulldog.justmap.util.DrawHelper;
import ru.bulldog.justmap.util.PosUtil;
import ru.bulldog.justmap.util.math.Line;
import ru.bulldog.justmap.util.math.MathUtil;

@Environment(value=EnvType.CLIENT)
public class MapRenderer {
    private static MapRenderer instance;
    protected MapPosition mapPosition;
    protected int border = 2;
    private int offset;
    private int posX;
    private int posY;
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;
    private int imgX;
    private int imgY;
    private int imgW;
    private int imgH;
    private float rotation;
    private int lastX;
    private int lastZ;
    private final Minimap minimap;
    private TextManager textManager;
    private MapText dirN = new MapText(DrawHelper.TextAlignment.CENTER, "N");
    private MapText dirS = new MapText(DrawHelper.TextAlignment.CENTER, "S");
    private MapText dirE = new MapText(DrawHelper.TextAlignment.CENTER, "E");
    private MapText dirW = new MapText(DrawHelper.TextAlignment.CENTER, "W");
    private final class_310 client = class_310.method_1551();
    private MapSkin mapSkin;

    public static MapRenderer getInstance() {
        if (instance == null) {
            instance = new MapRenderer();
        }
        return instance;
    }

    private MapRenderer() {
        this.minimap = JustMapClient.MAP;
        this.offset = ClientParams.positionOffset;
        this.mapPosition = ClientParams.mapPosition;
        this.textManager = this.minimap.getTextManager();
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getBorder() {
        return this.border;
    }

    public void updateParams() {
        this.mapW = this.minimap.getWidth();
        this.mapH = this.minimap.getHeight();
        int scaledBorder = this.border;
        if (ClientParams.useSkins) {
            this.mapSkin = MapSkin.getSkin(ClientParams.currentSkin);
            this.border = this.mapSkin.border;
            this.mapSkin.getRenderData().updateScale();
            double scale = this.mapSkin.getRenderData().scaleFactor;
            scaledBorder = (int)((double)this.border * scale);
        }
        int winW = this.client.method_22683().method_4486();
        int winH = this.client.method_22683().method_4502();
        this.offset = ClientParams.positionOffset;
        this.mapPosition = ClientParams.mapPosition;
        this.posX = this.offset;
        this.posY = this.offset;
        this.mapX = this.posX + scaledBorder;
        this.mapY = this.posY + scaledBorder;
        this.rotation = this.client.field_1724.field_6241;
        TextManager.TextPosition textPos = TextManager.TextPosition.UNDER;
        switch (this.mapPosition) {
            case TOP_LEFT: {
                break;
            }
            case TOP_CENTER: {
                this.mapX = winW / 2 - this.mapW / 2;
                this.posX = this.mapX - this.border;
                break;
            }
            case TOP_RIGHT: {
                this.mapX = winW - this.offset - this.mapW - scaledBorder;
                this.posX = this.mapX - scaledBorder;
                break;
            }
            case MIDDLE_RIGHT: {
                this.mapX = winW - this.offset - this.mapW - this.border;
                this.mapY = winH / 2 - this.mapH / 2;
                this.posX = this.mapX - this.border;
                this.posY = this.mapY - this.border;
                break;
            }
            case MIDDLE_LEFT: {
                this.mapY = winH / 2 - this.mapH / 2;
                this.posY = this.mapY - this.border;
                break;
            }
            case BOTTOM_LEFT: {
                textPos = TextManager.TextPosition.ABOVE;
                this.mapY = winH - this.offset - this.mapH - this.border;
                this.posY = this.mapY - this.border;
                break;
            }
            case BOTTOM_RIGHT: {
                textPos = TextManager.TextPosition.ABOVE;
                this.mapX = winW - this.offset - this.mapW - this.border;
                this.posX = this.mapX - this.border;
                this.mapY = winH - this.offset - this.mapH - this.border;
                this.posY = this.mapY - this.border;
            }
        }
        if (ClientParams.rotateMap) {
            this.imgW = (int)((double)this.mapW * 1.42);
            this.imgH = (int)((double)this.mapH * 1.42);
            this.imgX = this.mapX - (this.imgW - this.mapW) / 2;
            this.imgY = this.mapY - (this.imgH - this.mapH) / 2;
        } else {
            this.imgW = this.mapW;
            this.imgH = this.mapH;
            this.imgX = this.mapX;
            this.imgY = this.mapY;
        }
        this.textManager.setPosition(this.mapX, this.mapY + (textPos == TextManager.TextPosition.UNDER && this.minimap.isMapVisible() ? this.mapH + scaledBorder + 3 : -(scaledBorder + 3)));
        this.textManager.setDirection(textPos);
        this.textManager.setSpacing(12);
        int centerX = this.mapX + this.mapW / 2;
        int centerY = this.mapY + this.mapH / 2;
        int mapR = this.mapX + this.mapW;
        int mapB = this.mapY + this.mapH;
        Line.Point center = new Line.Point(centerX, centerY);
        Line.Point pointN = new Line.Point(centerX, this.mapY);
        Line.Point pointS = new Line.Point(centerX, mapB);
        Line.Point pointE = new Line.Point(mapR, centerY);
        Line.Point pointW = new Line.Point(this.mapX, centerY);
        if (ClientParams.rotateMap) {
            float rotate = MathUtil.correctAngle(this.rotation) + 180.0f;
            double angle = Math.toRadians(-rotate);
            Line radius = new Line(center, pointN);
            Line corner = new Line(center, new Line.Point(this.mapX, this.mapY));
            radius.add(corner.lenght() - radius.lenght());
            int len = radius.lenght();
            pointN.y = centerY - len;
            pointS.y = centerY + len;
            pointE.x = centerX + len;
            pointW.x = centerX - len;
            this.calculatePos(center, pointN, mapR, mapB, angle);
            this.calculatePos(center, pointS, mapR, mapB, angle);
            this.calculatePos(center, pointE, mapR, mapB, angle);
            this.calculatePos(center, pointW, mapR, mapB, angle);
        }
        this.textManager.add(this.dirN, pointN.x, pointN.y - 5);
        this.textManager.add(this.dirS, pointS.x, pointS.y - 5);
        this.textManager.add(this.dirE, pointE.x, pointE.y - 5);
        this.textManager.add(this.dirW, pointW.x, pointW.y - 5);
    }

    private void calculatePos(Line.Point center, Line.Point dir, int mr, int mb, double angle) {
        int posX = (int)((double)center.x + (double)(dir.x - center.x) * Math.cos(angle) - (double)(dir.y - center.y) * Math.sin(angle));
        int posY = (int)((double)center.y + (double)(dir.y - center.y) * Math.cos(angle) + (double)(dir.x - center.x) * Math.sin(angle));
        posX = MathUtil.clamp(posX, this.mapX, mr);
        posY = MathUtil.clamp(posY, this.mapY, mb);
        dir.x = posX;
        dir.y = posY;
    }

    public void draw() {
        if (!this.minimap.isMapVisible() || this.client.field_1724 == null) {
            return;
        }
        this.updateParams();
        int winH = this.client.method_22683().method_4506();
        double scale = this.client.method_22683().method_4495();
        int scaledX = (int)((double)this.mapX * scale);
        int scaledY = (int)((double)winH - (double)(this.mapY + this.mapH) * scale);
        int scaledW = (int)((double)this.mapW * scale);
        int scaledH = (int)((double)this.mapH * scale);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        if (ClientParams.useSkins) {
            double skinScale = this.mapSkin.getRenderData().scaleFactor;
            int brd = (int)((double)(this.border * 2) * skinScale);
            this.mapSkin.draw(this.posX, this.posY, this.mapW + brd, this.mapH + brd);
        }
        if (this.minimap.posChanged) {
            this.lastX = this.minimap.getLasX();
            this.lastZ = this.minimap.getLastZ();
            this.minimap.posChanged = false;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scaledX, (int)scaledY, (int)scaledW, (int)scaledH);
        float mult = 1.0f / this.minimap.getScale();
        float offX = (float)(PosUtil.doubleCoordX() - (double)this.lastX) * mult;
        float offY = (float)(PosUtil.doubleCoordZ() - (double)this.lastZ) * mult;
        RenderSystem.pushMatrix();
        if (ClientParams.rotateMap) {
            float moveX = this.imgX + this.imgW / 2;
            float moveY = this.imgY + this.imgH / 2;
            RenderSystem.translatef((float)moveX, (float)moveY, (float)0.0f);
            RenderSystem.rotatef((float)(-this.rotation + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.translatef((float)(-moveX), (float)(-moveY), (float)0.0f);
        }
        RenderSystem.translatef((float)(-offX), (float)(-offY), (float)0.0f);
        this.drawMap();
        RenderSystem.popMatrix();
        if (Minimap.allowEntityRadar()) {
            if (Minimap.allowPlayerRadar()) {
                for (PlayerIcon player : this.minimap.getPlayerIcons()) {
                    player.draw(this.mapX, this.mapY, offX, offY, this.rotation);
                }
            }
            if (Minimap.allowCreatureRadar() || Minimap.allowHostileRadar()) {
                for (EntityIcon entity : this.minimap.getEntities()) {
                    entity.draw(this.mapX, this.mapY, offX, offY, this.rotation);
                }
            }
        }
        DrawHelper.DRAWER.drawRightAlignedString(this.client.field_1772, Float.toString(this.minimap.getScale()), this.mapX + this.mapW - 3, this.mapY + this.mapH - 10, -1);
        for (WaypointIcon waypoint : this.minimap.getWaypoints()) {
            if (waypoint.isHidden()) continue;
            waypoint.draw(this.mapX, this.mapY, offX, offY, this.rotation);
        }
        GL11.glDisable((int)3089);
        int centerX = this.mapX + this.mapW / 2;
        int centerY = this.mapY + this.mapH / 2;
        int iconSize = ClientParams.arrowIconSize;
        if (ClientParams.arrowIconType == DirectionArrow.Type.DIRECTION_ARROW) {
            float direction = ClientParams.rotateMap ? 180.0f : this.rotation;
            DirectionArrow.draw(centerX, centerY, iconSize, direction);
        } else {
            PlayerHeadIcon.getIcon(this.client.field_1724).draw(centerX, centerY, iconSize, true);
        }
        this.textManager.draw();
        RenderSystem.enableDepthTest();
    }

    private void drawMap() {
        MapCache mapData = MapCache.get();
        int scaledW = this.minimap.getScaledWidth();
        int scaledH = this.minimap.getScaledHeight();
        int cornerX = PosUtil.coordX() - scaledW / 2;
        int cornerZ = PosUtil.coordZ() - scaledH / 2;
        int right = this.imgX + scaledW;
        int bottom = ClientParams.rotateMap ? (int)((double)this.imgY + (double)scaledH * 1.42) : this.imgY + scaledH;
        float scale = this.minimap.getScale();
        int picW = 0;
        for (int picX = 0; picX < scaledW; picX += picW > 0 ? picW : 512) {
            int cX = cornerX + picX;
            int picH = 0;
            for (int picY = 0; picY < scaledH; picY += picH > 0 ? picH : 512) {
                int cZ = cornerZ + picY;
                MapRegion region = mapData.getRegion(new class_2338(cX, 0, cZ));
                picW = 512;
                picH = 512;
                int imgX = cX - (region.getX() << 9);
                int imgY = cZ - (region.getZ() << 9);
                if (picX + picW >= right) {
                    picW = right - picX;
                }
                if (picY + picH >= bottom) {
                    picH = bottom - picY;
                }
                if (imgX + picW >= 512) {
                    picW = 512 - imgX;
                }
                if (imgY + picH >= 512) {
                    picH = 512 - imgY;
                }
                double scX = (float)(picX - 4) / scale;
                double scY = (float)(picY - 4) / scale;
                region.draw((double)this.imgX + scX, (double)this.imgY + scY, imgX, imgY, picW, picH, scale);
            }
        }
    }
}

