/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import net.minecraft.class_4536;
import org.lwjgl.opengl.GL11;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.util.ColorUtil;

public class MapTexture {
    private ByteBuffer buffer;
    private byte[] bytes;
    private int glId = -1;
    private final int width;
    private final int height;
    private Object bufferLock = new Object();

    public MapTexture(int width, int height) {
        int size = 4 * width * (height - 1) + 4 * width;
        this.bytes = new byte[size];
        this.buffer = ByteBuffer.allocateDirect(this.bytes.length).order(ByteOrder.nativeOrder());
        this.width = width;
        this.height = height;
    }

    public int getId() {
        return this.glId;
    }

    public void upload() {
        if (this.glId == -1) {
            this.glId = class_4536.generateTextureId();
        }
        this.refillBuffer();
        RenderSystem.bindTexture((int)this.glId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        RenderSystem.texParameter((int)3553, (int)33169, (int)1);
        RenderSystem.pixelStore((int)3314, (int)0);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)6408, (int)32821, (ByteBuffer)this.buffer);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes() {
        Object object = this.bufferLock;
        synchronized (object) {
            return (byte[])this.bytes.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyData(MapTexture image) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.bytes = image.getBytes();
        }
    }

    public void writeChunkData(int x, int y, int[] colorData) {
        int px;
        for (int i = 0; i < 16 && (px = i + x) < this.getWidth(); ++i) {
            int py;
            if (px < 0) continue;
            for (int j = 0; j < 16 && (py = j + y) < this.getHeight(); ++j) {
                if (py < 0) continue;
                int color = colorData[i + (j << 4)];
                if (ClientParams.showGrid && (i == 0 || j == 0)) {
                    color = ColorUtil.applyTint(color, 0x66333333);
                }
                this.setRGB(px, py, color);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(int x, int y, int color) {
        if (x < 0 || x >= this.getWidth()) {
            return;
        }
        if (y < 0 || y >= this.getHeight()) {
            return;
        }
        int index = (x + y * this.getWidth()) * 4;
        Object object = this.bufferLock;
        synchronized (object) {
            this.bytes[index] = (byte)(color >> 24);
            this.bytes[index + 1] = (byte)(color >> 0);
            this.bytes[index + 2] = (byte)(color >> 8);
            this.bytes[index + 3] = (byte)(color >> 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(int color) {
        int width = this.getWidth();
        int height = this.getHeight();
        Object object = this.bufferLock;
        synchronized (object) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    this.setRGB(x, y, color);
                }
            }
        }
    }

    public void saveImage(File png) {
        try (FileOutputStream fileOut = new FileOutputStream(png);){
            BufferedImage pngImage = new BufferedImage(this.width, this.height, 6);
            byte[] data = ((DataBufferByte)pngImage.getTile(0, 0).getDataBuffer()).getData();
            byte[] bytes = this.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                data[i] = bytes[i];
            }
            ImageIO.write((RenderedImage)pngImage, "png", fileOut);
            pngImage.flush();
        }
        catch (Exception ex) {
            JustMap.LOGGER.logWarning("Can't save image: " + png.toString());
            JustMap.LOGGER.logWarning(ex.getLocalizedMessage());
        }
    }

    public void loadImage(File png) {
        if (!png.exists()) {
            return;
        }
        try (FileInputStream fileInput = new FileInputStream(png);){
            BufferedImage pngImage = new BufferedImage(this.width, this.height, 6);
            pngImage.setData(ImageIO.read(fileInput).getData());
            this.bytes = (byte[])((DataBufferByte)pngImage.getTile(0, 0).getDataBuffer()).getData().clone();
            pngImage.flush();
        }
        catch (Exception ex) {
            JustMap.LOGGER.logWarning("Can't load image: " + png.toString());
            JustMap.LOGGER.logWarning(ex.getLocalizedMessage());
        }
    }

    public void clear() {
        this.fill(-16777216);
        this.upload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.clearId();
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.clear();
        }
    }

    private void clearId() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                if (this.glId != -1) {
                    class_4536.releaseTextureId((int)this.glId);
                    this.glId = -1;
                }
            });
        } else if (this.glId != -1) {
            class_4536.releaseTextureId((int)this.glId);
            this.glId = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillBuffer() {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.clear();
            this.buffer.put(this.bytes);
            this.buffer.position(0).limit(this.bytes.length);
        }
    }
}

