/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.waypoint.Waypoint;
import ru.bulldog.justmap.map.waypoint.WaypointKeeper;
import ru.bulldog.justmap.util.ColorUtil;
import ru.bulldog.justmap.util.DrawHelper;
import ru.bulldog.justmap.util.math.MathUtil;

@Environment(value=EnvType.CLIENT)
public class WaypointRenderer {
    private static WaypointRenderer renderer;
    private static final class_2960 BEAM_TEX;
    private static final class_289 tessellator;
    private static final class_287 builder;

    private static void initBuffer() {
        builder.method_1328(7, class_290.field_1580);
    }

    public static void renderHUD(float delta, float fov) {
        if (ClientParams.waypointsTracking) {
            if (renderer == null) {
                renderer = new WaypointRenderer();
            }
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null || client.field_1724 == null || client.field_1755 != null) {
                return;
            }
            List<Waypoint> wayPoints = WaypointKeeper.getInstance().getWaypoints(client.field_1687.field_9247.method_12460().method_12484(), true);
            for (Waypoint wp : wayPoints) {
                int dist = (int)MathUtil.getDistance(wp.pos, client.field_1724.method_5704(), false);
                if (!wp.tracking || dist > wp.showRange) continue;
                renderer.renderHUD(wp, client, delta, fov, dist);
            }
        }
    }

    private void renderHUD(Waypoint waypoint, class_310 client, float delta, float fov, int dist) {
        int wpX = waypoint.pos.method_10263();
        int wpZ = waypoint.pos.method_10260();
        Waypoint.Icon icon = waypoint.getIcon();
        int size = icon != null ? icon.method_4578() : 18;
        int screenWidth = client.method_22683().method_4486();
        double dx = client.field_1724.method_23317() - (double)wpX;
        double dy = (double)wpZ - client.field_1724.method_23321();
        double wfi = this.correctAngle((float)(Math.atan2(dx, dy) * 57.29577951308232));
        double pfi = this.correctAngle(client.field_1724.method_5705(delta) % 360.0f);
        double a0 = pfi - (double)(fov / 2.0f);
        double a1 = pfi + (double)(fov / 2.0f);
        double ax = this.correctAngle((float)(2.0 * pfi - wfi));
        double scale = (MathUtil.clamp(ax, a0, a1) - a0) / (double)fov;
        int x = (int)Math.round(MathUtil.clamp((double)screenWidth - (double)screenWidth * scale - (double)(size / 2), 0.0, (double)(screenWidth - size)));
        int y = ClientParams.positionOffset;
        if (icon != null) {
            icon.draw(x, y);
        } else {
            DrawHelper.drawDiamond(x, y, size, size, waypoint.color);
        }
        DrawHelper.drawBoundedString(dist + "m", x + size / 2, y + size + 2, 0, screenWidth, -1);
    }

    public static void renderWaypoints(class_4587 matrixStack, class_310 client, class_4184 camera, float tickDelta) {
        if (ClientParams.waypointsWorldRender) {
            if (renderer == null) {
                renderer = new WaypointRenderer();
            }
            long time = client.field_1724.field_6002.method_8510();
            float tick = (float)Math.floorMod(time, 125L) + tickDelta;
            class_2338 playerPos = client.field_1724.method_5704();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            List<Waypoint> wayPoints = WaypointKeeper.getInstance().getWaypoints(client.field_1687.field_9247.method_12460().method_12484(), true);
            for (Waypoint wp : wayPoints) {
                int dist = (int)MathUtil.getDistance(wp.pos, playerPos, false);
                if (!wp.render || dist <= ClientParams.minRenderDist || dist >= ClientParams.maxRenderDist) continue;
                renderer.renderWaypoint(matrixStack, wp, client, camera, tick, dist);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    private void renderWaypoint(class_4587 matrixStack, Waypoint waypoint, class_310 client, class_4184 camera, float tick, int dist) {
        int wpX = waypoint.pos.method_10263();
        int wpY = waypoint.pos.method_10264();
        int wpZ = waypoint.pos.method_10260();
        class_243 vec3d = camera.method_19326();
        double camX = vec3d.method_10216();
        double camY = vec3d.method_10214();
        double camZ = vec3d.method_10215();
        float[] colors = ColorUtil.toFloatArray(waypoint.color);
        float alpha = MathUtil.clamp(0.125f * ((float)dist / 10.0f), 0.11f, 0.275f);
        matrixStack.method_22903();
        matrixStack.method_22904((double)wpX - camX, (double)wpY - camY, (double)wpZ - camZ);
        matrixStack.method_22904(0.5, 0.5, 0.5);
        if (ClientParams.renderLightBeam) {
            this.renderLightBeam(matrixStack, tick, -wpY, 1024 - wpY, colors, alpha, 0.15f, 0.2f);
        }
        if (ClientParams.renderMarkers) {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 1.0, 0.0);
            if (ClientParams.renderAnimation) {
                double swing = 0.25 * Math.sin(((double)tick * 2.25 - 45.0) / 15.0);
                matrixStack.method_22904(0.0, swing, 0.0);
            }
            matrixStack.method_22907(camera.method_23767());
            matrixStack.method_22907(class_1160.field_20705.method_23214(180.0f));
            matrixStack.method_22907(class_1160.field_20707.method_23214(-90.0f));
            alpha = MathUtil.clamp(alpha * 3.0f, 0.0f, 1.0f);
            WaypointRenderer.initBuffer();
            waypoint.getIcon().bindTexture();
            this.renderIcon(matrixStack, (class_4588)builder, colors, alpha, waypoint.getIcon().method_4578());
            tessellator.method_1350();
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    private void renderIcon(class_4587 matrixStack, class_4588 vertexConsumer, float[] colors, float alpha, int size) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_1159 matrix4f = entry.method_23761();
        class_4581 matrix3f = entry.method_23762();
        this.addVertex(matrix4f, matrix3f, vertexConsumer, colors[0], colors[1], colors[2], alpha, -0.5f, -0.5f, 0.0f, 0.0f, 0.0f);
        this.addVertex(matrix4f, matrix3f, vertexConsumer, colors[0], colors[1], colors[2], alpha, -0.5f, 0.5f, 0.0f, 0.0f, 1.0f);
        this.addVertex(matrix4f, matrix3f, vertexConsumer, colors[0], colors[1], colors[2], alpha, 0.5f, 0.5f, 0.0f, 1.0f, 1.0f);
        this.addVertex(matrix4f, matrix3f, vertexConsumer, colors[0], colors[1], colors[2], alpha, 0.5f, -0.5f, 0.0f, 1.0f, 0.0f);
    }

    private void renderLightBeam(class_4587 matrixStack, float tick, int i, int j, float[] colors, float alpha, float h, float k) {
        int m = i + j;
        float o = j < 0 ? tick : -tick;
        float p = class_3532.method_22450((float)(o * 0.2f - (float)class_3532.method_15375((float)(o * 0.1f))));
        float red = colors[0];
        float green = colors[1];
        float blue = colors[2];
        matrixStack.method_22903();
        matrixStack.method_22907(class_1160.field_20705.method_23214(tick * 2.25f - 45.0f));
        float af = 0.0f;
        float ai = 0.0f;
        float aj = -h;
        float aa = -h;
        float ap = -1.0f + p;
        float aq = (float)j * (0.5f / h) + ap;
        WaypointRenderer.initBuffer();
        class_310.method_1551().method_1531().method_22813(BEAM_TEX);
        this.renderBeam(matrixStack, (class_4588)builder, red, green, blue, alpha, i, m, 0.0f, h, h, 0.0f, aj, 0.0f, 0.0f, aa, 0.0f, 1.0f, aq, ap);
        matrixStack.method_22909();
        af = -k;
        float ag = -k;
        ai = -k;
        aj = -k;
        ap = -1.0f + p;
        aq = (float)j + ap;
        this.renderBeam(matrixStack, (class_4588)builder, red, green, blue, alpha, i, m, af, ag, k, ai, aj, k, k, k, 0.0f, 1.0f, aq, ap);
        tessellator.method_1350();
    }

    private void renderBeam(class_4587 matrixStack, class_4588 vertexConsumer, float red, float green, float blue, float alpha, int j, int k, float l, float m, float n, float o, float p, float q, float r, float s, float t, float u, float v, float w) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_1159 matrix4f = entry.method_23761();
        class_4581 matrix3f = entry.method_23762();
        this.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, j, k, l, m, n, o, t, u, v, w);
        this.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, j, k, r, s, p, q, t, u, v, w);
        this.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, j, k, n, o, r, s, t, u, v, w);
        this.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, j, k, p, q, l, m, t, u, v, w);
    }

    private void renderBeam(class_1159 matrix4f, class_4581 matrix3f, class_4588 vertexConsumer, float red, float green, float blue, float alpha, int j, int k, float l, float m, float n, float o, float p, float q, float r, float s) {
        this.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, k, l, m, q, r);
        this.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, j, l, m, q, s);
        this.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, j, n, o, p, s);
        this.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, k, n, o, p, r);
    }

    private void addVertex(class_1159 matrix4f, class_4581 matrix3f, class_4588 vertexConsumer, float red, float green, float blue, float alpha, float y, float x, float l, float m, float n) {
        vertexConsumer.method_22918(matrix4f, x, y, l).method_22915(red, green, blue, alpha).method_22913(m, n).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
    }

    private double correctAngle(float angle) {
        double d;
        if (angle < 0.0f) {
            angle = (float)((double)angle + 360.0);
            d = angle;
        } else if ((double)angle >= 360.0) {
            angle = (float)((double)angle - 360.0);
            d = angle;
        } else {
            d = angle;
        }
        return d;
    }

    static {
        BEAM_TEX = new class_2960("textures/entity/beacon_beam.png");
        tessellator = class_289.method_1348();
        builder = tessellator.method_1349();
    }
}

