/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.config;

import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.config.ConfigKeeper;

public abstract class Config {
    protected static final ConfigKeeper KEEPER = ConfigKeeper.getInstance();

    public abstract void saveChanges();

    public ConfigKeeper.Entry<?> getEntry(String key) {
        return KEEPER.getEntry(key);
    }

    public Object getDefault(String key) {
        ConfigKeeper.Entry<?> entry = KEEPER.getEntry(key);
        return entry != null ? entry.getDefault() : null;
    }

    public String getString(String key) {
        String str = (String)KEEPER.getValue(key);
        return str != null ? str : "";
    }

    public boolean setString(String key, String value) {
        try {
            ConfigKeeper.StringEntry entry = (ConfigKeeper.StringEntry)KEEPER.getEntry(key);
            entry.setValue(value);
            KEEPER.set(key, entry);
            return true;
        }
        catch (NullPointerException ex) {
            JustMap.LOGGER.catching(ex);
            return false;
        }
    }

    public int getInt(String key) {
        Integer val = (Integer)KEEPER.getValue(key);
        return val != null ? val : 0;
    }

    public boolean setInt(String key, int value) {
        try {
            ConfigKeeper.IntegerEntry entry = (ConfigKeeper.IntegerEntry)KEEPER.getEntry(key);
            entry.setValue(value);
            KEEPER.set(key, entry);
            return true;
        }
        catch (NullPointerException ex) {
            JustMap.LOGGER.catching(ex);
            return false;
        }
    }

    public <T extends Comparable<T>> boolean setRanged(String key, T value) {
        try {
            ConfigKeeper.Entry<?> entry = KEEPER.getEntry(key);
            if (entry instanceof ConfigKeeper.RangeEntry) {
                ConfigKeeper.RangeEntry range = (ConfigKeeper.RangeEntry)entry;
                range.setValue(value);
                KEEPER.set(key, range);
                return true;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException ex) {
            JustMap.LOGGER.catching(ex);
            return false;
        }
    }

    public float getFloat(String key) {
        Float val = (Float)KEEPER.getValue(key);
        return val != null ? val.floatValue() : 0.0f;
    }

    public boolean setFloat(String key, float value) {
        try {
            ConfigKeeper.FloatEntry entry = (ConfigKeeper.FloatEntry)KEEPER.getEntry(key);
            entry.setValue(Float.valueOf(value));
            KEEPER.set(key, entry);
            return true;
        }
        catch (NullPointerException ex) {
            JustMap.LOGGER.catching(ex);
            return false;
        }
    }

    public boolean getBoolean(String key) {
        Boolean val = (Boolean)KEEPER.getValue(key);
        return val != null ? val : false;
    }

    public boolean setBoolean(String key, boolean value) {
        try {
            ConfigKeeper.BooleanEntry entry = (ConfigKeeper.BooleanEntry)KEEPER.getEntry(key);
            entry.setValue(value);
            KEEPER.set(key, entry);
            return true;
        }
        catch (NullPointerException ex) {
            JustMap.LOGGER.catching(ex);
            return false;
        }
    }
}

