/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_3518;
import ru.bulldog.justmap.JustMap;

public final class ConfigKeeper {
    private Map<String, Entry<?>> configEntries = new HashMap();
    private static ConfigKeeper instance;

    public static ConfigKeeper getInstance() {
        if (instance == null) {
            instance = new ConfigKeeper();
        }
        return instance;
    }

    private ConfigKeeper() {
    }

    public Entry<?> getEntry(String key) {
        Entry<?> entry = this.configEntries.get(key);
        if (entry == null) {
            JustMap.LOGGER.logWarning(String.format("Entry '%s' doesn't exists.", key));
            return null;
        }
        return entry;
    }

    public Object getValue(String key) {
        Entry<?> entry = this.getEntry(key);
        if (entry == null) {
            JustMap.LOGGER.logWarning(String.format("Empty value will be returned.", key));
            return null;
        }
        return entry.getValue();
    }

    public void set(String key, Entry<?> entry) {
        this.configEntries.put(key, entry);
    }

    public <T extends Entry<?>> void registerEntry(String key, T entry) {
        this.configEntries.put(key, entry);
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        for (String param : this.configEntries.keySet()) {
            jsonObject.addProperty(param, this.configEntries.get(param).asString());
        }
        return jsonObject;
    }

    public void fromJson(JsonObject jsonObject) {
        for (String param : this.configEntries.keySet()) {
            if (!jsonObject.has(param)) continue;
            Entry<?> entry = this.configEntries.get(param);
            entry.fromString(class_3518.method_15265((JsonObject)jsonObject, (String)param));
            this.configEntries.put(param, entry);
        }
    }

    public static abstract class Entry<T> {
        protected final T defaultValue;
        protected final Consumer<T> setter;
        protected final Supplier<T> getter;

        public Entry(T defaultValue, Consumer<T> consumer, Supplier<T> supplier) {
            this.defaultValue = defaultValue;
            this.setter = consumer;
            this.getter = supplier;
        }

        public abstract T getValue();

        public abstract void setValue(T var1);

        public abstract T getDefault();

        public abstract void fromString(String var1);

        public abstract String asString();

        public void setDefault() {
            this.setter.accept(this.defaultValue);
        }
    }

    public static abstract class RangeEntry<T extends Comparable<T>>
    extends Entry<T> {
        private final T min;
        private final T max;

        public RangeEntry(T defaultValue, Consumer<T> consumer, Supplier<T> supplier, T minVal, T maxVal) {
            super(defaultValue, consumer, supplier);
            this.min = minVal;
            this.max = maxVal;
        }

        @Override
        public void setValue(T value) {
            this.setter.accept(value.compareTo(this.min) < 0 ? this.min : (value.compareTo(this.max) > 0 ? this.max : value));
        }
    }

    public static class EnumEntry<T extends Enum<T>>
    extends Entry<T> {
        public EnumEntry(T defaultValue, Consumer<T> consumer, Supplier<T> supplier) {
            super(defaultValue, consumer, supplier);
        }

        @Override
        public T getValue() {
            return (T)((Enum)this.getter.get());
        }

        @Override
        public void setValue(T value) {
            this.setter.accept(value);
        }

        public boolean setValue(String name) {
            try {
                this.setter.accept(Enum.valueOf(((Enum)this.defaultValue).getClass(), name));
                return true;
            }
            catch (IllegalArgumentException ex) {
                JustMap.LOGGER.catching(ex);
                return false;
            }
        }

        @Override
        public T getDefault() {
            return (T)((Enum)this.defaultValue);
        }

        @Override
        public String asString() {
            return ((Enum)this.getValue()).name();
        }

        @Override
        public void fromString(String value) {
            this.setValue(value);
        }
    }

    public static class StringEntry
    extends Entry<String> {
        public StringEntry(String defaultValue, Consumer<String> consumer, Supplier<String> supplier) {
            super(defaultValue, consumer, supplier);
        }

        @Override
        public String getValue() {
            return (String)this.getter.get();
        }

        @Override
        public void setValue(String value) {
            this.setter.accept(value);
        }

        @Override
        public String getDefault() {
            return (String)this.defaultValue;
        }

        @Override
        public String asString() {
            return this.getValue();
        }

        @Override
        public void fromString(String value) {
            this.setValue(value);
        }
    }

    public static class IntegerRange
    extends RangeEntry<Integer> {
        public IntegerRange(Integer defaultValue, Consumer<Integer> consumer, Supplier<Integer> supplier, Integer minVal, Integer maxVal) {
            super(defaultValue, consumer, supplier, minVal, maxVal);
        }

        @Override
        public Integer getValue() {
            return (Integer)this.getter.get();
        }

        @Override
        public Integer getDefault() {
            return (Integer)this.defaultValue;
        }

        @Override
        public void fromString(String value) {
            this.setValue(Integer.valueOf(value));
        }

        @Override
        public String asString() {
            return Integer.toString(this.getValue());
        }
    }

    public static class IntegerEntry
    extends Entry<Integer> {
        public IntegerEntry(Integer defaultValue, Consumer<Integer> consumer, Supplier<Integer> supplier) {
            super(defaultValue, consumer, supplier);
        }

        @Override
        public Integer getValue() {
            return (Integer)this.getter.get();
        }

        @Override
        public void setValue(Integer value) {
            this.setter.accept(value);
        }

        @Override
        public Integer getDefault() {
            return (Integer)this.defaultValue;
        }

        @Override
        public String asString() {
            return Integer.toString(this.getValue());
        }

        @Override
        public void fromString(String value) {
            this.setValue(Integer.valueOf(value));
        }
    }

    public static class FloatRange
    extends RangeEntry<Float> {
        public FloatRange(Float defaultValue, Consumer<Float> consumer, Supplier<Float> supplier, Float minVal, Float maxVal) {
            super(defaultValue, consumer, supplier, minVal, maxVal);
        }

        @Override
        public Float getValue() {
            return (Float)this.getter.get();
        }

        @Override
        public Float getDefault() {
            return (Float)this.defaultValue;
        }

        @Override
        public void fromString(String value) {
            this.setValue(Float.valueOf(value));
        }

        @Override
        public String asString() {
            return Float.toString(this.getValue().floatValue());
        }
    }

    public static class FloatEntry
    extends Entry<Float> {
        public FloatEntry(Float defaultValue, Consumer<Float> consumer, Supplier<Float> supplier) {
            super(defaultValue, consumer, supplier);
        }

        @Override
        public Float getValue() {
            return (Float)this.getter.get();
        }

        @Override
        public void setValue(Float value) {
            this.setter.accept(value);
        }

        @Override
        public Float getDefault() {
            return (Float)this.defaultValue;
        }

        @Override
        public String asString() {
            return Float.toString(this.getValue().floatValue());
        }

        @Override
        public void fromString(String value) {
            this.setValue(Float.valueOf(value));
        }
    }

    public static class BooleanEntry
    extends Entry<Boolean> {
        public BooleanEntry(Boolean defaultValue, Consumer<Boolean> consumer, Supplier<Boolean> supplier) {
            super(defaultValue, consumer, supplier);
        }

        @Override
        public Boolean getValue() {
            return (Boolean)this.getter.get();
        }

        @Override
        public void setValue(Boolean value) {
            this.setter.accept(value);
        }

        @Override
        public Boolean getDefault() {
            return (Boolean)this.defaultValue;
        }

        @Override
        public String asString() {
            return this.getValue() != false ? "true" : "false";
        }

        @Override
        public void fromString(String value) {
            this.setValue(value.equals("true"));
        }
    }
}

