/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2874;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.client.MapScreen;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.client.config.ConfigFactory;
import ru.bulldog.justmap.map.IMap;
import ru.bulldog.justmap.map.data.Layer;
import ru.bulldog.justmap.map.data.MapCache;
import ru.bulldog.justmap.map.data.MapChunk;
import ru.bulldog.justmap.map.data.MapRegion;
import ru.bulldog.justmap.map.icon.PlayerHeadIcon;
import ru.bulldog.justmap.map.icon.WaypointIcon;
import ru.bulldog.justmap.map.waypoint.Waypoint;
import ru.bulldog.justmap.map.waypoint.WaypointKeeper;
import ru.bulldog.justmap.map.waypoint.WaypointsList;
import ru.bulldog.justmap.util.PosUtil;
import ru.bulldog.justmap.util.math.MathUtil;

public class Worldmap
extends MapScreen
implements IMap {
    private static final class_2585 TITLE = new class_2585("Worldmap");
    private static Worldmap worldmap;
    private int scaledWidth;
    private int scaledHeight;
    private double centerX;
    private double centerZ;
    private double startX;
    private double startZ;
    private double endX;
    private double endZ;
    private double shiftW;
    private double shiftH;
    private float imageScale = 1.0f;
    private boolean playerTracking = true;
    private long updateInterval = 50L;
    private long updated = 0L;
    private class_2874 dimension;
    private class_2338 centerPos;
    private String cursorCoords;
    private List<WaypointIcon> waypoints = new ArrayList<WaypointIcon>();
    private int clicks = 0;
    private long clicked = 0L;

    public static Worldmap getScreen() {
        if (worldmap == null) {
            worldmap = new Worldmap();
        }
        return worldmap;
    }

    private Worldmap() {
        super((class_2561)TITLE);
    }

    @Override
    public void init() {
        super.init();
        this.paddingTop = 8;
        this.paddingBottom = 8;
        class_746 player = this.minecraft.field_1724;
        if (this.centerPos == null || player.field_6026 != this.dimension) {
            this.dimension = player.field_6026;
            this.centerPos = PosUtil.currentPos();
        } else if (this.playerTracking) {
            this.centerPos = PosUtil.currentPos();
        }
        this.cursorCoords = PosUtil.posToString(this.centerPos);
        this.addMapButtons();
        this.updateScale();
        this.waypoints.clear();
        List<Waypoint> wps = WaypointKeeper.getInstance().getWaypoints(this.dimension.method_12484(), true);
        if (wps != null) {
            Stream<Waypoint> stream = wps.stream().filter(arg_0 -> Worldmap.lambda$init$0((class_1657)player, arg_0));
            for (Waypoint wp : (Waypoint[])stream.toArray(Waypoint[]::new)) {
                WaypointIcon waypoint = new WaypointIcon(this, wp);
                this.waypoints.add(waypoint);
            }
        }
    }

    private void addMapButtons() {
        this.children.add(new class_4185(this.width - 24, 10, 20, 20, "x", b -> this.onClose()));
        this.children.add(new class_4185(this.width / 2 - 10, this.height - this.paddingBottom - 44, 20, 20, "\u2191", b -> this.moveMap(class_2350.field_11043)));
        this.children.add(new class_4185(this.width / 2 - 10, this.height - this.paddingBottom - 22, 20, 20, "\u2193", b -> this.moveMap(class_2350.field_11035)));
        this.children.add(new class_4185(this.width / 2 - 32, this.height - this.paddingBottom - 32, 20, 20, "\u2190", b -> this.moveMap(class_2350.field_11039)));
        this.children.add(new class_4185(this.width / 2 + 12, this.height - this.paddingBottom - 32, 20, 20, "\u2192", b -> this.moveMap(class_2350.field_11034)));
        this.children.add(new class_4185(this.width - 24, this.height / 2 - 21, 20, 20, "+", b -> this.changeScale(-0.25f)));
        this.children.add(new class_4185(this.width - 24, this.height / 2 + 1, 20, 20, "-", b -> this.changeScale(0.25f)));
        this.children.add(new class_4185(this.width - 24, this.height - this.paddingBottom - 22, 20, 20, "\u271c", b -> this.setCenterByPlayer()));
        this.children.add(new class_4185(4, this.paddingTop + 2, 20, 20, "\u2630", b -> this.minecraft.method_1507(ConfigFactory.getConfigScreen(this))));
        this.children.add(new class_4185(4, this.height - this.paddingBottom - 22, 20, 20, "\u2726", b -> this.minecraft.method_1507((class_437)new WaypointsList(this))));
    }

    @Override
    public void renderBackground() {
        Worldmap.fill((int)this.x, (int)0, (int)(this.x + this.width), (int)this.height, (int)-12303292);
        this.drawMap();
    }

    @Override
    public void renderForeground() {
        RenderSystem.disableDepthTest();
        int iconSize = (int)((float)ClientParams.worldmapIconSize / this.imageScale);
        iconSize = iconSize % 2 != 0 ? iconSize + 1 : iconSize;
        iconSize = MathUtil.clamp(iconSize, 6, (int)((double)ClientParams.worldmapIconSize * 1.2));
        for (WaypointIcon icon : this.waypoints) {
            icon.setPosition(MathUtil.screenPos(icon.waypoint.pos.method_10263(), this.startX, this.endX, this.width) - this.shiftW, MathUtil.screenPos(icon.waypoint.pos.method_10260(), this.startZ, this.endZ, this.height) - this.shiftH);
            icon.draw(iconSize);
        }
        class_746 player = this.minecraft.field_1724;
        double playerX = player.method_23317();
        double playerZ = player.method_23321();
        double arrowX = MathUtil.screenPos(playerX, this.startX, this.endX, this.width) - this.shiftW;
        double arrowY = MathUtil.screenPos(playerZ, this.startZ, this.endZ, this.height) - this.shiftH;
        PlayerHeadIcon.getIcon(player).draw(arrowX, arrowY, iconSize, true);
        this.drawBorders(this.paddingTop, this.paddingBottom);
        this.drawCenteredString(this.minecraft.field_1772, this.cursorCoords, this.width / 2, this.paddingTop + 4, -1);
        RenderSystem.enableDepthTest();
    }

    private void drawMap() {
        MapCache mapData = MapCache.get();
        boolean surfaceOnly = !this.dimension.equals(class_2874.field_13076);
        int cornerX = this.centerPos.method_10263() - this.scaledWidth / 2;
        int cornerZ = this.centerPos.method_10260() - this.scaledHeight / 2;
        int picW = 0;
        for (int picX = 0; picX < this.scaledWidth; picX += picW > 0 ? picW : 512) {
            int cX = cornerX + picX;
            int picH = 0;
            for (int picY = 0; picY < this.scaledHeight; picY += picH > 0 ? picH : 512) {
                int cZ = cornerZ + picY;
                MapRegion region = mapData.getRegion(new class_2338(cX, 0, cZ), surfaceOnly);
                picW = 512;
                picH = 512;
                int imgX = cX - (region.getX() << 9);
                int imgY = cZ - (region.getZ() << 9);
                if (picX + picW >= this.scaledWidth) {
                    picW = this.scaledWidth - picX;
                }
                if (picY + picH >= this.scaledHeight) {
                    picH = this.scaledHeight - picY;
                }
                if (imgX + picW >= 512) {
                    picW = 512 - imgX;
                }
                if (imgY + picH >= 512) {
                    picH = 512 - imgY;
                }
                double scX = (float)picX / this.imageScale;
                double scY = (float)picY / this.imageScale;
                region.draw(scX, scY, imgX, imgY, picW, picH, this.imageScale);
            }
        }
    }

    private void calculateShift() {
        this.centerX = this.centerPos.method_10263() >> 4 << 4;
        this.centerZ = this.centerPos.method_10260() >> 4 << 4;
        this.startX = this.centerX - (double)(this.scaledWidth / 2);
        this.startZ = this.centerZ - (double)(this.scaledHeight / 2);
        this.endX = this.startX + (double)this.scaledWidth;
        this.endZ = this.startZ + (double)this.scaledHeight;
        double screenCX = MathUtil.screenPos(this.centerPos.method_10263(), this.startX, this.endX, this.width);
        double screenCY = MathUtil.screenPos(this.centerPos.method_10260(), this.startZ, this.endZ, this.height);
        this.shiftW = screenCX - (double)((float)this.width / 2.0f);
        this.shiftH = screenCY - (double)((float)this.height / 2.0f);
    }

    public void setCenterByPlayer() {
        this.playerTracking = true;
        this.centerPos = PosUtil.currentPos();
        this.calculateShift();
    }

    private void updateScale() {
        this.scaledWidth = (int)Math.ceil((float)this.width * this.imageScale);
        this.scaledHeight = (int)Math.ceil((float)this.height * this.imageScale);
        if (this.scaledWidth > 2580) {
            this.imageScale = 2580.0f / (float)this.width;
            this.updateScale();
            return;
        }
        this.calculateShift();
        this.updateInterval = (long)(this.imageScale > 1.0f ? 10.0f * this.imageScale : 10.0f);
    }

    private void changeScale(float value) {
        this.imageScale = MathUtil.clamp(this.imageScale + value, 0.5f, 3.0f);
        this.updateScale();
    }

    private void moveMap(class_2350 direction) {
        long time = System.currentTimeMillis();
        if (time - this.updated < this.updateInterval) {
            return;
        }
        switch (direction) {
            case field_11043: {
                this.centerPos = this.centerPos.method_10069(0, 0, -16);
                break;
            }
            case field_11035: {
                this.centerPos = this.centerPos.method_10069(0, 0, 16);
                break;
            }
            case field_11034: {
                this.centerPos = this.centerPos.method_10069(16, 0, 0);
                break;
            }
            case field_11039: {
                this.centerPos = this.centerPos.method_10069(-16, 0, 0);
                break;
            }
        }
        this.calculateShift();
        this.playerTracking = false;
        this.updated = time;
    }

    public boolean keyPressed(int i, int j, int k) {
        switch (i) {
            case 87: 
            case 265: {
                this.moveMap(class_2350.field_11043);
                return true;
            }
            case 83: 
            case 264: {
                this.moveMap(class_2350.field_11035);
                return true;
            }
            case 65: 
            case 263: {
                this.moveMap(class_2350.field_11039);
                return true;
            }
            case 68: 
            case 262: {
                this.moveMap(class_2350.field_11034);
                return true;
            }
            case 45: 
            case 333: {
                this.changeScale(0.25f);
                return true;
            }
            case 61: 
            case 334: {
                this.changeScale(-0.25f);
                return true;
            }
            case 88: {
                this.setCenterByPlayer();
                return true;
            }
            case 77: {
                this.onClose();
                return true;
            }
        }
        return super.keyPressed(i, j, k);
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (super.mouseDragged(d, e, i, f, g)) {
            return true;
        }
        if (i == 0) {
            long time = System.currentTimeMillis();
            if (time - this.updated < this.updateInterval) {
                return true;
            }
            int x = this.centerPos.method_10263();
            int y = this.centerPos.method_10264();
            int z = this.centerPos.method_10260();
            x = (int)((long)x - Math.round(2.0 * f * (double)this.imageScale));
            z = (int)((long)z - Math.round(2.0 * g * (double)this.imageScale));
            this.centerPos = new class_2338(x, y, z);
            this.calculateShift();
            this.playerTracking = false;
            this.updated = time;
            return true;
        }
        return false;
    }

    private int pixelToPos(double x, int cx, double range, double scaledRange) {
        double x1 = (double)cx - scaledRange / 2.0;
        double x2 = x1 + scaledRange;
        return MathUtil.worldPos(x, x1, x2, range);
    }

    private class_2338 cursorBlockPos(double x, double y) {
        int posX = this.pixelToPos(x, this.centerPos.method_10263(), this.width, this.scaledWidth);
        int posZ = this.pixelToPos(y, this.centerPos.method_10260(), this.height, this.scaledHeight);
        int chunkX = posX >> 4;
        int chunkZ = posZ >> 4;
        MapChunk mapChunk = this.dimension == class_2874.field_13076 ? MapCache.get().getCurrentChunk(chunkX, chunkZ) : MapCache.get().getChunk(Layer.Type.SURFACE, 0, chunkX, chunkZ);
        int cx = posX - (chunkX << 4);
        int cz = posZ - (chunkZ << 4);
        int posY = mapChunk.getHeighmap()[cx + (cz << 4)];
        posY = posY == -1 ? this.centerPos.method_10264() : posY;
        return new class_2338(posX, posY, posZ);
    }

    public void method_16014(double d, double e) {
        this.cursorCoords = PosUtil.posToString(this.cursorBlockPos(d, e));
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (super.mouseReleased(d, e, i)) {
            return true;
        }
        if (i == 0) {
            long time = System.currentTimeMillis();
            if (time - this.clicked > 300L) {
                this.clicks = 0;
            }
            if (++this.clicks == 2) {
                JustMapClient.MAP.createWaypoint(this.dimension.method_12484(), this.cursorBlockPos(d, e));
                this.clicked = 0L;
                this.clicks = 0;
            } else {
                this.clicked = time;
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double d, double e, double f) {
        boolean scrolled = super.mouseScrolled(d, e, f);
        this.changeScale(f > 0.0 ? -0.25f : 0.25f);
        return scrolled;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getScaledWidth() {
        return this.scaledWidth;
    }

    @Override
    public int getScaledHeight() {
        return this.scaledHeight;
    }

    @Override
    public float getScale() {
        return this.getScale();
    }

    private static /* synthetic */ boolean lambda$init$0(class_1657 player, Waypoint wp) {
        return MathUtil.getDistance(player.method_5704(), wp.pos) <= (double)wp.showRange;
    }
}

