/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import java.util.Arrays;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2816;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import ru.bulldog.justmap.util.ColorUtil;
import ru.bulldog.justmap.util.StateUtil;

public class ChunkLevel {
    private static final class_2837<class_2680> palette = new class_2816(class_2248.field_10651, (Object)StateUtil.AIR);
    private volatile class_2841<class_2680> container = new class_2841(palette, class_2248.field_10651, class_2512::method_10681, class_2512::method_10686, (Object)StateUtil.AIR);
    int[] heightmap = new int[256];
    int[] colormap = new int[256];
    int[] colordata = new int[256];
    int[] levelmap = new int[256];
    long updated = 0L;
    int level;

    ChunkLevel(int level) {
        this.level = level;
        Arrays.fill(this.heightmap, -1);
        Arrays.fill(this.colormap, -1);
        Arrays.fill(this.levelmap, 0);
        Arrays.fill(this.colordata, -16777216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2841<class_2680> container() {
        class_2841<class_2680> class_28412 = this.container;
        synchronized (class_28412) {
            return this.container;
        }
    }

    public class_2680 getBlockState(int x, int y, int z) {
        return (class_2680)this.container().method_12321(x, y, z);
    }

    public class_2680 setBlockState(int x, int y, int z, class_2680 blockState) {
        return (class_2680)this.container().method_16678(x, y, z, (Object)blockState);
    }

    public void updateHeightmap(int x, int z, int y) {
        int index = x + (z << 4);
        if (this.heightmap[index] != y) {
            this.setBlockState(x, this.heightmap[index] & 0xF, z, StateUtil.AIR);
            this.heightmap[index] = y;
        }
    }

    public void clear(int x, int z) {
        int index = x + (z << 4);
        if (this.heightmap[index] != -1) {
            this.setBlockState(x, this.heightmap[index] & 0xF, z, StateUtil.AIR);
            this.heightmap[index] = -1;
        }
        this.colormap[index] = -1;
        this.levelmap[index] = 0;
        this.colordata[index] = -16777216;
    }

    public boolean isEmpty() {
        return this.level == -1;
    }

    public void store(class_2487 tag) {
        tag.method_10539("Heightmap", this.heightmap);
        tag.method_10539("Colormap", this.colormap);
        tag.method_10539("Levelmap", this.levelmap);
    }

    public void load(class_2487 tag) {
        if (tag.isEmpty()) {
            return;
        }
        this.heightmap = tag.method_10561("Heightmap");
        this.colormap = tag.method_10561("Colormap");
        this.levelmap = tag.method_10561("Levelmap");
        for (int i = 0; i < 256; ++i) {
            int color = this.colormap[i];
            if (color == -1) continue;
            int level = this.levelmap[i];
            this.colordata[i] = ColorUtil.proccessColor(color, level);
        }
    }
}

