/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_638;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.data.Layer;
import ru.bulldog.justmap.map.data.MapChunk;
import ru.bulldog.justmap.map.data.MapRegion;
import ru.bulldog.justmap.map.data.RegionPos;
import ru.bulldog.justmap.util.StorageUtil;

public class MapCache {
    private static final class_310 minecraft = class_310.method_1551();
    private static Map<Integer, MapCache> dimensions = new HashMap<Integer, MapCache>();
    private static class_1937 currentWorld;
    private static Layer.Type currentLayer;
    private static int currentLevel;
    private static int currentDimension;
    public static long lastSaved;
    public class_1937 world;
    private Map<class_1923, MapChunk> chunks;
    private Map<RegionPos, MapRegion> regions;
    private long lastPurged = 0L;
    private long purgeDelay = 1000L;
    private int purgeAmount = 500;

    public static void setCurrentLayer(Layer.Type layer, int y) {
        currentLevel = y / layer.value.height;
        currentLayer = layer;
    }

    public static Layer.Type currentLayer() {
        return currentLayer;
    }

    public static int currentLevel() {
        return currentLevel;
    }

    public static void setLayerLevel(int level) {
        currentLevel = level > 0 ? level : 0;
    }

    public static MapCache get() {
        class_638 world = MapCache.minecraft.field_1687;
        if (minecraft.method_1496() && world != null) {
            world = minecraft.method_1576().method_3847(MapCache.minecraft.field_1724.field_6026);
        }
        if (currentWorld == null || world != null && world != currentWorld) {
            currentWorld = world;
        }
        if (currentWorld == null) {
            return null;
        }
        int dimId = MapCache.currentWorld.field_9247.method_12460().method_12484();
        if (currentDimension != dimId) {
            StorageUtil.updateCacheStorage();
            currentDimension = dimId;
        }
        return MapCache.get(currentWorld, currentDimension);
    }

    public static MapCache get(class_1937 world, int dimension) {
        MapCache data = MapCache.getData(world, dimension);
        if (data == null) {
            return null;
        }
        if (data.world != world) {
            data.world = world;
            data.clear();
        } else {
            data.clearCache();
        }
        return data;
    }

    private static MapCache getData(class_1937 world, int dimendion) {
        if (world == null) {
            return null;
        }
        if (dimensions.containsKey(dimendion)) {
            return dimensions.get(dimendion);
        }
        MapCache data = new MapCache(world);
        dimensions.put(dimendion, data);
        return data;
    }

    public static class_2874 getDimension() {
        return class_2874.method_12490((int)currentDimension);
    }

    public static void saveData() {
        MapCache data = MapCache.get();
        if (data == null) {
            return;
        }
        JustMap.WORKER.execute(() -> data.getChunks().forEach((pos, chunk) -> MapCache.storeChunk(chunk)));
        lastSaved = System.currentTimeMillis();
    }

    public static void storeChunk(MapChunk chunk) {
        if (!chunk.saving && chunk.saveNeeded()) {
            chunk.saving = true;
            class_2487 chunkData = new class_2487();
            chunk.store(chunkData);
            if (!chunkData.isEmpty()) {
                chunkData.method_10569("version", 2);
                StorageUtil.saveCache(chunk.getPos(), chunkData);
            }
            chunk.saving = false;
        }
    }

    private MapCache(class_1937 world) {
        this.world = world;
        this.chunks = new ConcurrentHashMap<class_1923, MapChunk>();
        this.regions = new ConcurrentHashMap<RegionPos, MapRegion>();
    }

    private void clearCache() {
        this.purgeDelay = ClientParams.purgeDelay * 1000;
        this.purgeAmount = ClientParams.purgeAmount;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPurged > this.purgeDelay) {
            JustMap.WORKER.execute(() -> this.purge(this.purgeAmount));
            this.lastPurged = currentTime;
        }
    }

    private void purge(int maxPurged) {
        long currentTime = System.currentTimeMillis();
        int purged = 0;
        ArrayList<class_1923> chunks = new ArrayList<class_1923>();
        for (class_1923 chunkPos : this.chunks.keySet()) {
            MapChunk chunkData = this.chunks.get(chunkPos);
            if (currentTime - chunkData.requested < 5000L) continue;
            MapCache.storeChunk(chunkData);
            chunks.add(chunkPos);
            if (++purged < maxPurged) continue;
            break;
        }
        for (class_1923 chunkPos : chunks) {
            this.chunks.remove(chunkPos);
        }
    }

    public MapRegion getRegion(class_2338 blockPos) {
        return this.getRegion(blockPos, false);
    }

    public MapRegion getRegion(class_2338 blockPos, boolean surfaceOnly) {
        MapRegion region;
        int level;
        RegionPos regPos = new RegionPos(blockPos);
        Layer.Type layer = surfaceOnly ? Layer.Type.SURFACE : currentLayer;
        int n = level = surfaceOnly ? 0 : currentLevel;
        if (this.regions.containsKey(regPos)) {
            region = this.regions.get(regPos);
        } else {
            region = new MapRegion(blockPos, layer, level);
            this.regions.put(regPos, region);
        }
        region.surfaceOnly = surfaceOnly;
        long time = System.currentTimeMillis();
        if (layer != region.getLayer() || level != region.getLevel()) {
            region.swapLayer(layer, level);
        } else if (time - region.updated > 1000L) {
            region.updateTexture();
        }
        return region;
    }

    private Map<class_1923, MapChunk> getChunks() {
        return this.chunks;
    }

    public MapChunk getCurrentChunk(class_1923 chunkPos) {
        return this.getChunk(currentLayer, currentLevel, chunkPos.field_9181, chunkPos.field_9180);
    }

    public MapChunk getCurrentChunk(int posX, int posZ) {
        return this.getChunk(currentLayer, currentLevel, posX, posZ);
    }

    public MapChunk getChunk(Layer.Type layer, int level, int posX, int posZ) {
        MapChunk mapChunk;
        class_1923 chunkPos = new class_1923(posX, posZ);
        if (this.chunks.containsKey(chunkPos)) {
            mapChunk = this.chunks.get(chunkPos);
        } else {
            mapChunk = new MapChunk(this.world, chunkPos, layer, level);
            this.chunks.put(chunkPos, mapChunk);
        }
        mapChunk.setLevel(layer, level);
        mapChunk.requested = System.currentTimeMillis();
        return mapChunk;
    }

    private void clear() {
        this.regions.forEach((pos, region) -> region.close());
        this.regions.clear();
        this.chunks.clear();
    }

    static {
        currentLayer = Layer.Type.SURFACE;
        currentLevel = 0;
        currentDimension = 0;
        lastSaved = 0L;
    }
}

