/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.data.ChunkLevel;
import ru.bulldog.justmap.map.data.Layer;
import ru.bulldog.justmap.map.data.MapCache;
import ru.bulldog.justmap.map.data.MapProcessor;
import ru.bulldog.justmap.util.ColorUtil;
import ru.bulldog.justmap.util.StorageUtil;
import ru.bulldog.justmap.util.TaskManager;

public class MapChunk {
    public final ChunkLevel EMPTY_LEVEL = new ChunkLevel(-1);
    private static final TaskManager chunkUpdater = TaskManager.getManager("chunk-data");
    private volatile Map<Layer, ChunkLevel[]> levels;
    private static class_310 client = class_310.method_1551();
    private class_1937 world;
    private class_2818 worldChunk;
    private class_1923 chunkPos;
    private Layer.Type layer;
    private int dimension;
    private int level = 0;
    private boolean outdated = false;
    private boolean updating = false;
    private boolean saved = true;
    private boolean purged = false;
    public boolean saving = false;
    public long updated = 0L;
    public long requested = 0L;
    private Object levelLock = new Object();

    public MapChunk(class_1937 world, class_1923 pos, Layer.Type layer, int level) {
        this(world, pos, layer);
        this.level = level > 0 ? level : 0;
    }

    public MapChunk(class_1937 world, class_1923 pos, Layer.Type layer) {
        this.world = world;
        this.worldChunk = MapChunk.client.field_1687.method_8497(pos.field_9181, pos.field_9180);
        this.dimension = world.method_8597().method_12460().method_12484();
        this.chunkPos = pos;
        this.layer = layer;
        this.levels = new ConcurrentHashMap<Layer, ChunkLevel[]>();
        this.init();
    }

    private void init() {
        if (this.dimension == -1) {
            this.initLayer(Layer.Type.NETHER);
        } else {
            this.initLayer(Layer.Type.SURFACE);
            this.initLayer(Layer.Type.CAVES);
        }
        this.restore();
    }

    public MapChunk resetChunk() {
        this.levels.clear();
        this.updated = 0L;
        return this;
    }

    private void initLayer() {
        this.initLayer(this.layer);
    }

    private void initLayer(Layer.Type layer) {
        int levels = this.worldChunk.method_8322() / layer.value.height;
        this.levels.put(layer.value, new ChunkLevel[levels]);
    }

    private ChunkLevel getChunkLevel() {
        return this.getChunkLevel(this.layer, this.level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkLevel getChunkLevel(Layer.Type layer, int level) {
        ChunkLevel chunkLevel;
        if (!this.levels.containsKey(layer.value)) {
            this.initLayer();
        }
        try {
            if (this.levels.get(layer.value)[level] == null) {
                this.levels.get((Object)layer.value)[level] = chunkLevel = new ChunkLevel(level);
            } else {
                chunkLevel = this.levels.get(layer.value)[level];
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            chunkLevel = this.EMPTY_LEVEL;
        }
        Object object = this.levelLock;
        synchronized (object) {
            return chunkLevel;
        }
    }

    public MapChunk setPos(class_1923 chunkPos) {
        this.chunkPos = chunkPos;
        return this;
    }

    public class_1923 getPos() {
        return this.chunkPos;
    }

    public int getX() {
        return this.chunkPos.field_9181;
    }

    public int getZ() {
        return this.chunkPos.field_9180;
    }

    public Layer.Type getLayer() {
        return this.layer;
    }

    public int currentLevel() {
        return this.level;
    }

    public int[] getHeighmap() {
        return this.getChunkLevel().heightmap;
    }

    public MapChunk setLevel(Layer.Type layer, int level) {
        if (this.layer == layer && this.level == level) {
            return this;
        }
        this.level = level;
        this.layer = layer;
        return this;
    }

    public class_2818 getWorldChunk() {
        return this.worldChunk;
    }

    public class_2680 getBlockState(class_2338 pos) {
        return this.getChunkLevel().getBlockState(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF);
    }

    public class_2680 setBlockState(class_2338 pos, class_2680 blockState) {
        return this.getChunkLevel().setBlockState(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, blockState);
    }

    public MapChunk updateHeighmap() {
        if (!this.updateWorldChunk()) {
            return this;
        }
        boolean waterTint = ClientParams.alternateColorRender && ClientParams.waterTint;
        boolean skipWater = !ClientParams.hideWater && !waterTint;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = this.worldChunk.method_12005(class_2902.class_2903.field_13202, x, z);
                y = MapProcessor.getTopBlockY(this, x, y + 1, z, skipWater);
                int index = x + (z << 4);
                ChunkLevel chunkLevel = this.getChunkLevel();
                if (y != -1) {
                    chunkLevel.updateHeightmap(x, z, y);
                    continue;
                }
                if (this.getHeighmap()[index] == -1) continue;
                chunkLevel.clear(x, z);
                this.saved = false;
            }
        }
        return this;
    }

    public boolean update(boolean forceUpdate) {
        if (this.updating) {
            return false;
        }
        if (!this.outdated && forceUpdate) {
            this.outdated = forceUpdate;
        }
        long currentTime = System.currentTimeMillis();
        if (!this.outdated && currentTime - this.updated < (long)ClientParams.chunkUpdateInterval) {
            return false;
        }
        if (this.purged || !this.updateWorldChunk()) {
            return false;
        }
        CompletableFuture updated = chunkUpdater.run(future -> () -> future.complete(this.updateChunkData()));
        return (Boolean)updated.join();
    }

    private boolean updateWorldChunk() {
        if (this.worldChunk.method_12223()) {
            class_2818 lifeChunk = this.world.method_8398().method_12126(this.getX(), this.getZ(), false);
            if (lifeChunk == null || lifeChunk.method_12223()) {
                return false;
            }
            this.worldChunk = lifeChunk;
        }
        return true;
    }

    private boolean updateChunkData() {
        this.updating = true;
        MapCache mapData = MapCache.get();
        MapChunk eastChunk = mapData.getCurrentChunk(this.chunkPos.field_9181 + 1, this.chunkPos.field_9180);
        MapChunk southChunk = mapData.getCurrentChunk(this.chunkPos.field_9181, this.chunkPos.field_9180 - 1);
        long currentTime = System.currentTimeMillis();
        ChunkLevel chunkLevel = this.getChunkLevel();
        if (currentTime - chunkLevel.updated > (long)ClientParams.chunkLevelUpdateInterval) {
            this.updateHeighmap();
            eastChunk.updateHeighmap();
            southChunk.updateHeighmap();
            chunkLevel.updated = currentTime;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int heightDiff;
                int color;
                int index = x + (z << 4);
                int posX = x + (this.chunkPos.field_9181 << 4);
                int posZ = z + (this.chunkPos.field_9180 << 4);
                int posY = this.getHeighmap()[index];
                if (posY == -1) continue;
                class_2338 blockPos = new class_2338(posX, posY, posZ);
                class_2680 blockState = this.getBlockState(blockPos);
                class_2680 worldState = this.worldChunk.method_8320(blockPos);
                if (this.outdated || !blockState.equals(worldState)) {
                    color = ColorUtil.blockColor(this.worldChunk, blockPos);
                    if (color == -1) continue;
                    heightDiff = MapProcessor.heightDifference(this, eastChunk, southChunk, x, posY, z);
                    this.setBlockState(blockPos, worldState);
                    chunkLevel.colormap[index] = color;
                    chunkLevel.levelmap[index] = heightDiff;
                    chunkLevel.colordata[index] = ColorUtil.proccessColor(color, heightDiff);
                    this.saved = false;
                    continue;
                }
                color = chunkLevel.colormap[index];
                if (color == -1 || chunkLevel.levelmap[index] == (heightDiff = MapProcessor.heightDifference(this, eastChunk, southChunk, x, posY, z))) continue;
                chunkLevel.levelmap[index] = heightDiff;
                chunkLevel.colordata[index] = ColorUtil.proccessColor(color, heightDiff);
                this.saved = false;
            }
        }
        this.outdated = false;
        this.updated = currentTime;
        this.updating = false;
        return this.saveNeeded();
    }

    public int[] getColorData() {
        ChunkLevel chunkLevel = this.getChunkLevel();
        return (int[])chunkLevel.colordata.clone();
    }

    public int getBlockColor(int x, int z) {
        int index = x + (z << 4);
        ChunkLevel chunkLevel = this.getChunkLevel();
        return chunkLevel.colordata[index];
    }

    public boolean saveNeeded() {
        return !this.saved;
    }

    public void store(class_2487 data) {
        this.levels.forEach((layer, levels) -> {
            class_2499 levelsTag = new class_2499();
            for (int i = 0; i < ((ChunkLevel[])levels).length; ++i) {
                int lvl = i;
                ChunkLevel chunkLevel = Arrays.stream(levels).filter(levelx -> levelx != null && levelx.level == lvl).findFirst().orElse(this.EMPTY_LEVEL);
                if (chunkLevel.isEmpty()) continue;
                class_2487 level = new class_2487();
                level.method_10569("Level", lvl);
                chunkLevel.container().method_12330(level, "Palette", "BlockStates");
                chunkLevel.store(level);
                levelsTag.add((Object)level);
            }
            if (!levelsTag.isEmpty()) {
                data.method_10566(layer.name, (class_2520)levelsTag);
            }
        });
        this.saved = true;
    }

    private void restore() {
        class_2487 chunkData = StorageUtil.getCache(this.chunkPos);
        if (chunkData.isEmpty()) {
            return;
        }
        int dataVer = chunkData.method_10545("version") ? chunkData.method_10550("version") : -1;
        this.levels.forEach((layer, levels) -> {
            class_2499 listTag = chunkData.method_10554(layer.name, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                ChunkLevel chunkLevel;
                class_2487 level = listTag.method_10602(i);
                int lvl = level.method_10550("Level");
                if (!level.method_10573("Palette", 9) || !level.method_10573("BlockStates", 12) || (chunkLevel = this.getChunkLevel(layer.type, lvl)).isEmpty()) continue;
                chunkLevel.container().method_12329(level.method_10554("Palette", 10), level.method_10565("BlockStates"));
                chunkLevel.load(level);
                if (dataVer != -1) continue;
                for (int j = 0; j < chunkLevel.colormap.length; ++j) {
                    int color = chunkLevel.colormap[j];
                    if (color == -1) continue;
                    chunkLevel.colormap[j] = ColorUtil.ABGRtoARGB(color);
                }
                this.saved = false;
            }
        });
    }
}

