/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.data.Layer;
import ru.bulldog.justmap.map.data.MapChunk;
import ru.bulldog.justmap.util.StateUtil;

public class MapProcessor {
    public static int getTopBlockY(MapChunk mapChunk, int x, int y, int z, boolean liquids) {
        class_2818 worldChunk = mapChunk.getWorldChunk();
        class_1923 chunkPos = worldChunk.method_12004();
        if (worldChunk.method_12223()) {
            return -1;
        }
        int posX = x + (chunkPos.field_9181 << 4);
        int posZ = z + (chunkPos.field_9180 << 4);
        boolean plants = !ClientParams.hidePlants;
        Layer.Type layer = mapChunk.getLayer();
        if (layer.equals((Object)Layer.Type.NETHER) || layer.equals((Object)Layer.Type.CAVES)) {
            int level = mapChunk.currentLevel();
            int floor = level * layer.value.height;
            for (int i = floor + (layer.value.height - 1); i >= floor; --i) {
                class_2338 worldPos = MapProcessor.loopPos(worldChunk, new class_2338(posX, i, posZ), 0, liquids, plants);
                class_2338 overPos = new class_2338(posX, worldPos.method_10264() + 1, posZ);
                if (!StateUtil.checkState(worldChunk.method_8320(overPos), liquids, plants)) continue;
                return worldPos.method_10264();
            }
        } else {
            class_2338 worldPos = MapProcessor.loopPos(worldChunk, new class_2338(posX, y, posZ), 0, liquids, plants);
            class_2680 overState = worldChunk.method_8320(new class_2338(posX, worldPos.method_10264() + 1, posZ));
            if (StateUtil.checkState(overState, liquids, plants)) {
                return worldPos.method_10264();
            }
        }
        return -1;
    }

    private static class_2338 loopPos(class_2818 worldChunk, class_2338 pos, int stop, boolean liquids, boolean plants) {
        boolean loop = false;
        do {
            loop = StateUtil.checkState(worldChunk.method_8320(pos), liquids, plants);
            if (!(loop &= pos.method_10264() > stop)) continue;
            pos = pos.method_10074();
        } while (loop);
        return pos;
    }

    private static int checkLiquids(MapChunk mapChunk, int x, int y, int z) {
        class_2818 worldChunk = mapChunk.getWorldChunk();
        if (worldChunk.method_12223() || y == -1) {
            return 0;
        }
        class_2338 pos = new class_2338(x + (mapChunk.getX() << 4), y, z + (mapChunk.getZ() << 4));
        class_2680 state = worldChunk.method_8320(pos);
        if (StateUtil.isLiquid(state, false)) {
            y = MapProcessor.getTopBlockY(mapChunk, x, y, z, false);
        }
        return y;
    }

    public static int heightDifference(MapChunk mapChunk, MapChunk eastChunk, MapChunk southChunk, int x, int y, int z) {
        int south;
        int east;
        int ex = x + 1;
        int sz = z - 1;
        if (ex > 15) {
            east = eastChunk.getHeighmap()[(ex -= 16) + (z << 4)];
            east = MapProcessor.checkLiquids(eastChunk, ex, east, z);
        } else {
            east = mapChunk.getHeighmap()[ex + (z << 4)];
            east = MapProcessor.checkLiquids(mapChunk, ex, east, z);
        }
        if (sz < 0) {
            south = southChunk.getHeighmap()[x + ((sz += 16) << 4)];
            south = MapProcessor.checkLiquids(southChunk, x, south, sz);
        } else {
            south = mapChunk.getHeighmap()[x + (sz << 4)];
            south = MapProcessor.checkLiquids(mapChunk, x, south, sz);
        }
        y = MapProcessor.checkLiquids(mapChunk, x, y, z);
        east = east > 0 ? east - y : 0;
        south = south > 0 ? south - y : 0;
        int diff = east - south;
        if (diff == 0) {
            return 0;
        }
        int maxDiff = ClientParams.terrainStrength;
        diff = diff < 0 ? Math.max(-maxDiff, diff) : Math.min(maxDiff, diff);
        return diff;
    }
}

