/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.client.render.MapTexture;
import ru.bulldog.justmap.map.data.Layer;
import ru.bulldog.justmap.map.data.MapCache;
import ru.bulldog.justmap.map.data.MapChunk;
import ru.bulldog.justmap.map.data.RegionPos;
import ru.bulldog.justmap.util.StorageUtil;
import ru.bulldog.justmap.util.TaskManager;

public class MapRegion {
    private static class_289 tessellator = class_289.method_1348();
    private static class_287 builder = tessellator.method_1349();
    private static TaskManager worker = TaskManager.getManager("region-data");
    private final RegionPos pos;
    private final MapTexture image;
    private Layer.Type layer;
    private int level;
    private boolean hideWater = false;
    private boolean waterTint = true;
    private boolean alternateRender = true;
    private boolean needUpdate = false;
    private boolean changed = false;
    private boolean updating = false;
    public boolean surfaceOnly = false;
    public long updated = 0L;

    public MapRegion(class_2338 blockPos, Layer.Type layer, int level) {
        this.pos = new RegionPos(blockPos);
        this.image = new MapTexture(512, 512);
        this.image.fill(-16777216);
        this.layer = layer;
        this.level = level;
        this.loadImage();
        this.updateTexture();
    }

    public int getX() {
        return this.pos.x;
    }

    public int getZ() {
        return this.pos.z;
    }

    public void updateTexture() {
        if (this.updating) {
            return;
        }
        this.updateMapParams();
        worker.execute(this::updateImage);
        this.updating = true;
    }

    private void updateMapParams() {
        boolean waterTint;
        if (ClientParams.hideWater != this.hideWater) {
            this.hideWater = ClientParams.hideWater;
            this.needUpdate = true;
        }
        boolean bl = waterTint = ClientParams.alternateColorRender && ClientParams.waterTint;
        if (this.waterTint != waterTint) {
            this.waterTint = waterTint;
            this.needUpdate = true;
        }
        if (ClientParams.alternateColorRender != this.alternateRender) {
            this.alternateRender = ClientParams.alternateColorRender;
            this.needUpdate = true;
        }
    }

    private void updateImage() {
        MapCache mapData = MapCache.get();
        int regX = this.pos.x << 9;
        int regZ = this.pos.z << 9;
        for (int x = 0; x < 512; x += 16) {
            int chunkX = regX + x >> 4;
            for (int y = 0; y < 512; y += 16) {
                MapChunk mapChunk;
                int chunkZ = regZ + y >> 4;
                boolean updated = false;
                if (this.surfaceOnly) {
                    mapChunk = mapData.getChunk(Layer.Type.SURFACE, 0, chunkX, chunkZ);
                    if (MapCache.currentLayer() == Layer.Type.SURFACE) {
                        updated = mapChunk.update(this.needUpdate);
                    }
                } else {
                    mapChunk = mapData.getCurrentChunk(chunkX, chunkZ);
                    updated = mapChunk.update(this.needUpdate);
                }
                this.image.writeChunkData(x, y, mapChunk.getColorData());
                if (this.changed) continue;
                this.changed = updated;
            }
        }
        if (this.changed) {
            this.saveImage();
        }
        this.updated = System.currentTimeMillis();
        this.needUpdate = false;
        this.updating = false;
    }

    public Layer.Type getLayer() {
        return this.layer != null ? this.layer : null;
    }

    public int getLevel() {
        return this.level;
    }

    public void swapLayer(Layer.Type layer, int level) {
        this.layer = layer;
        this.level = level;
        this.loadImage();
        this.updateTexture();
    }

    private void saveImage() {
        File imgFile = this.imageFile();
        JustMap.WORKER.execute(() -> this.image.saveImage(imgFile));
    }

    private void loadImage() {
        File imgFile = this.imageFile();
        this.image.loadImage(imgFile);
        this.changed = true;
    }

    private File imageFile() {
        File dir = StorageUtil.cacheDir();
        dir = this.surfaceOnly || Layer.Type.SURFACE == this.layer ? new File(dir, "surface/") : new File(dir, String.format("%s/%d/", this.layer.value.name, this.level));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, String.format("r%d.%d.png", this.pos.x, this.pos.z));
    }

    public void draw(double x, double y, int imgX, int imgY, int width, int height, float scale) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.changed) {
            this.image.upload();
            this.changed = false;
        }
        RenderSystem.bindTexture((int)this.image.getId());
        if (ClientParams.textureFilter) {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        }
        float u1 = (float)imgX / 512.0f;
        float v1 = (float)imgY / 512.0f;
        float u2 = (float)(imgX + width) / 512.0f;
        float v2 = (float)(imgY + height) / 512.0f;
        double scW = (double)width / (double)scale;
        double scH = (double)height / (double)scale;
        builder.method_1328(7, class_290.field_1585);
        builder.method_22912(x, y, 0.0).method_22913(u1, v1).method_1344();
        builder.method_22912(x, y + scH, 0.0).method_22913(u1, v2).method_1344();
        builder.method_22912(x + scW, y + scH, 0.0).method_22913(u2, v2).method_1344();
        builder.method_22912(x + scW, y, 0.0).method_22913(u2, v1).method_1344();
        tessellator.method_1350();
    }

    public void close() {
        this.image.close();
    }
}

