/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2861;

public class RegionStorage
implements AutoCloseable {
    private final Long2ObjectLinkedOpenHashMap<class_2861> cachedRegionFiles = new Long2ObjectLinkedOpenHashMap();
    private final File directory;

    public RegionStorage(File file) {
        this.directory = file;
    }

    private class_2861 getRegionFile(class_1923 chunkPos) throws IOException {
        long longPos = class_1923.method_8331((int)chunkPos.method_17885(), (int)chunkPos.method_17886());
        class_2861 regionFile = (class_2861)this.cachedRegionFiles.getAndMoveToFirst(longPos);
        if (regionFile != null) {
            return regionFile;
        }
        if (this.cachedRegionFiles.size() >= 256) {
            ((class_2861)this.cachedRegionFiles.removeLast()).close();
        }
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        File file = new File(this.directory, "r." + chunkPos.method_17885() + "." + chunkPos.method_17886() + ".mca");
        regionFile = new class_2861(file, this.directory);
        this.cachedRegionFiles.putAndMoveToFirst(longPos, (Object)regionFile);
        return regionFile;
    }

    public class_2487 getTagAt(class_1923 chunkPos) throws IOException {
        class_2487 chunkTag;
        class_2861 regionFile = this.getRegionFile(chunkPos);
        try (DataInputStream dataInputStream = regionFile.method_21873(chunkPos);){
            if (dataInputStream == null) {
                class_2487 class_24872 = null;
                return class_24872;
            }
            chunkTag = class_2507.method_10627((DataInputStream)dataInputStream);
        }
        return chunkTag;
    }

    protected void write(class_1923 chunkPos, class_2487 compoundTag) throws IOException {
        class_2861 regionFile = this.getRegionFile(chunkPos);
        try (DataOutputStream dataOutputStream = regionFile.method_21881(chunkPos);){
            class_2507.method_10628((class_2487)compoundTag, (DataOutput)dataOutputStream);
        }
    }

    @Override
    public void close() throws Exception {
        for (class_2861 regionFile : this.cachedRegionFiles.values()) {
            regionFile.close();
        }
        this.cachedRegionFiles.clear();
    }
}

