/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.data;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.map.data.RegionStorage;
import ru.bulldog.justmap.util.TaskManager;

public class StorageWorker
implements AutoCloseable {
    private final Map<File, RegionStorage> storages;
    private final Map<class_1923, Result> results = Maps.newLinkedHashMap();
    private final TaskManager worker = TaskManager.getManager("chunk-io");
    private final AtomicBoolean closed = new AtomicBoolean();
    private CompletableFuture<Void> future = new CompletableFuture();

    StorageWorker() {
        this.storages = new HashMap<File, RegionStorage>();
    }

    private RegionStorage getStorage(File dir) {
        if (this.storages.containsKey(dir)) {
            return this.storages.get(dir);
        }
        RegionStorage storage = new RegionStorage(dir);
        this.storages.put(dir, storage);
        return storage;
    }

    public void setResult(File dir, class_1923 chunkPos, class_2487 compoundTag) {
        this.worker.run(completableFuture -> () -> {
            Result result = this.results.computeIfAbsent(chunkPos, chunkPosx -> new Result());
            result.dir = dir;
            result.nbt = compoundTag;
            result.future.whenComplete((var1, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                } else {
                    completableFuture.complete(null);
                }
            });
        });
        this.worker.execute(this::writeResult);
    }

    public class_2487 getNbt(File dir, class_1923 chunkPos) throws IOException {
        CompletableFuture completableFuture = this.worker.run(completableFuturex -> () -> {
            Result result = this.results.get(chunkPos);
            if (result != null) {
                completableFuturex.complete(result.nbt);
            } else {
                try {
                    class_2487 compoundTag = this.getStorage(dir).getTagAt(chunkPos);
                    completableFuturex.complete(compoundTag);
                }
                catch (Exception ex) {
                    JustMap.LOGGER.logWarning("Failed to read chunk {}", chunkPos, ex);
                    completableFuturex.completeExceptionally(ex);
                }
            }
        });
        try {
            return (class_2487)completableFuture.join();
        }
        catch (CompletionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw ex;
        }
    }

    private CompletableFuture<Void> shutdown() {
        return this.worker.run(completableFuture -> () -> {
            this.writeAll();
            this.finish();
            this.future = completableFuture;
            this.worker.stop();
        });
    }

    public CompletableFuture<Void> completeAll() {
        return this.worker.run(completableFuture -> () -> {
            CompletableFuture<Void> completableFuture2 = CompletableFuture.allOf((CompletableFuture[])this.results.values().stream().map(result -> ((Result)result).future).toArray(CompletableFuture[]::new));
            completableFuture2.whenComplete((object, throwable) -> completableFuture.complete(null));
        });
    }

    private boolean writeResult() {
        Iterator<Map.Entry<class_1923, Result>> iterator = this.results.entrySet().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Map.Entry<class_1923, Result> entry = iterator.next();
        this.write(entry.getKey(), entry.getValue());
        iterator.remove();
        return true;
    }

    private void writeAll() {
        this.results.forEach(this::write);
        this.results.clear();
    }

    private void write(class_1923 chunkPos, Result result) {
        try {
            this.getStorage(result.dir).write(chunkPos, result.nbt);
            result.future.complete(null);
        }
        catch (Exception ex) {
            JustMap.LOGGER.logError("Failed to store chunk {}", chunkPos, ex);
            result.future.completeExceptionally(ex);
        }
    }

    private void finish() {
        Exception error = new Exception();
        this.storages.forEach((dir, storage) -> {
            try {
                storage.close();
            }
            catch (Exception ex) {
                JustMap.LOGGER.logError("Failed to close storage", ex);
                error.addSuppressed(ex);
            }
        });
        if (error.getSuppressed().length > 0) {
            this.future.completeExceptionally(error);
        } else {
            this.future.complete(null);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.shutdown().join();
            }
            catch (CompletionException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw ex;
            }
        }
    }

    private static class Result {
        private File dir;
        private class_2487 nbt;
        private final CompletableFuture<Void> future = new CompletableFuture();

        private Result() {
        }
    }
}

