/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.icon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.icon.AbstractIcon;
import ru.bulldog.justmap.map.icon.MapIcon;
import ru.bulldog.justmap.util.ColorUtil;
import ru.bulldog.justmap.util.DrawHelper;
import ru.bulldog.justmap.util.ImageUtil;
import ru.bulldog.justmap.util.SpriteAtlas;

public class EntityHeadIcon
extends AbstractIcon {
    private static final Map<class_2960, EntityHeadIcon> ICONS = new HashMap<class_2960, EntityHeadIcon>();
    private final class_2960 id;
    private class_2960 outlineId;
    private int color = -4473925;
    private boolean solid = this.isSolid();

    public static EntityHeadIcon getIcon(class_1297 entity) {
        class_2960 id = class_1299.method_5890((class_1299)entity.method_5864());
        if (ICONS.containsKey(id)) {
            return ICONS.get(id);
        }
        class_2960 iconId = EntityHeadIcon.iconId(id);
        if (ImageUtil.imageExists(iconId)) {
            return EntityHeadIcon.registerIcon(entity, id, iconId);
        }
        return null;
    }

    private EntityHeadIcon(class_2960 id, class_2960 texture, int w, int h) {
        super(SpriteAtlas.ENTITY_HEAD_ICONS, new class_1058.class_4727(texture, w, h, class_1079.field_21768), 0, w, h, 0, 0, ImageUtil.loadImage(texture, w, h));
        this.id = id;
    }

    @Override
    public void draw(double x, double y, int w, int h) {
        class_4587 matrix = new class_4587();
        this.draw(matrix, x, y, (float)w, (float)h);
    }

    @Override
    public void draw(class_4587 matrix, double x, double y, int w, int h) {
        if (ClientParams.showIconsOutline) {
            if (this.solid) {
                DrawHelper.fill(matrix, x - 0.5, y - 0.5, x + (double)w + 0.5, y + (double)h + 0.5, this.color);
            } else {
                this.bindOutline();
                DrawHelper.draw(x - 0.5, y - 0.5, w + 1, h + 1);
            }
        }
        textureManager.method_22813(this.method_4598());
        this.draw(matrix, x, y, (float)w, (float)h);
    }

    private void bindOutline() {
        if (this.outlineId == null) {
            class_1043 outTexture = new class_1043(this.generateOutline());
            this.outlineId = textureManager.method_4617(String.format("%s_%s_outline", this.id.method_12836(), this.id.method_12832()), outTexture);
        }
        textureManager.method_22813(this.outlineId);
    }

    private boolean isSolid() {
        class_1011 icon = this.field_5262[0];
        int width = icon.method_4307();
        int height = icon.method_4323();
        boolean solid = true;
        block0: for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int alpha = icon.method_4315(i, j) >> 24 & 0xFF;
                boolean bl = solid = alpha > 0;
                if (!solid) continue block0;
            }
        }
        return solid;
    }

    private class_1011 generateOutline() {
        class_1011 icon = this.field_5262[0];
        int width = icon.method_4307();
        int height = icon.method_4323();
        class_1011 outline = new class_1011(width + 4, height + 4, false);
        ImageUtil.fillImage(outline, 0);
        int outWidth = outline.method_4307();
        int outHeight = outline.method_4323();
        int outlineColor = ColorUtil.toABGR(this.color);
        ArrayList<MapIcon.IconPos> outlinePixels = new ArrayList<MapIcon.IconPos>();
        for (int x = 0; x < width; ++x) {
            int left = x - 1;
            int right = x + 1;
            for (int y = 0; y < height; ++y) {
                MapIcon.IconPos pixel2;
                int alpha = icon.method_4315(x, y) >> 24 & 0xFF;
                if (alpha == 0) continue;
                outlinePixels.add(new MapIcon.IconPos(x + 2, y + 2));
                int top = y - 1;
                int bottom = y + 1;
                if (top >= 0) {
                    alpha = icon.method_4315(x, top) >> 24 & 0xFF;
                    if (alpha == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x + 2, y))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(x + 2, y + 1));
                    }
                    if (left >= 0 && (alpha = icon.method_4315(left, top) >> 24 & 0xFF) == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x, y))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(x, y + 1));
                        outlinePixels.add(new MapIcon.IconPos(x + 1, y));
                        outlinePixels.add(new MapIcon.IconPos(x + 1, y + 1));
                    }
                    if (right < width && (alpha = icon.method_4315(right, top) >> 24 & 0xFF) == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(right + 2, y))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(right + 2, y + 1));
                        outlinePixels.add(new MapIcon.IconPos(right + 3, y));
                        outlinePixels.add(new MapIcon.IconPos(right + 3, y + 1));
                    }
                } else if (y == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x + 2, 0.0))) {
                    outlinePixels.add(pixel2);
                    outlinePixels.add(new MapIcon.IconPos(x + 2, 1.0));
                }
                if (bottom < height) {
                    alpha = icon.method_4315(x, bottom) >> 24 & 0xFF;
                    if (alpha == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x + 2, bottom + 1))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(x + 2, bottom + 2));
                    }
                    if (left >= 0 && (alpha = icon.method_4315(left, bottom) >> 24 & 0xFF) == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x, bottom + 2))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(x, bottom + 3));
                        outlinePixels.add(new MapIcon.IconPos(x + 1, bottom + 2));
                        outlinePixels.add(new MapIcon.IconPos(x + 1, bottom + 3));
                    }
                    if (right < width && (alpha = icon.method_4315(right, bottom) >> 24 & 0xFF) == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(right + 2, bottom + 2))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(right + 2, bottom + 3));
                        outlinePixels.add(new MapIcon.IconPos(right + 3, bottom + 2));
                        outlinePixels.add(new MapIcon.IconPos(right + 3, bottom + 3));
                    }
                } else if (y == height - 1 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x + 2, outHeight - 1))) {
                    outlinePixels.add(pixel2);
                    outlinePixels.add(new MapIcon.IconPos(x + 2, outHeight - 2));
                }
                if (left >= 0) {
                    alpha = icon.method_4315(left, y) >> 24 & 0xFF;
                    if (alpha == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(x, y + 2))) {
                        outlinePixels.add(pixel2);
                        outlinePixels.add(new MapIcon.IconPos(x + 1, y + 2));
                    }
                } else if (x == 0 && !outlinePixels.contains(pixel2 = new MapIcon.IconPos(0.0, y + 2))) {
                    outlinePixels.add(pixel2);
                    outlinePixels.add(new MapIcon.IconPos(1.0, y + 2));
                }
                if (right < width) {
                    alpha = icon.method_4315(right, y) >> 24 & 0xFF;
                    if (alpha != 0 || outlinePixels.contains(pixel2 = new MapIcon.IconPos(right + 1, y + 2))) continue;
                    outlinePixels.add(pixel2);
                    outlinePixels.add(new MapIcon.IconPos(right + 2, y + 2));
                    continue;
                }
                if (x != width - 1 || outlinePixels.contains(pixel2 = new MapIcon.IconPos(outWidth - 1, y + 2))) continue;
                outlinePixels.add(pixel2);
                outlinePixels.add(new MapIcon.IconPos(outWidth - 2, y + 2));
            }
        }
        outlinePixels.forEach(pixel -> outline.method_4305((int)pixel.x, (int)pixel.y, outlineColor));
        return outline;
    }

    private static class_2960 iconId(class_2960 id) {
        String path = String.format("textures/minimap/entities/%s.png", id.method_12832());
        return new class_2960(id.method_12836(), path);
    }

    private static EntityHeadIcon registerIcon(class_1297 entity, class_2960 entityId, class_2960 texture) {
        class_1321 tameable;
        EntityHeadIcon icon = new EntityHeadIcon(entityId, texture, 32, 32);
        icon.color = entity instanceof class_1588 ? -5636096 : (entity instanceof class_1321 ? ((tameable = (class_1321)entity).method_6181() ? -16711936 : -256) : -256);
        ICONS.put(entityId, icon);
        return icon;
    }
}

