/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.icon;

import net.minecraft.class_310;
import ru.bulldog.justmap.map.IMap;
import ru.bulldog.justmap.util.math.MathUtil;

public abstract class MapIcon<T extends MapIcon<T>> {
    protected IMap map;
    public double x;
    public double y;
    protected static final class_310 client = class_310.method_1551();

    public MapIcon(IMap map) {
        this.map = map;
    }

    public T setPosition(double x, double y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    protected void rotatePos(IconPos pos, int mapW, int mapH, int mapX, int mapY, float rotation) {
        double centerX = (double)mapX + (double)mapW / 2.0;
        double centerY = (double)mapY + (double)mapH / 2.0;
        rotation = MathUtil.correctAngle(rotation) + 180.0f;
        double angle = Math.toRadians(-rotation);
        double posX = centerX + (pos.x - centerX) * Math.cos(angle) - (pos.y - centerY) * Math.sin(angle);
        double posY = centerY + (pos.y - centerY) * Math.cos(angle) + (pos.x - centerX) * Math.sin(angle);
        pos.x = posX;
        pos.y = posY;
    }

    public abstract void draw(int var1, int var2, double var3, double var5, float var7);

    protected static class IconPos {
        protected double x;
        protected double y;

        protected IconPos(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IconPos)) {
                return false;
            }
            IconPos pos = (IconPos)obj;
            return this.x == pos.y && this.y == pos.y;
        }
    }
}

