/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.icon;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1046;
import net.minecraft.class_1049;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.util.DrawHelper;

public class PlayerHeadIcon {
    private static Map<UUID, PlayerHeadIcon> playerIcons = new HashMap<UUID, PlayerHeadIcon>();
    private long lastCheck;
    private int delay = 5000;
    private boolean success = false;
    private class_1049 playerSkin;
    private class_746 player;

    private PlayerHeadIcon(class_746 player) {
        this.player = player;
    }

    public static PlayerHeadIcon getIcon(class_746 player) {
        PlayerHeadIcon icon;
        long now = System.currentTimeMillis();
        if (playerIcons.containsKey(player.method_5667())) {
            icon = playerIcons.get(player.method_5667());
            if (!icon.success) {
                if (now - icon.lastCheck - (long)icon.delay >= 0L) {
                    PlayerHeadIcon.updatePlayerSkin(icon);
                }
            } else if (now - icon.lastCheck >= 300000L) {
                PlayerHeadIcon.updatePlayerSkin(icon);
            }
        } else {
            icon = new PlayerHeadIcon(player);
            PlayerHeadIcon.registerIcon(icon);
        }
        return icon;
    }

    public void draw(class_4587 matrix, double x, double y) {
        int size = ClientParams.entityIconSize;
        this.draw(matrix, x, y, size, ClientParams.showIconsOutline);
    }

    public void draw(double x, double y, int size, boolean outline) {
        class_4587 matrix = new class_4587();
        this.draw(matrix, x, y, size, outline);
    }

    public void draw(class_4587 matrix, double x, double y, int size, boolean outline) {
        double drawX = x - (double)(size / 2);
        double drawY = y - (double)(size / 2);
        y -= (double)(size / 2);
        if (outline) {
            DrawHelper.fill(drawX - 0.5, drawY - 0.5, drawX + (double)size + 0.5, drawY + (double)size + 0.5, -4473925);
        }
        this.playerSkin.method_23207();
        DrawHelper.drawPlayerHead(matrix, drawX, drawY, size, size);
    }

    private static void updatePlayerSkin(PlayerHeadIcon icon) {
        JustMap.WORKER.execute(() -> PlayerHeadIcon.getPlayerSkin(icon));
    }

    private static void registerIcon(PlayerHeadIcon icon) {
        PlayerHeadIcon.getPlayerSkin(icon);
        playerIcons.put(icon.player.method_5667(), icon);
    }

    private static void getPlayerSkin(PlayerHeadIcon icon) {
        icon.lastCheck = System.currentTimeMillis();
        class_2960 defaultSkin = class_1068.method_4648((UUID)icon.player.method_5667());
        if (!icon.player.method_3117().equals((Object)defaultSkin)) {
            class_1046 skinTexture = class_746.method_3120((class_2960)icon.player.method_3117(), (String)icon.player.method_5477().getString());
            if (skinTexture != icon.playerSkin) {
                if (icon.playerSkin != null) {
                    icon.playerSkin.method_4528();
                }
                icon.playerSkin = skinTexture;
                try {
                    icon.playerSkin.method_4625(class_310.method_1551().method_1478());
                }
                catch (IOException ex) {
                    JustMap.LOGGER.logWarning(ex.getLocalizedMessage());
                }
                icon.success = true;
            }
        } else if (icon.playerSkin == null) {
            icon.playerSkin = new class_1049(defaultSkin);
            icon.success = false;
            try {
                icon.playerSkin.method_4625(class_310.method_1551().method_1478());
            }
            catch (IOException ex) {
                JustMap.LOGGER.logWarning(ex.getLocalizedMessage());
            }
        }
    }
}

