/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.minimap;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4588;
import ru.bulldog.justmap.client.config.ClientParams;

public class ChunkGrid {
    private static final class_289 tessellator = class_289.method_1348();
    private static final class_287 builder = tessellator.method_1349();
    private static final int color = -1439485133;
    private final List<GridLine> lines = new ArrayList<GridLine>();
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;

    public ChunkGrid(int mapX, int mapY, int mapW, int mapH) {
        this.mapX = mapX;
        this.mapY = mapY;
        this.mapW = mapW;
        this.mapH = mapH;
    }

    public void update(int posX, int posZ) {
        GridLine line;
        this.lines.clear();
        float scale = ClientParams.mapScale;
        double xOff = (float)((posX >> 4 << 4) - posX) / scale;
        double yOff = (float)((posZ >> 4 << 4) - posZ) / scale;
        int top = this.mapY - 8;
        int left = this.mapX - 8;
        int right = this.mapX + this.mapW + 8;
        int bottom = this.mapY + this.mapH + 8;
        int step = (int)(16.0f / scale);
        for (double cH = yOff; cH <= (double)this.mapH; cH += (double)step) {
            double yp = (double)this.mapY + cH;
            if (yp < (double)top) continue;
            if (yp > (double)bottom) break;
            line = new GridLine(left, yp, right, yp);
            this.lines.add(line);
        }
        for (double v = xOff; v <= (double)this.mapW; v += (double)step) {
            double xp = (double)this.mapX + v;
            if (xp < (double)left) continue;
            if (xp > (double)right) break;
            line = new GridLine(xp, top, xp, bottom);
            this.lines.add(line);
        }
    }

    public void draw() {
        float a = 0.6666667f;
        float r = 0.2f;
        float g = 0.2f;
        float b = 0.2f;
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        builder.method_1328(1, class_290.field_1592);
        this.lines.forEach(line -> ((GridLine)line).draw((class_4588)ChunkGrid.builder));
        tessellator.method_1350();
        RenderSystem.enableTexture();
    }

    private class GridLine {
        double x1;
        double x2;
        double y1;
        double y2;

        GridLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        private void draw(class_4588 builder) {
            builder.method_22912(this.x1, this.y1, 0.0).method_1344();
            builder.method_22912(this.x2, this.y2, 0.0).method_1344();
        }
    }
}

