/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.minimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.util.DrawHelper;
import ru.bulldog.justmap.util.ImageUtil;

@Environment(value=EnvType.CLIENT)
public class MapSkin
extends class_1058 {
    private static final class_1059 ATLAS = new class_1059(new class_2960("justmap", "textures/atlas/map_skins.png"));
    private static final List<MapSkin> SKINS = new ArrayList<MapSkin>();
    private final RenderData renderData;
    public final int id;
    public final int border;
    public final boolean resizable;
    public final boolean repeating;
    public final String name;
    private static final class_1060 textureManager = class_310.method_1551().method_1531();

    private MapSkin(int id, String name, class_2960 texture, int w, int h, int border, boolean resize, boolean repeat) {
        super(ATLAS, new class_1058.class_4727(texture, w, h, class_1079.field_21768), 0, w, h, 0, 0, ImageUtil.loadImage(texture, w, h));
        this.id = id;
        this.border = border;
        this.resizable = resize;
        this.repeating = repeat;
        this.name = name;
        this.renderData = new RenderData();
    }

    public static void addSkin(String name, class_2960 texture, int w, int h, int border, boolean resizable, boolean repeat) {
        int id = SKINS.size();
        SKINS.add(id, new MapSkin(id, name, texture, w, h, border, resizable, repeat));
    }

    public static void addSkin(String name, class_2960 texture, int w, int h, int border, boolean resizable) {
        MapSkin.addSkin(name, texture, w, h, border, resizable, false);
    }

    public static void addSkin(String name, class_2960 texture, int w, int h, int border) {
        MapSkin.addSkin(name, texture, w, h, border, false, false);
    }

    public static MapSkin getSkin(int id) {
        try {
            return SKINS.get(id);
        }
        catch (IndexOutOfBoundsException ex) {
            JustMap.LOGGER.logWarning(ex.getMessage());
            return SKINS.get(0);
        }
    }

    public class_2960 getTexture() {
        return this.method_4598();
    }

    private void bindPavedTexture(int w, int h) {
        class_2960 id = new class_2960("justmap", String.format("skin_%d_%dx%d", this.id, w, h));
        if (textureManager.method_4619(id) == null) {
            class_1011 pavedImage = new class_1011(w, h, false);
            int imgW = this.field_5262[0].method_4307();
            int imgH = this.field_5262[0].method_4323();
            int x = 0;
            for (int y = 0; y < h; y += imgH) {
                while (x < w) {
                    ImageUtil.writeTile(pavedImage, this.field_5262[0], x, y);
                    x += imgW;
                }
                x = 0;
            }
            textureManager.method_4616(id, (class_1044)new class_1043(pavedImage));
        }
        textureManager.method_22813(id);
    }

    public void draw(int x, int y, int w, int h) {
        if (this.resizable) {
            textureManager.method_22813(this.getTexture());
            if (w > this.method_4578() || h > this.method_4595()) {
                DrawHelper.drawSkin(new class_4587(), this, x, y, w, h);
            } else {
                DrawHelper.blit((int)x, (int)y, (int)0, (int)w, (int)h, (class_1058)this);
            }
        } else {
            this.bindPavedTexture(w, h);
            DrawHelper.blit((int)x, (int)y, (int)0, (int)w, (int)h, (class_1058)this);
        }
    }

    public void draw(int x, int y, int size) {
        this.draw(x, y, size, size);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static MapSkin getSkinByName(String name) {
        for (MapSkin skin : SKINS) {
            if (!skin.name.equals(name)) continue;
            return skin;
        }
        return null;
    }

    public static List<MapSkin> getSkins() {
        return Collections.unmodifiableList(SKINS);
    }

    public static MapSkin getCurrentSkin() {
        return MapSkin.getSkin(ClientParams.currentSkin);
    }

    public RenderData getRenderData() {
        return this.renderData;
    }

    static {
        MapSkin.addSkin("Minecraft Map", new class_2960("textures/map/map_background.png"), 64, 64, 3, true);
        MapSkin.addSkin("Minecraft Gui", new class_2960("justmap", "textures/skin/mad_def_gui_2.png"), 64, 64, 5, true);
        MapSkin.addSkin("Minecraft Gui Fancy", new class_2960("justmap", "textures/skin/mad_def_gui.png"), 64, 64, 7, true);
        MapSkin.addSkin("Metal Frame", new class_2960("justmap", "textures/skin/frame_simple_metal.png"), 64, 64, 4, true);
        MapSkin.addSkin("Oak Frame", new class_2960("justmap", "textures/skin/map_frame_oak.png"), 64, 64, 10, true, true);
        MapSkin.addSkin("Bamboo Frame", new class_2960("justmap", "textures/skin/map_frame_bamboo.png"), 64, 64, 9, true, true);
        MapSkin.addSkin("Stone", new class_2960("textures/block/stone.png"), 16, 16, 4);
        MapSkin.addSkin("Cobblestone", new class_2960("textures/block/cobblestone.png"), 16, 16, 4);
        MapSkin.addSkin("Mossy Cobblestone", new class_2960("textures/block/mossy_cobblestone.png"), 16, 16, 4);
        MapSkin.addSkin("Andesite", new class_2960("textures/block/andesite.png"), 16, 16, 4);
        MapSkin.addSkin("Diorite", new class_2960("textures/block/diorite.png"), 16, 16, 4);
        MapSkin.addSkin("Granite", new class_2960("textures/block/granite.png"), 16, 16, 4);
        MapSkin.addSkin("Bedrock", new class_2960("textures/block/bedrock.png"), 16, 16, 4);
        MapSkin.addSkin("Bricks", new class_2960("textures/block/bricks.png"), 16, 16, 4);
        MapSkin.addSkin("Dark Prizmarine", new class_2960("textures/block/dark_prismarine.png"), 16, 16, 4);
        MapSkin.addSkin("End Stone", new class_2960("textures/block/end_stone.png"), 16, 16, 4);
        MapSkin.addSkin("Glowstone", new class_2960("textures/block/glowstone.png"), 16, 16, 4);
        MapSkin.addSkin("Netherrack", new class_2960("textures/block/netherrack.png"), 16, 16, 4);
        MapSkin.addSkin("Obsidian", new class_2960("textures/block/obsidian.png"), 16, 16, 4);
        MapSkin.addSkin("Purpur", new class_2960("textures/block/purpur_block.png"), 16, 16, 4);
        MapSkin.addSkin("Quartz", new class_2960("textures/block/quartz_block_side.png"), 16, 16, 4);
        MapSkin.addSkin("Sand", new class_2960("textures/block/sand.png"), 16, 16, 4);
        MapSkin.addSkin("Mushroom Inside", new class_2960("textures/block/mushroom_block_inside.png"), 16, 16, 4);
        MapSkin.addSkin("Brown Mushroom", new class_2960("textures/block/brown_mushroom_block.png"), 16, 16, 4);
        MapSkin.addSkin("Acacia Planks", new class_2960("textures/block/acacia_planks.png"), 16, 16, 4);
        MapSkin.addSkin("Birch Planks", new class_2960("textures/block/birch_planks.png"), 16, 16, 4);
        MapSkin.addSkin("Oak Planks", new class_2960("textures/block/oak_planks.png"), 16, 16, 4);
        MapSkin.addSkin("Dark Oak Planks", new class_2960("textures/block/dark_oak_planks.png"), 16, 16, 4);
        MapSkin.addSkin("Jungle Planks", new class_2960("textures/block/jungle_planks.png"), 16, 16, 4);
        MapSkin.addSkin("Spruce Planks", new class_2960("textures/block/spruce_planks.png"), 16, 16, 4);
        MapSkin.addSkin("Nether Bricks", new class_2960("textures/block/nether_bricks.png"), 16, 16, 4);
        MapSkin.addSkin("Lava", new class_2960("textures/block/lava_still.png"), 16, 128, 4);
        MapSkin.addSkin("Water", new class_2960("textures/block/water_still.png"), 16, 128, 4);
        MapSkin.addSkin("Nether Portal", new class_2960("textures/block/nether_portal.png"), 16, 128, 4);
        MapSkin.addSkin("Blue Ice", new class_2960("textures/block/blue_ice.png"), 16, 16, 4);
        MapSkin.addSkin("Bone Block", new class_2960("textures/block/bone_block_side.png"), 16, 16, 4);
        MapSkin.addSkin("Brain Coral", new class_2960("textures/block/brain_coral_block.png"), 16, 16, 4);
        MapSkin.addSkin("Bubble Coral", new class_2960("textures/block/bubble_coral_block.png"), 16, 16, 4);
        MapSkin.addSkin("Fire Coral", new class_2960("textures/block/fire_coral_block.png"), 16, 16, 4);
        MapSkin.addSkin("Horn Coral", new class_2960("textures/block/horn_coral_block.png"), 16, 16, 4);
        MapSkin.addSkin("Tube Coral", new class_2960("textures/block/tube_coral_block.png"), 16, 16, 4);
        MapSkin.addSkin("Blue Wool", new class_2960("textures/block/blue_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Brown Wool", new class_2960("textures/block/brown_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Cyan Wool", new class_2960("textures/block/cyan_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Green Wool", new class_2960("textures/block/green_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Light Blue Wool", new class_2960("textures/block/light_blue_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Lime Wool", new class_2960("textures/block/lime_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Magenta Wool", new class_2960("textures/block/magenta_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Orange Wool", new class_2960("textures/block/orange_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Pink Wool", new class_2960("textures/block/pink_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Purple Wool", new class_2960("textures/block/purple_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Red Wool", new class_2960("textures/block/red_wool.png"), 16, 16, 4);
        MapSkin.addSkin("White Wool", new class_2960("textures/block/white_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Yellow Wool", new class_2960("textures/block/yellow_wool.png"), 16, 16, 4);
        MapSkin.addSkin("Magma", new class_2960("textures/block/magma.png"), 16, 48, 4);
        MapSkin.addSkin("Mycelium", new class_2960("textures/block/mycelium_top.png"), 16, 16, 4);
        MapSkin.addSkin("Podzol", new class_2960("textures/block/podzol_top.png"), 16, 16, 4);
        MapSkin.addSkin("Nether Wart", new class_2960("textures/block/nether_wart_block.png"), 16, 16, 4);
        MapSkin.addSkin("Sponge", new class_2960("textures/block/sponge.png"), 16, 16, 4);
    }

    public final class RenderData {
        public double x;
        public double y;
        public double scaleFactor = 1.0;
        public double leftC;
        public double rightC;
        public double topC;
        public double bottomC;
        public float width;
        public float height;
        public float scaledBorder;
        public float hSide;
        public float vSide;
        public float leftU;
        public float rightU;
        public float topV;
        public float bottomV;
        public float tail;
        public float tailU;
        public boolean scaleChanged = false;

        private RenderData() {
        }

        public void updateScale() {
            double scale = class_310.method_1551().method_22683().method_4495();
            if (this.scaleFactor != (scale = Math.min(2.0, scale))) {
                this.scaleFactor = scale;
                this.scaleChanged = true;
            }
        }

        public void calculate(double x, double y, float w, float h) {
            int spriteW = MapSkin.this.method_4578();
            int spriteH = MapSkin.this.method_4595();
            int border = MapSkin.this.border;
            float sw = spriteW * 10 / 16 - border * 2;
            float sTail = (float)(spriteW - border * 2) - sw;
            double right = x + (double)w;
            double bottom = y + (double)h;
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.scaledBorder = (float)((double)border * this.scaleFactor);
            this.hSide = w - this.scaledBorder * 2.0f;
            this.vSide = h - this.scaledBorder * 2.0f;
            this.leftC = x + (double)this.scaledBorder;
            this.rightC = right - (double)this.scaledBorder;
            this.topC = y + (double)this.scaledBorder;
            this.bottomC = bottom - (double)this.scaledBorder;
            this.leftU = (float)border / (float)spriteW;
            this.rightU = (float)(spriteW - border) / (float)spriteW;
            this.topV = (float)border / (float)spriteH;
            this.bottomV = (float)(spriteH - border) / (float)spriteH;
            this.tail = this.hSide - this.vSide;
            this.tailU = ((float)border + sTail) / (float)spriteW;
        }
    }
}

