/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.minimap;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_746;
import ru.bulldog.justmap.client.JustMapClient;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.map.IMap;
import ru.bulldog.justmap.map.data.Layer;
import ru.bulldog.justmap.map.data.MapCache;
import ru.bulldog.justmap.map.icon.EntityIcon;
import ru.bulldog.justmap.map.icon.PlayerIcon;
import ru.bulldog.justmap.map.icon.WaypointIcon;
import ru.bulldog.justmap.map.minimap.MapGameRules;
import ru.bulldog.justmap.map.minimap.MapText;
import ru.bulldog.justmap.map.minimap.TextManager;
import ru.bulldog.justmap.map.waypoint.Waypoint;
import ru.bulldog.justmap.map.waypoint.WaypointEditor;
import ru.bulldog.justmap.map.waypoint.WaypointKeeper;
import ru.bulldog.justmap.util.DrawHelper;
import ru.bulldog.justmap.util.PosUtil;
import ru.bulldog.justmap.util.math.MathUtil;
import ru.bulldog.justmap.util.math.RandomUtil;

public class Minimap
implements IMap {
    private static final class_310 minecraftClient = class_310.method_1551();
    private final TextManager textManager;
    private MapText txtCoords = new MapText(DrawHelper.TextAlignment.CENTER, "0, 0, 0");
    private MapText txtBiome = new MapText(DrawHelper.TextAlignment.CENTER, "Void");
    private MapText txtTime = new MapText(DrawHelper.TextAlignment.CENTER, "00:00");
    private MapText txtFPS = new MapText(DrawHelper.TextAlignment.CENTER, "00 fps");
    private int mapWidth;
    private int mapHeight;
    private int scaledWidth;
    private int scaledHeight;
    private float mapScale;
    private int lastPosX = 0;
    private int lastPosZ = 0;
    private class_1959 currentBiome;
    private List<WaypointIcon> waypoints = new ArrayList<WaypointIcon>();
    private List<PlayerIcon> players = new ArrayList<PlayerIcon>();
    private List<EntityIcon> entities = new ArrayList<EntityIcon>();
    private class_1657 locPlayer = null;
    private boolean isMapVisible = true;
    private boolean rotateMap = false;
    private boolean bigMap = false;
    public boolean posChanged = false;

    public Minimap() {
        this.textManager = new TextManager(this);
        this.updateMapParams();
    }

    public void update() {
        if (!this.isMapVisible()) {
            return;
        }
        class_746 player = Minimap.minecraftClient.field_1724;
        if (player != null) {
            if (this.locPlayer == null) {
                this.locPlayer = player;
            }
            this.prepareMap((class_1657)player);
            this.updateInfo((class_1657)player);
        } else {
            this.locPlayer = null;
        }
    }

    public void updateMapParams() {
        int configSize = JustMapClient.CONFIG.getInt("map_size");
        float configScale = JustMapClient.CONFIG.getFloat("map_scale");
        boolean needRotate = JustMapClient.CONFIG.getBoolean("rotate_map");
        boolean bigMap = JustMapClient.CONFIG.getBoolean("show_big_map");
        if (configSize != this.mapWidth || configScale != this.mapScale || this.rotateMap != needRotate || this.bigMap != bigMap) {
            if (bigMap) {
                this.mapWidth = JustMapClient.CONFIG.getInt("big_map_size");
                this.mapHeight = this.mapWidth * 10 / 16;
            } else {
                this.mapWidth = configSize;
                this.mapHeight = configSize;
            }
            this.mapScale = configScale;
            this.rotateMap = needRotate;
            this.bigMap = bigMap;
            if (this.rotateMap) {
                this.scaledWidth = (int)((double)((float)this.mapWidth * this.mapScale) * 1.42 + 8.0);
                this.scaledHeight = (int)((double)((float)this.mapHeight * this.mapScale) * 1.42 + 8.0);
            } else {
                this.scaledWidth = (int)((float)this.mapWidth * this.mapScale + 8.0f);
                this.scaledHeight = (int)((float)this.mapHeight * this.mapScale + 8.0f);
            }
        }
        this.isMapVisible = JustMapClient.CONFIG.getBoolean("map_visible");
    }

    private void updateInfo(class_1657 player) {
        this.textManager.clear();
        if (ClientParams.showPosition) {
            class_1297 camera = Minimap.minecraftClient.field_1719;
            this.txtCoords.setText(PosUtil.posToString(camera.method_23317(), camera.method_23318(), camera.method_23321()));
            this.textManager.add(this.txtCoords);
        }
        if (ClientParams.showBiome) {
            this.txtBiome.setText(class_1074.method_4662((String)this.currentBiome.method_8689(), (Object[])new Object[0]));
            this.textManager.add(this.txtBiome);
        }
        if (ClientParams.showFPS) {
            this.txtFPS.setText(Minimap.minecraftClient.field_1770.substring(0, Minimap.minecraftClient.field_1770.indexOf("fps") + 3));
            this.textManager.add(this.txtFPS);
        }
        if (ClientParams.showTime) {
            this.txtTime.setText(this.timeString(Minimap.minecraftClient.field_1687.method_8532()));
            this.textManager.add(this.txtTime);
        }
    }

    private String timeString(long time) {
        time = time > 24000L ? time % 24000L : time;
        int h = (int)time / 1000 + 6;
        int m = (int)((float)(time % 1000L) / 1000.0f * 60.0f);
        h = h >= 24 ? h - 24 : h;
        return String.format("%02d:%02d", h, m);
    }

    private static boolean isAllowed(boolean param, class_1928.class_4313<class_1928.class_4310> rule) {
        if (param) {
            return minecraftClient.method_1542() || MapGameRules.isAllowed(rule);
        }
        return false;
    }

    private boolean needRenderCaves(class_1937 world, class_2338 playerPos) {
        boolean allowCaves = Minimap.isAllowed(ClientParams.drawCaves, MapGameRules.ALLOW_CAVES_MAP);
        class_2874 dimType = world.method_8597().method_12460();
        if (dimType == class_2874.field_13078) {
            return false;
        }
        if (dimType.method_12491()) {
            return allowCaves && !world.method_22348(playerPos) && world.method_8314(class_1944.field_9284, playerPos) == 0;
        }
        return allowCaves;
    }

    public static boolean allowEntityRadar() {
        return Minimap.isAllowed(ClientParams.showEntities, MapGameRules.ALLOW_ENTITY_RADAR);
    }

    public static boolean allowHostileRadar() {
        return Minimap.isAllowed(ClientParams.showHostile, MapGameRules.ALLOW_HOSTILE_RADAR);
    }

    public static boolean allowCreatureRadar() {
        return Minimap.isAllowed(ClientParams.showCreatures, MapGameRules.ALLOW_CREATURE_RADAR);
    }

    public static boolean allowPlayerRadar() {
        return Minimap.isAllowed(ClientParams.showPlayers, MapGameRules.ALLOW_PLAYER_RADAR);
    }

    public void prepareMap(class_1657 player) {
        class_1937 world = player.field_6002;
        class_2338 pos = PosUtil.currentPos();
        this.currentBiome = world.method_23753(pos);
        int posX = pos.method_10263();
        int posZ = pos.method_10260();
        int posY = pos.method_10264();
        int scaledW = this.scaledWidth;
        int scaledH = this.scaledHeight;
        double startX = posX - scaledW / 2;
        double startZ = posZ - scaledH / 2;
        if (world.field_9247.method_12467()) {
            MapCache.setCurrentLayer(Layer.Type.NETHER, posY);
        } else if (this.needRenderCaves(world, pos)) {
            MapCache.setCurrentLayer(Layer.Type.CAVES, posY);
        } else {
            MapCache.setCurrentLayer(Layer.Type.SURFACE, posY);
        }
        if (this.lastPosX != posX || this.lastPosZ != posZ) {
            this.lastPosX = posX;
            this.lastPosZ = posZ;
            this.posChanged = true;
        }
        if (ClientParams.rotateMap) {
            scaledW = (int)((float)this.mapWidth * this.mapScale);
            scaledH = (int)((float)this.mapHeight * this.mapScale);
            startX = posX - scaledW / 2;
            startZ = posZ - scaledH / 2;
        }
        double endX = startX + (double)scaledW;
        double endZ = startZ + (double)scaledH;
        if (Minimap.allowEntityRadar()) {
            this.players.clear();
            this.entities.clear();
            int checkHeight = 24;
            class_2338 start = new class_2338(startX, (double)(posY - checkHeight / 2), startZ);
            class_2338 end = new class_2338(endX, (double)(posY + checkHeight / 2), endZ);
            List entities = world.method_8335(null, new class_238(start, end));
            int amount = 0;
            for (class_1297 entity : entities) {
                float tick = minecraftClient.method_1488();
                double entX = entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)tick;
                double entZ = entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)tick;
                double iconX = MathUtil.screenPos(entX, startX, endX, this.mapWidth);
                double iconY = MathUtil.screenPos(entZ, startZ, endZ, this.mapHeight);
                if (entity instanceof class_746 && Minimap.allowPlayerRadar()) {
                    class_746 pEntity = (class_746)entity;
                    if (pEntity == player) continue;
                    PlayerIcon playerIcon = new PlayerIcon(this, pEntity, false);
                    playerIcon.setPosition(iconX, iconY);
                    this.players.add(playerIcon);
                } else if (entity instanceof class_1309 && !(entity instanceof class_1657)) {
                    EntityIcon entIcon;
                    class_1309 livingEntity = (class_1309)entity;
                    boolean hostile = livingEntity instanceof class_1588;
                    if (hostile && Minimap.allowHostileRadar()) {
                        entIcon = new EntityIcon(this, entity, hostile);
                        entIcon.setPosition(iconX, iconY);
                        this.entities.add(entIcon);
                        ++amount;
                    } else if (!hostile && Minimap.allowCreatureRadar()) {
                        entIcon = new EntityIcon(this, entity, hostile);
                        entIcon.setPosition(iconX, iconY);
                        this.entities.add(entIcon);
                        ++amount;
                    }
                }
                if (amount < 250) continue;
                break;
            }
        }
        this.waypoints.clear();
        List<Waypoint> wps = WaypointKeeper.getInstance().getWaypoints(world.field_9247.method_12460().method_12484(), true);
        if (wps != null) {
            Stream<Waypoint> stream = wps.stream().filter(wp -> MathUtil.getDistance(pos, wp.pos, false) <= (double)wp.showRange);
            for (Waypoint wp2 : (Waypoint[])stream.toArray(Waypoint[]::new)) {
                WaypointIcon waypoint = new WaypointIcon(this, wp2);
                waypoint.setPosition(MathUtil.screenPos(wp2.pos.method_10263(), startX, endX, this.mapWidth), MathUtil.screenPos(wp2.pos.method_10260(), startZ, endZ, this.mapHeight));
                this.waypoints.add(waypoint);
            }
        }
    }

    public List<WaypointIcon> getWaypoints() {
        return this.waypoints;
    }

    public void createWaypoint(int dimension, class_2338 pos) {
        Waypoint waypoint = new Waypoint();
        waypoint.dimension = dimension;
        waypoint.name = "Waypoint";
        waypoint.color = RandomUtil.getElement(Waypoint.WAYPOINT_COLORS);
        waypoint.pos = pos;
        minecraftClient.method_1507((class_437)new WaypointEditor(waypoint, Minimap.minecraftClient.field_1755, WaypointKeeper.getInstance()::addNew));
    }

    public void createWaypoint() {
        class_746 player = Minimap.minecraftClient.field_1724;
        this.createWaypoint(player.field_6002.field_9247.method_12460().method_12484(), player.method_5704());
    }

    @Override
    public float getScale() {
        return this.mapScale;
    }

    public List<PlayerIcon> getPlayerIcons() {
        return this.players;
    }

    public List<EntityIcon> getEntities() {
        return this.entities;
    }

    public TextManager getTextManager() {
        return this.textManager;
    }

    public boolean isMapVisible() {
        if (Minimap.minecraftClient.field_1755 != null) {
            return this.isMapVisible && !minecraftClient.method_1493() && ClientParams.showInChat && Minimap.minecraftClient.field_1755 instanceof class_408;
        }
        return this.isMapVisible;
    }

    public int getLasX() {
        return this.lastPosX;
    }

    public int getLastZ() {
        return this.lastPosZ;
    }

    @Override
    public int getWidth() {
        return this.mapWidth;
    }

    @Override
    public int getHeight() {
        return this.mapHeight;
    }

    @Override
    public int getScaledWidth() {
        return this.scaledWidth;
    }

    @Override
    public int getScaledHeight() {
        return this.scaledHeight;
    }
}

