/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.minimap;

import java.util.ArrayList;
import java.util.List;
import ru.bulldog.justmap.map.minimap.MapText;
import ru.bulldog.justmap.map.minimap.Minimap;

public class TextManager {
    private int x;
    private int y;
    private TextPosition position = TextPosition.UNDER;
    private Minimap map;
    private List<MapText> mapInfo;
    private List<MapText> mapElements;
    private int spacing = 16;

    public TextManager(Minimap map) {
        this.map = map;
        this.mapInfo = new ArrayList<MapText>();
        this.mapElements = new ArrayList<MapText>();
    }

    public void clear() {
        this.mapInfo.clear();
        this.mapElements.clear();
    }

    public void draw() {
        this.spacing = 10;
        int yp = this.y;
        if (this.position == TextPosition.ABOVE) {
            yp = this.y - this.spacing * this.mapInfo.size();
        }
        for (MapText line : this.mapInfo) {
            switch (line.alignment) {
                case LEFT: {
                    line.x = this.x;
                    break;
                }
                case CENTER: {
                    line.x = this.x + this.map.getWidth() / 2;
                    break;
                }
                case RIGHT: {
                    line.x = this.x + this.map.getWidth();
                }
            }
            line.y = yp;
            line.draw();
            yp += this.spacing;
        }
        for (MapText elem : this.mapElements) {
            elem.draw();
        }
    }

    public void add(MapText info) {
        this.mapInfo.add(info);
    }

    public void add(MapText element, int x, int y) {
        element.x = x;
        element.y = y;
        this.mapElements.add(element);
    }

    public TextManager setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public TextManager setDirection(TextPosition pos) {
        this.position = pos;
        return this;
    }

    public TextManager setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public static enum TextPosition {
        ABOVE,
        UNDER;

    }
}

