/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.waypoint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.map.icon.AbstractIcon;
import ru.bulldog.justmap.map.waypoint.WaypointKeeper;
import ru.bulldog.justmap.util.ColorUtil;
import ru.bulldog.justmap.util.ImageUtil;
import ru.bulldog.justmap.util.SpriteAtlas;
import ru.bulldog.justmap.util.math.RandomUtil;

public class Waypoint {
    private static final Icon[] WAYPOINT_ICONS = new Icon[]{null, new Icon(1, new class_2960("justmap", "textures/icon/circle.png"), -28672, 18, 18), new Icon(2, new class_2960("justmap", "textures/icon/cross.png"), -65536, 18, 18), new Icon(3, new class_2960("justmap", "textures/icon/diamond.png"), -1635101, 18, 18), new Icon(4, new class_2960("justmap", "textures/icon/moon.png"), -5380880, 18, 18), new Icon(5, new class_2960("justmap", "textures/icon/skull.png"), -262, 18, 18), new Icon(6, new class_2960("justmap", "textures/icon/square.png"), -16723713, 18, 18), new Icon(7, new class_2960("justmap", "textures/icon/star.png"), -4608, 18, 18), new Icon(8, new class_2960("justmap", "textures/icon/triangle.png"), -16711936, 18, 18), new Icon(9, new class_2960("justmap", "textures/icon/house.png"), -1333504, 18, 18), new Icon(10, new class_2960("justmap", "textures/icon/village.png"), -243199, 18, 18), new Icon(11, new class_2960("textures/item/iron_pickaxe.png"), -5197648, 16, 16), new Icon(12, new class_2960("textures/item/iron_axe.png"), -5197648, 16, 16), new Icon(13, new class_2960("textures/item/iron_hoe.png"), -5197648, 16, 16), new Icon(14, new class_2960("textures/item/iron_sword.png"), -5197648, 16, 16), new Icon(15, new class_2960("textures/item/wheat.png"), -4463, 16, 16), new Icon(16, new class_2960("textures/item/trident.png"), -11214414, 16, 16), new Icon(17, new class_2960("textures/item/slime_ball.png"), -7808143, 16, 16)};
    public static final Integer[] WAYPOINT_COLORS = new Integer[]{-65536, -16711936, -16776961, -5636096, -22016, -256, -16733696, -16711681, -16733526, -16777063, -16181, -65281, -9826899};
    public String name = "";
    public class_2338 pos = new class_2338(0, 0, 0);
    public int dimension;
    public int color;
    public boolean showAlways;
    public boolean hidden = false;
    public boolean tracking = true;
    public boolean render = true;
    public int showRange = 1000;
    private int icon = -1;

    public static void createOnDeath(int dimension, class_2338 pos) {
        Waypoint waypoint = new Waypoint();
        waypoint.dimension = dimension;
        waypoint.name = "Player Death";
        waypoint.pos = pos;
        waypoint.setIcon(Waypoint.getIcon(2), -65536);
        JustMap.LOGGER.logInfo("Created Death waypoint at " + waypoint.pos.method_23854());
        WaypointKeeper.getInstance().addNew(waypoint);
        WaypointKeeper.getInstance().saveWaypoints();
    }

    public static Icon getIcon(int id) {
        if (id > 0 && id < WAYPOINT_ICONS.length) {
            return WAYPOINT_ICONS[id];
        }
        return null;
    }

    public static Icon getColoredIcon(int color) {
        return Icon.coloredIcon(color);
    }

    public static int amountIcons() {
        return WAYPOINT_ICONS.length - 1;
    }

    public boolean isVisible() {
        return !this.hidden || this.showAlways;
    }

    public void setIcon(Icon icon, int color) {
        if (icon.key > 0) {
            this.icon = icon.key;
            this.color = icon.color;
        } else {
            this.color = color;
        }
    }

    public Icon getIcon() {
        if (this.icon > 0) {
            return Waypoint.getIcon(this.icon);
        }
        return Icon.coloredIcon(this.color);
    }

    public JsonElement toJson() {
        JsonObject waypoint = new JsonObject();
        waypoint.addProperty("name", this.name);
        waypoint.addProperty("dimension", (Number)this.dimension);
        waypoint.addProperty("show_always", Boolean.valueOf(this.showAlways));
        waypoint.addProperty("hidden", Boolean.valueOf(this.hidden));
        waypoint.addProperty("tracking", Boolean.valueOf(this.tracking));
        waypoint.addProperty("render", Boolean.valueOf(this.render));
        waypoint.addProperty("show_range", (Number)this.showRange);
        waypoint.addProperty("color", Integer.toHexString(this.color).toUpperCase());
        waypoint.addProperty("icon", (Number)this.icon);
        JsonObject position = new JsonObject();
        position.addProperty("x", (Number)this.pos.method_10263());
        position.addProperty("y", (Number)this.pos.method_10264());
        position.addProperty("z", (Number)this.pos.method_10260());
        waypoint.add("position", (JsonElement)position);
        return waypoint;
    }

    public static Waypoint fromJson(JsonObject jsonObject) {
        Waypoint waypoint = new Waypoint();
        JsonObject position = class_3518.method_15281((JsonObject)jsonObject, (String)"position", (JsonObject)new JsonObject());
        waypoint.pos = new class_2338(class_3518.method_15282((JsonObject)position, (String)"x", (int)0), class_3518.method_15282((JsonObject)position, (String)"y", (int)0), class_3518.method_15282((JsonObject)position, (String)"z", (int)0));
        waypoint.name = class_3518.method_15253((JsonObject)jsonObject, (String)"name", (String)"Waypoint");
        waypoint.dimension = class_3518.method_15282((JsonObject)jsonObject, (String)"dimension", (int)0);
        waypoint.showAlways = class_3518.method_15258((JsonObject)jsonObject, (String)"show_always", (boolean)false);
        waypoint.hidden = class_3518.method_15258((JsonObject)jsonObject, (String)"hidden", (boolean)false);
        waypoint.tracking = class_3518.method_15258((JsonObject)jsonObject, (String)"tracking", (boolean)true);
        waypoint.render = class_3518.method_15258((JsonObject)jsonObject, (String)"render", (boolean)true);
        waypoint.showRange = class_3518.method_15282((JsonObject)jsonObject, (String)"show_range", (int)1000);
        waypoint.color = ColorUtil.parseHex(class_3518.method_15253((JsonObject)jsonObject, (String)"color", (String)Integer.toHexString(RandomUtil.getElement(WAYPOINT_COLORS))));
        waypoint.icon = class_3518.method_15282((JsonObject)jsonObject, (String)"icon", (int)-1);
        return waypoint;
    }

    public static class Icon
    extends AbstractIcon {
        public static final class_2960 DEFAULT_ICON = new class_2960("justmap", "textures/icon/default.png");
        private static final class_1011 DEFAULT_TEXTURE = ImageUtil.loadImage(DEFAULT_ICON, 18, 18);
        public final int key;
        public final int color;
        private static final Map<Integer, Icon> coloredIcons = new HashMap<Integer, Icon>();

        private Icon(int key, class_2960 icon, int color, int w, int h) {
            super(SpriteAtlas.WAYPOINT_ICONS, new class_1058.class_4727(icon, w, h, class_1079.field_21768), 0, w, h, 0, 0, ImageUtil.loadImage(icon, w, h));
            this.key = key;
            this.color = color;
        }

        private Icon(int key, class_2960 icon, class_1011 texture, int color, int w, int h) {
            super(SpriteAtlas.WAYPOINT_ICONS, new class_1058.class_4727(icon, w, h, class_1079.field_21768), 0, w, h, 0, 0, texture);
            this.key = key;
            this.color = color;
        }

        private static Icon coloredIcon(int color) {
            if (coloredIcons.containsKey(color)) {
                return coloredIcons.get(color);
            }
            class_1011 texture = new class_1011(18, 18, false);
            texture.method_4317(DEFAULT_TEXTURE);
            ImageUtil.applyColor(texture, color);
            Icon icon = new Icon(-1, DEFAULT_ICON, texture, color, 18, 18);
            coloredIcons.put(color, icon);
            return icon;
        }

        public void bindTexture() {
            textureManager.method_22813(this.getTexture());
        }

        @Override
        public void draw(double x, double y, int w, int h) {
            class_4587 matrix = new class_4587();
            this.draw(matrix, x, y, w, h);
        }

        @Override
        public void draw(class_4587 matrix, double x, double y, int w, int h) {
            this.bindTexture();
            this.draw(matrix, x, y, (float)w, (float)h);
        }

        private class_2960 getColoredTexture() {
            class_2960 id = new class_2960("justmap", String.format("wp_icon_%d", this.color));
            if (textureManager.method_4619(id) == null) {
                textureManager.method_4616(id, (class_1044)new class_1043(this.field_5262[0]));
            }
            return id;
        }

        public class_2960 getTexture() {
            if (this.key > 0) {
                return this.method_4598();
            }
            return this.getColoredTexture();
        }
    }

    public static class Icons {
        public static final int CIRCLE = 1;
        public static final int CROSS = 2;
        public static final int DIAMOND = 3;
        public static final int MOON = 4;
        public static final int SKULL = 5;
        public static final int SQUARE = 6;
        public static final int STAR = 7;
        public static final int TRIANGLE = 8;
        public static final int HOUSE = 9;
        public static final int VILLAGE = 10;
        public static final int PICK = 11;
        public static final int AXE = 12;
        public static final int HOE = 13;
        public static final int SWORD = 14;
        public static final int WHEAT = 15;
        public static final int TRIDENT = 16;
        public static final int SLIME = 17;
    }
}

