/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.waypoint;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2874;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import ru.bulldog.justmap.client.MapScreen;
import ru.bulldog.justmap.client.widget.TitledWidget;
import ru.bulldog.justmap.map.waypoint.Waypoint;
import ru.bulldog.justmap.map.waypoint.WaypointKeeper;
import ru.bulldog.justmap.util.Predicates;

public class WaypointEditor
extends MapScreen {
    private static final class_2585 title = new class_2585("Edit Waypoint");
    private final Waypoint waypoint;
    private int colorIndex;
    private int iconIndex;
    private int spacing = 2;
    private int padding = 10;
    private int rowH = 20;
    private TitledWidget<class_342> nameField;
    private class_4286 isHidden;
    private class_4286 isTrackable;
    private class_4286 isRenderable;
    private class_4185 prevColorButton;
    private class_4185 nextColorButton;
    private class_4185 prevIconButton;
    private class_4185 nextIconButton;
    private class_342 xField;
    private class_342 yField;
    private class_342 zField;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private Consumer<Waypoint> onSaveCallback;

    public WaypointEditor(Waypoint waypoint, class_437 parent, Consumer<Waypoint> onSaveCallback) {
        super((class_2561)title, parent);
        this.waypoint = waypoint;
        this.colorIndex = this.getColorIndex(waypoint.color);
        this.iconIndex = this.getIconIndex(waypoint.getIcon());
        this.onSaveCallback = onSaveCallback;
    }

    @Override
    public void init() {
        int dimId = this.minecraft.field_1724.field_6026.method_12484();
        this.info = DIMENSION_INFO.getOrDefault(class_2874.method_12490((int)dimId).toString(), null);
        this.center = this.width / 2;
        int screenW = Math.max(400, this.center);
        this.x = this.center - screenW / 2;
        this.y = 60;
        int row = this.rowH + this.spacing;
        int ex = this.x + this.padding;
        int ey = this.y;
        int ew = screenW - this.padding * 2;
        this.nameField = new TitledWidget<class_342>(this.font, new class_342(this.font, 0, 0, ew - 30, 12, "Name"), ex, ey, ew, this.rowH, "", this.lang("name"));
        this.nameField.changeFocus(true);
        ((class_342)this.nameField.widget).method_1880(12);
        ((class_342)this.nameField.widget).method_1852(this.waypoint.name);
        this.children.add(this.nameField);
        Predicate<String> validNumber = s -> Predicates.or(s, Predicates.isInteger, Predicates.isEmpty);
        ew = 60;
        int px = this.center - ew * 3 / 2;
        this.xField = new class_342(this.font, px, ey += row, ew, this.rowH, "");
        this.xField.method_1890(validNumber);
        this.xField.method_1880(7);
        this.xField.method_1852(this.waypoint.pos.method_10263() + "");
        this.yField = new class_342(this.font, px + ew, ey, ew, this.rowH, "");
        this.yField.method_1890(validNumber);
        this.yField.method_1880(7);
        this.yField.method_1852(this.waypoint.pos.method_10264() + "");
        this.zField = new class_342(this.font, px + 2 * ew, ey, ew, this.rowH, "");
        this.zField.method_1890(validNumber);
        this.zField.method_1880(7);
        this.zField.method_1852(this.waypoint.pos.method_10260() + "");
        this.children.add(this.xField);
        this.children.add(this.yField);
        this.children.add(this.zField);
        ew = 20;
        this.prevColorButton = new class_4185(ex, ey += row, ew, this.rowH, "<", b -> this.cycleColor(-1));
        this.children.add(this.prevColorButton);
        this.nextColorButton = new class_4185(this.x + screenW - ew - this.padding, ey, ew, this.rowH, ">", b -> this.cycleColor(1));
        this.children.add(this.nextColorButton);
        this.prevIconButton = new class_4185(ex, ey += row, ew, this.rowH, "<", b -> this.cycleIcon(-1));
        this.children.add(this.prevIconButton);
        this.nextIconButton = new class_4185(this.x + screenW - ew - this.padding, ey, ew, this.rowH, ">", b -> this.cycleIcon(1));
        this.children.add(this.nextIconButton);
        ey = (int)((double)ey + (double)row * 1.5);
        this.isHidden = new class_4286(ex, ey, ew, this.rowH, this.lang("wp_hidden"), this.waypoint.hidden);
        this.isTrackable = new class_4286(ex + 90, ey, ew, this.rowH, this.lang("wp_tracking"), this.waypoint.tracking);
        this.isRenderable = new class_4286(ex + 180, ey, ew, this.rowH, this.lang("wp_render"), this.waypoint.render);
        this.children.add(this.isHidden);
        this.children.add(this.isTrackable);
        this.children.add(this.isRenderable);
        ew = 60;
        ey = this.height - (this.rowH / 2 + 16);
        this.saveButton = new class_4185(this.center - ew - 2, ey, ew, this.rowH, this.lang("save"), b -> {
            this.save();
            this.onClose();
        });
        this.children.add(this.saveButton);
        this.cancelButton = new class_4185(this.center + 2, ey, ew, this.rowH, this.lang("cancel"), b -> this.onClose());
        this.children.add(this.cancelButton);
        this.method_20085((class_364)this.nameField);
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        super.render(mouseX, mouseY, delta);
        String dimensionName = this.info == null ? this.lang("unknown") : class_1074.method_4662((String)((String)this.info.getFirst()), (Object[])new Object[0]);
        this.drawCenteredString(this.font, dimensionName, this.center, 15, -1);
    }

    private void cycleColor(int i) {
        this.colorIndex += i;
        if (this.colorIndex < 0) {
            this.colorIndex = Waypoint.WAYPOINT_COLORS.length - 1;
        } else if (this.colorIndex >= Waypoint.WAYPOINT_COLORS.length) {
            this.colorIndex = 0;
        }
    }

    private void cycleIcon(int i) {
        this.iconIndex += i;
        if (this.iconIndex < 0) {
            this.iconIndex = Waypoint.amountIcons();
        } else if (this.iconIndex >= Waypoint.amountIcons()) {
            this.iconIndex = 0;
        }
    }

    private void save() {
        this.waypoint.name = ((class_342)this.nameField.widget).method_1882();
        int color = Waypoint.WAYPOINT_COLORS[this.colorIndex];
        if (Waypoint.getIcon(this.iconIndex) != null) {
            this.waypoint.setIcon(Waypoint.getIcon(this.iconIndex), color);
        } else {
            this.waypoint.color = color;
        }
        this.waypoint.hidden = this.isHidden.method_20372();
        this.waypoint.tracking = this.isTrackable.method_20372();
        this.waypoint.render = this.isRenderable.method_20372();
        int xPos = this.xField.method_1882().isEmpty() ? 0 : Integer.parseInt(this.xField.method_1882());
        int yPos = this.yField.method_1882().isEmpty() ? 0 : Integer.parseInt(this.yField.method_1882());
        int zPos = this.zField.method_1882().isEmpty() ? 0 : Integer.parseInt(this.zField.method_1882());
        this.waypoint.pos = new class_2338(xPos, yPos, zPos);
        if (this.onSaveCallback != null) {
            this.onSaveCallback.accept(this.waypoint);
        }
        WaypointKeeper.getInstance().saveWaypoints();
    }

    @Override
    public void onClose() {
        this.minecraft.method_1507(this.parent);
    }

    @Override
    public void renderForeground() {
        int x = this.prevColorButton.x + this.prevColorButton.getWidth() + 2;
        int y = this.prevColorButton.y + 3;
        int w = this.nextColorButton.x - x - 2;
        int h = 12;
        int col = Waypoint.WAYPOINT_COLORS[this.colorIndex];
        Waypoint.Icon icon = this.iconIndex > 0 ? Waypoint.getIcon(this.iconIndex) : Waypoint.getColoredIcon(col);
        int ix = this.center - icon.method_4578() / 2;
        int iy = y + this.rowH + (this.rowH / 2 - icon.method_4595() / 2);
        int color = this.iconIndex > 0 ? icon.color : col;
        this.borderedRect(x, y, w, h, color, 2, -3355444);
        icon.draw(ix, iy);
    }

    public void tick() {
    }

    private void rect(int x, int y, int w, int h, int color) {
        WaypointEditor.fill((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
    }

    private void borderedRect(int x, int y, int w, int h, int color, int border, int borderColor) {
        int hb = border >> 1;
        this.rect(x, y, w, h, borderColor);
        this.rect(x + hb, y + hb, w - border, h - border, color);
    }

    private int getColorIndex(int color) {
        for (int i = 0; i < Waypoint.WAYPOINT_COLORS.length; ++i) {
            if (Waypoint.WAYPOINT_COLORS[i] != color) continue;
            return i;
        }
        return 0;
    }

    private int getIconIndex(Waypoint.Icon icon) {
        if (icon == null) {
            return 0;
        }
        return icon.key;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 257) {
            this.save();
            this.onClose();
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
}

