/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.waypoint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bulldog.justmap.map.waypoint.Waypoint;
import ru.bulldog.justmap.util.JsonFactory;
import ru.bulldog.justmap.util.StorageUtil;

public class WaypointKeeper
extends JsonFactory {
    private static Map<Integer, List<Waypoint>> waypoints;
    private static WaypointKeeper instance;
    private static File currentStorage;

    public static WaypointKeeper getInstance() {
        if (instance == null) {
            instance = new WaypointKeeper();
        }
        File waypointsFile = new File(StorageUtil.filesDir(), "/waypoints.json");
        if (currentStorage == null || !currentStorage.equals(waypointsFile)) {
            currentStorage = waypointsFile;
            instance.loadWaypoints();
        }
        return instance;
    }

    private WaypointKeeper() {
    }

    private void loadWaypoints() {
        JsonObject jsonObject;
        waypoints = new HashMap<Integer, List<Waypoint>>();
        if (currentStorage.exists() && (jsonObject = WaypointKeeper.loadJson(currentStorage)).has("waypoints")) {
            JsonArray waypointObject = jsonObject.getAsJsonArray("waypoints");
            for (JsonElement elem : waypointObject) {
                Waypoint wp = Waypoint.fromJson((JsonObject)elem);
                this.getWaypoints(wp.dimension, false).add(wp);
            }
        }
    }

    public void saveWaypoints() {
        JsonArray waypointArray = new JsonArray();
        for (Map.Entry<Integer, List<Waypoint>> entry : waypoints.entrySet()) {
            List<Waypoint> list = entry.getValue();
            for (Waypoint wp : list) {
                waypointArray.add(wp.toJson());
            }
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("waypoints", (JsonElement)waypointArray);
        File waypointsFile = new File(StorageUtil.filesDir(), "/waypoints.json");
        WaypointKeeper.storeJson(waypointsFile, (JsonElement)jsonObject);
    }

    public void addNew(Waypoint waypoint) {
        this.getWaypoints(waypoint.dimension, false).add(waypoint);
    }

    public void remove(Waypoint waypoint) {
        this.getWaypoints(waypoint.dimension, false).remove(waypoint);
    }

    public List<Waypoint> getWaypoints(int dimension, boolean hiddenFilter) {
        List<Object> list;
        if (waypoints.get(dimension) == null) {
            list = new ArrayList();
            waypoints.put(dimension, list);
        } else {
            list = waypoints.get(dimension);
        }
        if (hiddenFilter) {
            return list.stream().filter(Waypoint::isVisible).collect(Collectors.toList());
        }
        return list;
    }

    public List<Integer> getDimensions() {
        return new ArrayList<Integer>(waypoints.keySet());
    }
}

