/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.map.waypoint;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import ru.bulldog.justmap.client.MapScreen;
import ru.bulldog.justmap.map.waypoint.Waypoint;
import ru.bulldog.justmap.map.waypoint.WaypointEditor;
import ru.bulldog.justmap.map.waypoint.WaypointKeeper;
import ru.bulldog.justmap.util.DrawHelper;
import ru.bulldog.justmap.util.math.MathUtil;
import ru.bulldog.justmap.util.math.RandomUtil;

public class WaypointsList
extends MapScreen {
    private static final class_2561 title = new class_2585("Waypoints");
    private WaypointKeeper keeper = WaypointKeeper.getInstance();
    private int currentDim = 0;
    private int currentDimIndex = 0;
    private List<Integer> dimensions;
    private List<Waypoint> wayPoints;
    private List<Entry> entries = new ArrayList<Entry>();
    private int scrollAmount = 0;
    private int maxScroll = 0;
    private int screenWidth;
    private class_4185 prevDimensionButton;
    private class_4185 nextDimensionButton;
    private class_4185 addButton;
    private class_4185 closeButton;

    public WaypointsList(class_437 parent) {
        super(title, parent);
        if (this.minecraft == null) {
            this.minecraft = class_310.method_1551();
        }
        this.dimensions = this.keeper.getDimensions();
        int overworld = class_2874.field_13072.method_12484();
        int nether = class_2874.field_13076.method_12484();
        int theEnd = class_2874.field_13078.method_12484();
        if (!this.dimensions.contains(overworld)) {
            this.dimensions.add(overworld);
        }
        if (!this.dimensions.contains(nether)) {
            this.dimensions.add(nether);
        }
        if (!this.dimensions.contains(theEnd)) {
            this.dimensions.add(theEnd);
        }
        this.currentDim = this.minecraft.field_1724.field_6026.method_12484();
        this.currentDimIndex = this.getDimIndex(this.currentDim);
    }

    @Override
    protected void init() {
        this.center = this.width / 2;
        this.screenWidth = Math.max(480, this.center);
        this.x = this.center - this.screenWidth / 2;
        this.prevDimensionButton = new class_4185(this.x + 10, 10, 20, 20, "<", b -> this.cycleDimension(-1));
        this.nextDimensionButton = new class_4185(this.x + this.screenWidth - 30, 10, 20, 20, ">", b -> this.cycleDimension(1));
        this.addButton = new class_4185(this.center - 62, this.height - 26, 60, 20, this.lang("create"), b -> this.add());
        this.closeButton = new class_4185(this.center + 2, this.height - 26, 60, 20, this.lang("close"), b -> this.onClose());
        this.reset();
    }

    private void createEntries() {
        this.entries.clear();
        int y = 40;
        for (Waypoint wp : this.wayPoints) {
            Entry entry = new Entry(this, this.x + 10, this.scrollAmount + y, this.screenWidth - 20, 20, wp);
            this.entries.add(entry);
            y += entry.height;
        }
    }

    private void updateEntries() {
        int y = 40;
        for (Entry entry : this.entries) {
            entry.setPosition(this.x + 10, this.scrollAmount + y);
            y += entry.height;
        }
    }

    private void cycleDimension(int i) {
        this.currentDimIndex += i;
        if (this.currentDimIndex >= this.dimensions.size()) {
            this.currentDimIndex = 0;
        } else if (this.currentDimIndex < 0) {
            this.currentDimIndex = this.dimensions.size() - 1;
        }
        this.currentDim = this.dimensions.get(this.currentDimIndex);
        this.reset();
    }

    private int getDimIndex(int dim) {
        return this.dimensions.indexOf(dim);
    }

    public void reset() {
        this.info = this.getDimensionInfo(this.currentDim);
        this.wayPoints = this.keeper.getWaypoints(this.currentDim, false);
        this.createEntries();
        this.maxScroll = this.wayPoints.size() * 20;
        this.children.clear();
        this.children.addAll(this.entries);
        this.children.add(this.addButton);
        this.children.add(this.closeButton);
        this.children.add(this.prevDimensionButton);
        this.children.add(this.nextDimensionButton);
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        super.render(mouseX, mouseY, delta);
        this.entries.forEach(e -> e.render(mouseX, mouseY, delta));
        String dimensionName = this.info == null ? this.lang("unknown") : class_1074.method_4662((String)((String)this.info.getFirst()), (Object[])new Object[0]);
        this.drawCenteredString(this.font, dimensionName, this.center, 15, -1);
        this.drawScrollBar();
    }

    private Pair<String, class_2960> getDimensionInfo(int dim) {
        class_2874 type = class_2874.method_12490((int)dim);
        String key = "unknown";
        if (type != null) {
            key = type.toString();
        }
        return DIMENSION_INFO.getOrDefault(key, null);
    }

    private void drawScrollBar() {
    }

    private void edit(Waypoint waypoint) {
        this.minecraft.method_1507((class_437)new WaypointEditor(waypoint, this, null));
    }

    private void add() {
        Waypoint waypoint = new Waypoint();
        waypoint.dimension = this.currentDim;
        waypoint.color = RandomUtil.getElement(Waypoint.WAYPOINT_COLORS);
        waypoint.pos = this.minecraft.field_1724.method_5704();
        waypoint.name = "Waypoint";
        this.minecraft.method_1507((class_437)new WaypointEditor(waypoint, this, this.keeper::addNew));
    }

    private void delete(Waypoint waypoint) {
        this.keeper.remove(waypoint);
        this.keeper.saveWaypoints();
        this.reset();
    }

    public void teleport(Waypoint waypoint) {
        if (this.minecraft.field_1724.field_6026.method_12484() != this.currentDim) {
            return;
        }
        int y = waypoint.pos.method_10264() > 0 ? waypoint.pos.method_10264() : (this.minecraft.field_1724.field_6026 != class_2874.field_13076 ? 128 : 64);
        this.minecraft.field_1724.method_3142("/tp " + this.minecraft.field_1724.method_5477().method_10851() + " " + waypoint.pos.method_10263() + " " + y + " " + waypoint.pos.method_10260());
        this.onClose();
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        this.scrollAmount = MathUtil.clamp(this.scrollAmount + (int)(double_3 * 12.0), -this.maxScroll + 80, 0);
        this.updateEntries();
        return true;
    }

    private static class Entry
    implements class_364 {
        private class_310 minecraft;
        private int x;
        private int y;
        private int width;
        private int height;
        private class_4185 editButton;
        private class_4185 deleteButton;
        private class_4185 tpButton;
        private Waypoint waypoint;

        public Entry(WaypointsList wayPointListEditor, int x, int y, int width, int height, Waypoint waypoint) {
            this.width = width;
            this.height = height + 2;
            this.waypoint = waypoint;
            this.minecraft = class_310.method_1551();
            this.editButton = new class_4185(0, 0, 40, height, wayPointListEditor.lang("edit"), b -> wayPointListEditor.edit(waypoint));
            this.deleteButton = new class_4185(0, 0, 40, height, wayPointListEditor.lang("delete"), b -> wayPointListEditor.delete(waypoint));
            this.tpButton = new class_4185(0, 0, 40, height, wayPointListEditor.lang("teleport"), b -> wayPointListEditor.teleport(waypoint));
            this.setPosition(x, y);
        }

        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            this.rightAlign(this.deleteButton, x + this.width - 2);
            this.rightAlign(this.editButton, this.deleteButton);
            this.rightAlign(this.tpButton, this.editButton);
            this.editButton.y = y + 1;
            this.tpButton.y = y + 1;
            this.deleteButton.y = y + 1;
        }

        public void render(int mouseX, int mouseY, float delta) {
            class_327 font = this.minecraft.field_1772;
            boolean hover = this.isMouseOver(mouseX, mouseY);
            int bgColor = hover ? -2002081110 : -2009910477;
            class_332.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)bgColor);
            int iconSize = this.height - 2;
            Waypoint.Icon icon = this.waypoint.getIcon();
            if (icon != null) {
                icon.draw(this.x, (double)(this.y + 1), iconSize, iconSize);
            } else {
                DrawHelper.drawDiamond(this.x, this.y + 1, iconSize, iconSize, this.waypoint.color);
            }
            int stringY = this.y + 7;
            int nameX = this.x + iconSize + 2;
            DrawHelper.DRAWER.drawString(font, this.waypoint.name, nameX, stringY, -1);
            int posX = this.tpButton.x - 5;
            DrawHelper.DRAWER.drawRightAlignedString(font, this.waypoint.pos.method_23854(), posX, stringY, -1);
            this.editButton.render(mouseX, mouseY, delta);
            this.tpButton.render(mouseX, mouseY, delta);
            this.deleteButton.render(mouseX, mouseY, delta);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            return this.editButton.mouseClicked(double_1, double_2, int_1) || this.deleteButton.mouseClicked(double_1, double_2, int_1) || this.tpButton.mouseClicked(double_1, double_2, int_1);
        }

        public boolean mouseReleased(double double_1, double double_2, int int_1) {
            return this.editButton.mouseReleased(double_1, double_2, int_1) || this.deleteButton.mouseReleased(double_1, double_2, int_1) || this.tpButton.mouseReleased(double_1, double_2, int_1);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        private void rightAlign(class_4185 toAlign, class_4185 from) {
            toAlign.x = from.x - toAlign.getWidth() - 1;
        }

        private void rightAlign(class_4185 toAlign, int right) {
            toAlign.x = right - toAlign.getWidth();
        }
    }
}

