/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.mixins.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4074;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.client.render.MapRenderer;
import ru.bulldog.justmap.map.minimap.MapPosition;

@Mixin(value={class_329.class})
abstract class HudMixin
extends class_332 {
    @Shadow
    private class_310 field_2035;
    @Shadow
    private int field_2011;

    HudMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void draw(float delta, CallbackInfo info) {
        MapRenderer mapGui = MapRenderer.getInstance();
        if (mapGui != null) {
            mapGui.draw();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatusEffectOverlay"}, cancellable=true)
    protected void renderStatusEffects(CallbackInfo info) {
        Collection collection;
        if (ClientParams.moveEffects && !(collection = this.field_2035.field_1724.method_6026()).isEmpty()) {
            int posX = this.field_2011;
            if (ClientParams.mapPosition == MapPosition.TOP_RIGHT) {
                posX = MapRenderer.getInstance().getX();
            }
            RenderSystem.enableBlend();
            int i = 0;
            int j = 0;
            int size = 24;
            int hOffset = 6;
            int vOffset = 10;
            if (!ClientParams.showEffectTimers) {
                hOffset = 1;
                vOffset = 2;
            }
            class_4074 statusEffectSpriteManager = this.field_2035.method_18505();
            ArrayList list = Lists.newArrayListWithExpectedSize((int)collection.size());
            ArrayList timers = Lists.newArrayListWithExpectedSize((int)collection.size());
            this.field_2035.method_1531().method_22813(class_465.field_2801);
            for (class_1293 statusEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                class_1291 statusEffect = statusEffectInstance.method_5579();
                if (!statusEffectInstance.method_5592()) continue;
                int k = posX;
                int l = ClientParams.positionOffset;
                if (this.field_2035.method_1530()) {
                    l += 15;
                }
                if (statusEffect.method_5573()) {
                    k -= (size + hOffset) * ++i;
                } else {
                    k -= (size + hOffset) * ++j;
                    l += size + vOffset;
                }
                int effectDuration = statusEffectInstance.method_5584();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f = 1.0f;
                if (statusEffectInstance.method_5591()) {
                    this.blit(k, l, 165, 166, size, size);
                } else {
                    this.blit(k, l, 141, 166, size, size);
                    if (effectDuration <= 200) {
                        int m = 10 - effectDuration / 20;
                        f = class_3532.method_15363((float)((float)effectDuration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + class_3532.method_15362((float)((float)effectDuration * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)m / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
                class_1058 sprite = statusEffectSpriteManager.method_18663(statusEffect);
                int fk = k;
                int fl = l;
                float ff = f;
                list.add(() -> {
                    this.field_2035.method_1531().method_22813(sprite.method_24119().method_24106());
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)ff);
                    HudMixin.blit((int)(fk + 3), (int)(fl + 3), (int)this.getBlitOffset(), (int)18, (int)18, (class_1058)sprite);
                });
                if (!ClientParams.showEffectTimers) continue;
                timers.add(() -> this.drawCenteredString(this.field_2035.field_1772, this.convertDuration(effectDuration), fk + size / 2, fl + (size + 1), -1));
            }
            list.forEach(Runnable::run);
            timers.forEach(Runnable::run);
            info.cancel();
        }
    }

    private String convertDuration(int time) {
        int mils = time * 50;
        int s = mils / 1000 % 60;
        int m = mils / 60000 % 60;
        return String.format("%02d:%02d", m, s);
    }
}

