/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.minecraft.class_1011;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2195;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2513;
import net.minecraft.class_2526;
import net.minecraft.class_2541;
import net.minecraft.class_2553;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_773;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.client.config.ClientParams;
import ru.bulldog.justmap.util.BakedData;
import ru.bulldog.justmap.util.ImageUtil;
import ru.bulldog.justmap.util.StateUtil;
import ru.bulldog.justmap.util.math.MathUtil;

public class ColorUtil {
    private static class_310 minecraft = class_310.method_1551();
    private static class_773 blockModels = minecraft.method_1541().method_3351();
    private static FluidRenderHandlerRegistryImpl fluidRenderHandlerRegistry = FluidRenderHandlerRegistryImpl.INSTANCE;
    private static Map<class_2680, Integer> colorCache = new HashMap<class_2680, Integer>();
    private static float[] floatBuffer = new float[3];

    public static int[] toIntArray(int color) {
        return new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
    }

    public static float[] toFloatArray(int color) {
        ColorUtil.floatBuffer[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        ColorUtil.floatBuffer[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        ColorUtil.floatBuffer[2] = (float)(color & 0xFF) / 255.0f;
        return floatBuffer;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = floatBuffer;
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static int parseHex(String hexColor) {
        int shift;
        int color;
        int len = hexColor.length();
        if (len < 6 || len > 8 || len % 2 > 0) {
            return -1;
        }
        if (len == 6) {
            color = -16777216;
            shift = 16;
        } else {
            color = 0;
            shift = 24;
        }
        try {
            String[] splited;
            for (String digit : splited = hexColor.split("(?<=\\G.{2})")) {
                color |= Integer.valueOf(digit, 16) << shift;
                shift -= 8;
            }
        }
        catch (NumberFormatException ex) {
            JustMap.LOGGER.catching(ex);
            return -1;
        }
        return color;
    }

    public static int toABGR(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    public static int ABGRtoARGB(int color) {
        int a = color >> 24 & 0xFF;
        int b = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int r = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int colorBrigtness(int color, float val) {
        ColorUtil.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, floatBuffer);
        floatBuffer[2] = floatBuffer[2] + val / 10.0f;
        ColorUtil.floatBuffer[2] = MathUtil.clamp(floatBuffer[2], 0.0f, 1.0f);
        return ColorUtil.HSBtoRGB(floatBuffer[0], floatBuffer[1], floatBuffer[2]);
    }

    private static int getStateColor(class_2680 state) {
        if (colorCache.containsKey(state)) {
            return colorCache.get(state);
        }
        return ColorUtil.extractColor(state);
    }

    private static int extractColor(class_2680 state) {
        List quads = blockModels.method_3335(state).method_4707(state, class_2350.field_11036, new Random());
        class_2960 blockSprite = quads.size() > 0 ? ((BakedData)quads.get(0)).getSprite().method_4598() : blockModels.method_3339(state).method_4598();
        class_2960 texture = new class_2960(blockSprite.method_12836(), String.format("textures/%s.png", blockSprite.method_12832()));
        class_1011 image = ImageUtil.loadImage(texture, 16, 16);
        long r = 0L;
        long g = 0L;
        long b = 0L;
        int pixels = 0;
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                int col = image.method_4315(i, j);
                if ((col >> 24 & 0xFF) <= 0) continue;
                b += (long)(col >> 16 & 0xFF);
                g += (long)(col >> 8 & 0xFF);
                r += (long)(col & 0xFF);
                ++pixels;
            }
        }
        image.close();
        if (pixels > 0) {
            int color = (int)(r / (long)pixels) << 16 | (int)(g / (long)pixels) << 8 | (int)(b / (long)pixels);
            colorCache.put(state, color);
            return color;
        }
        return -1;
    }

    public static int proccessColor(int color, int heightDiff) {
        ColorUtil.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, floatBuffer);
        floatBuffer[1] = floatBuffer[1] + (float)ClientParams.mapSaturation / 100.0f;
        ColorUtil.floatBuffer[1] = MathUtil.clamp(floatBuffer[1], 0.0f, 1.0f);
        floatBuffer[2] = floatBuffer[2] + (float)ClientParams.mapBrightness / 100.0f;
        ColorUtil.floatBuffer[2] = MathUtil.clamp(floatBuffer[2], 0.0f, 1.0f);
        if (ClientParams.showTerrain && heightDiff != 0) {
            floatBuffer[2] = floatBuffer[2] + (float)heightDiff / 10.0f;
            ColorUtil.floatBuffer[2] = MathUtil.clamp(floatBuffer[2], 0.0f, 1.0f);
        }
        return ColorUtil.HSBtoRGB(floatBuffer[0], floatBuffer[1], floatBuffer[2]);
    }

    private static int proccessColor(int blockColor, int textureColor, int defaultColor) {
        int n = blockColor = blockColor == -1 ? defaultColor : blockColor;
        if (blockColor != -1) {
            return ColorHelper.multiplyColor((int)textureColor, (int)blockColor);
        }
        return textureColor;
    }

    private static int fluidColor(class_1937 world, class_2680 state, class_2338 pos, int defColor) {
        class_3610 fluidState = state.method_11614().method_9545(state);
        int fcolor = fluidRenderHandlerRegistry.get(fluidState.method_15772()).getFluidColor((class_1920)world, pos, fluidState);
        return fcolor != -1 ? fcolor : defColor;
    }

    public static int applyTint(int color, int tint) {
        return ColorUtil.colorBrigtness(ColorHelper.multiplyColor((int)color, (int)tint), 1.5f);
    }

    public static int blockColor(class_2818 worldChunk, class_2338 pos) {
        boolean skipWater;
        class_1937 world = worldChunk.method_12200();
        class_2338 overPos = new class_2338(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
        class_2680 overState = worldChunk.method_8320(overPos);
        class_2680 blockState = worldChunk.method_8320(pos);
        boolean waterTint = ClientParams.alternateColorRender && ClientParams.waterTint;
        boolean bl = skipWater = !ClientParams.hideWater && !waterTint;
        if (!ClientParams.hideWater && ClientParams.hidePlants && StateUtil.isSeaweed(overState)) {
            if (waterTint) {
                int color = ColorUtil.blockColor(world, blockState, pos);
                return ColorUtil.applyTint(color, class_1163.method_4961((class_1920)world, (class_2338)pos));
            }
            return ColorUtil.blockColor(world, class_2246.field_10382.method_9564(), pos);
        }
        if (!StateUtil.isAir(blockState) && StateUtil.checkState(overState, skipWater, !ClientParams.hidePlants)) {
            int color = ColorUtil.blockColor(world, blockState, pos);
            if (ClientParams.hideWater) {
                return color;
            }
            if (waterTint && (StateUtil.isWater(overState) || StateUtil.isWaterlogged(blockState))) {
                return ColorUtil.applyTint(color, class_1163.method_4961((class_1920)world, (class_2338)pos));
            }
            return color;
        }
        return -1;
    }

    public static int blockColor(class_1937 world, class_2680 state, class_2338 pos) {
        int materialColor = state.method_11625((class_1922)world, (class_2338)pos).field_16011;
        if (ClientParams.alternateColorRender) {
            int blockColor = minecraft.method_1505().method_1697(state, (class_1920)world, pos, 0xF000F0);
            int textureColor = ColorUtil.getStateColor(state);
            class_2248 block = state.method_11614();
            blockColor = block instanceof class_2541 ? ColorUtil.proccessColor(blockColor, textureColor, class_1163.method_4966((class_1920)world, (class_2338)pos)) : (block instanceof class_2526 || block instanceof class_2320 ? ColorUtil.proccessColor(blockColor, textureColor, class_1163.method_4962((class_1920)world, (class_2338)pos)) : (block instanceof class_2553 || block instanceof class_2513 || block instanceof class_2195 ? ColorUtil.proccessColor(blockColor, textureColor, materialColor) : (block instanceof class_2404 ? (StateUtil.isWater(state) ? ColorUtil.proccessColor(blockColor, textureColor, class_1163.method_4961((class_1920)world, (class_2338)pos)) : ColorUtil.fluidColor(world, state, pos, textureColor)) : (blockColor != -1 ? ColorHelper.multiplyColor((int)textureColor, (int)blockColor) : (textureColor != -1 ? textureColor : materialColor)))));
            return blockColor;
        }
        return materialColor;
    }
}

