/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4590;
import ru.bulldog.justmap.map.minimap.MapSkin;
import ru.bulldog.justmap.util.ColorUtil;

public class DrawHelper
extends class_332 {
    public static final DrawHelper DRAWER = new DrawHelper();
    private static final class_293 VF_POS_TEX_NORMAL = new class_293(ImmutableList.of((Object)class_290.field_1587, (Object)class_290.field_1591, (Object)class_290.field_1579, (Object)class_290.field_1578));
    private static final class_289 tessellator = class_289.method_1348();
    private static final class_287 builder = tessellator.method_1349();
    private static final class_327 textRenderer = class_310.method_1551().field_1772;

    private DrawHelper() {
    }

    public void fillNoDepth(int x, int y, int right, int left, int color) {
        RenderSystem.disableDepthTest();
        DrawHelper.fill((int)x, (int)y, (int)right, (int)left, (int)color);
        RenderSystem.enableDepthTest();
    }

    public static void drawCenteredString(String string, int x, int y, int color) {
        System.out.println("Drawing: '" + string + "', at: " + x + ":" + y);
        textRenderer.method_1720(string, (float)(x - textRenderer.method_1727(string) / 2), (float)y, color);
    }

    public static void drawBoundedString(String string, int x, int y, int leftBound, int rightBound, int color) {
        if (string == null) {
            return;
        }
        int stringWidth = textRenderer.method_1727(string);
        int drawX = x - stringWidth / 2;
        if (drawX < leftBound) {
            drawX = leftBound;
        } else if (drawX + stringWidth > rightBound) {
            drawX = rightBound - stringWidth;
        }
        DRAWER.drawString(textRenderer, string, drawX, y, color);
    }

    public static void drawDiamond(double x, double y, int width, int height, int color) {
        DrawHelper.drawTriangle(x, y + (double)(height / 2), x + (double)width, y + (double)(height / 2), x + (double)(width / 2), y, color);
        DrawHelper.drawTriangle(x, y + (double)(height / 2), x + (double)(width / 2), y + (double)height, x + (double)width, y + (double)(height / 2), color);
    }

    public static void drawTriangle(double x1, double y1, double x2, double y2, double x3, double y3, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        builder.method_1328(4, class_290.field_1592);
        builder.method_22912(x1, y1, 0.0).method_1344();
        builder.method_22912(x2, y2, 0.0).method_1344();
        builder.method_22912(x3, y3, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
    }

    public static void drawLine(double x1, double y1, double x2, double y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        builder.method_1328(1, class_290.field_1592);
        builder.method_22912(x1, y1, 0.0).method_1344();
        builder.method_22912(x2, y2, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
    }

    public static void drawOutlineCircle(double x, double y, double radius, double outline, int color) {
        int darken = ColorUtil.colorBrigtness(color, -3.0f);
        DrawHelper.drawCircle(x, y, radius + outline, darken);
        DrawHelper.drawCircle(x, y, radius, color);
    }

    public static void drawCircle(double x, double y, double radius, int color) {
        double pi2 = Math.PI * 2;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        builder.method_1328(6, class_290.field_1592);
        builder.method_22912(x, y, 0.0).method_1344();
        int sides = 50;
        for (int i = 0; i <= sides; ++i) {
            double angle = pi2 * (double)i / (double)sides + Math.toRadians(180.0);
            double vx = x + Math.sin(angle) * radius;
            double vy = y + Math.cos(angle) * radius;
            builder.method_22912(vx, vy, 0.0).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void fill(double x, double y, double w, double h, int color) {
        DrawHelper.fill(class_4590.method_22931().method_22936(), x, y, w, h, color);
    }

    public static void fill(class_4587 matrix, double x, double y, double w, double h, int color) {
        DrawHelper.fill(matrix.method_23760().method_23761(), x, y, w, h, color);
    }

    public static void fill(class_1159 matrix4f, double x, double y, double w, double h, int color) {
        double o;
        if (x < w) {
            o = x;
            x = w;
            w = o;
        }
        if (y < h) {
            o = y;
            y = h;
            h = o;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        builder.method_1328(7, class_290.field_1576);
        builder.method_22918(matrix4f, (float)x, (float)h, 0.0f).method_22915(r, g, b, a).method_1344();
        builder.method_22918(matrix4f, (float)w, (float)h, 0.0f).method_22915(r, g, b, a).method_1344();
        builder.method_22918(matrix4f, (float)w, (float)y, 0.0f).method_22915(r, g, b, a).method_1344();
        builder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22915(r, g, b, a).method_1344();
        builder.method_1326();
        class_286.method_1309((class_287)builder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void draw(double x, double y, float w, float h) {
        class_4587 matrix = new class_4587();
        builder.method_1328(7, VF_POS_TEX_NORMAL);
        DrawHelper.draw(matrix, (class_4588)builder, x, y, w, h, 0.0f, 0.0f, 1.0f, 1.0f);
        tessellator.method_1350();
    }

    public static void drawPlayerHead(class_4587 matrix, double x, double y, int w, int h) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.method_1328(7, VF_POS_TEX_NORMAL);
        DrawHelper.draw(matrix, (class_4588)builder, x, y, w, h, 0.125f, 0.125f, 0.25f, 0.25f);
        DrawHelper.draw(matrix, (class_4588)builder, x, y, w, h, 0.625f, 0.125f, 0.75f, 0.25f);
        tessellator.method_1350();
    }

    public static void draw(class_4587 matrix, double x, double y, int size, int isize, int ix, int iy, int tw, int th) {
        DrawHelper.draw(matrix, x, y, size, size, ix, iy, isize, isize, tw, th);
    }

    public static void draw(class_4587 matrix, double x, double y, int w, int h, int ix, int iy, int iw, int ih, int tw, int th) {
        float minU = (float)ix / (float)tw;
        float minV = (float)iy / (float)th;
        float maxU = (float)(ix + iw) / (float)tw;
        float maxV = (float)(iy + ih) / (float)th;
        builder.method_1328(7, VF_POS_TEX_NORMAL);
        DrawHelper.draw(matrix, (class_4588)builder, x, y, w, h, minU, minV, maxU, maxV);
        tessellator.method_1350();
    }

    public static void drawSkin(class_4587 matrix, MapSkin skin, double x, double y, float w, float h) {
        MapSkin.RenderData renderData = skin.getRenderData();
        if (renderData.scaleChanged || renderData.x != x || renderData.y != y || renderData.width != w || renderData.height != h) {
            renderData.calculate(x, y, w, h);
        }
        float sMinU = skin.method_4594();
        float sMaxU = skin.method_4577();
        float sMinV = skin.method_4593();
        float sMaxV = skin.method_4575();
        float scaledBrd = renderData.scaledBorder;
        float hSide = renderData.hSide;
        float vSide = renderData.vSide;
        double leftC = renderData.leftC;
        double rightC = renderData.rightC;
        double topC = renderData.topC;
        double bottomC = renderData.bottomC;
        float leftU = renderData.leftU;
        float rightU = renderData.rightU;
        float topV = renderData.topV;
        float bottomV = renderData.bottomV;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.method_1328(7, VF_POS_TEX_NORMAL);
        class_4588 vertexConsumer = skin.method_24108((class_4588)builder);
        DrawHelper.draw(matrix, vertexConsumer, x, y, scaledBrd, scaledBrd, sMinU, sMinV, leftU, topV);
        DrawHelper.draw(matrix, vertexConsumer, rightC, y, scaledBrd, scaledBrd, rightU, sMinV, sMaxU, topV);
        DrawHelper.draw(matrix, vertexConsumer, x, topC, scaledBrd, vSide, sMinU, topV, leftU, bottomV);
        DrawHelper.draw(matrix, vertexConsumer, rightC, topC, scaledBrd, vSide, rightU, topV, sMaxU, bottomV);
        DrawHelper.draw(matrix, vertexConsumer, x, bottomC, scaledBrd, scaledBrd, sMinU, bottomV, leftU, sMaxV);
        DrawHelper.draw(matrix, vertexConsumer, rightC, bottomC, scaledBrd, scaledBrd, rightU, bottomV, sMaxU, sMaxV);
        DrawHelper.draw(matrix, vertexConsumer, leftC, topC, hSide, vSide, leftU, topV, rightU, bottomV);
        if (skin.repeating) {
            float tail = renderData.tail;
            float tailU = renderData.tailU;
            hSide = vSide;
            DrawHelper.draw(matrix, vertexConsumer, leftC + (double)hSide, y, tail, scaledBrd, leftU, sMinV, tailU, topV);
            DrawHelper.draw(matrix, vertexConsumer, leftC + (double)hSide, bottomC, tail, scaledBrd, leftU, bottomV, tailU, sMaxV);
        }
        DrawHelper.draw(matrix, vertexConsumer, leftC, y, hSide, scaledBrd, leftU, sMinV, rightU, topV);
        DrawHelper.draw(matrix, vertexConsumer, leftC, bottomC, hSide, scaledBrd, leftU, bottomV, rightU, sMaxV);
        tessellator.method_1350();
    }

    public static void drawSprite(class_4587 matrix, class_1058 sprite, double x, double y, float w, float h) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.method_1328(7, VF_POS_TEX_NORMAL);
        class_4588 vertexConsumer = sprite.method_24108((class_4588)builder);
        DrawHelper.draw(matrix, vertexConsumer, x, y, w, h, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575());
        tessellator.method_1350();
    }

    private static void draw(class_4587 matrixStack, class_4588 vertexConsumer, double x, double y, float w, float h, float minU, float minV, float maxU, float maxV) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22903();
        matrixStack.method_22904(x, y, 0.0);
        class_1159 m4f = matrixStack.method_23760().method_23761();
        class_4581 m3f = matrixStack.method_23760().method_23762();
        DrawHelper.addVertices(m4f, m3f, vertexConsumer, w, h, minU, minV, maxU, maxV);
        matrixStack.method_22909();
    }

    private static void addVertices(class_1159 m4f, class_4581 m3f, class_4588 vertexConsumer, float w, float h, float minU, float minV, float maxU, float maxV) {
        DrawHelper.addVertices(m4f, m3f, vertexConsumer, 0.0f, w, 0.0f, h, minU, minV, maxU, maxV);
    }

    private static void addVertices(class_1159 m4f, class_4581 m3f, class_4588 vertexConsumer, float minX, float maxX, float minY, float maxY, float minU, float minV, float maxU, float maxV) {
        DrawHelper.addVertex(m4f, m3f, vertexConsumer, minX, minY, 1.0f, minU, minV);
        DrawHelper.addVertex(m4f, m3f, vertexConsumer, minX, maxY, 1.0f, minU, maxV);
        DrawHelper.addVertex(m4f, m3f, vertexConsumer, maxX, maxY, 1.0f, maxU, maxV);
        DrawHelper.addVertex(m4f, m3f, vertexConsumer, maxX, minY, 1.0f, maxU, minV);
    }

    private static void addVertex(class_1159 m4f, class_4581 m3f, class_4588 vertexConsumer, float x, float y, float z, float u, float v) {
        vertexConsumer.method_22918(m4f, x, y, z).method_22913(u, v).method_23763(m3f, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

