/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import ru.bulldog.justmap.JustMap;
import ru.bulldog.justmap.util.ColorUtil;

public class ImageUtil {
    private static class_3300 resourceManager;

    private ImageUtil() {
    }

    private static void checkResourceManager() {
        if (resourceManager == null) {
            resourceManager = class_310.method_1551().method_1478();
        }
    }

    public static boolean imageExists(class_2960 image) {
        if (image == null) {
            return false;
        }
        try {
            return resourceManager.method_18234(image);
        }
        catch (Exception ex) {
            JustMap.LOGGER.catching(ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_1011 loadImage(class_2960 image, int w, int h) {
        ImageUtil.checkResourceManager();
        if (!ImageUtil.imageExists(image)) return new class_1011(w, h, false);
        try (class_3298 resource = resourceManager.method_14486(image);){
            class_1011 class_10112 = class_1011.method_4309((InputStream)resource.method_14482());
            return class_10112;
        }
        catch (IOException e) {
            JustMap.LOGGER.logWarning(String.format("Can't load texture image: %s. Will be created empty image.", image));
            JustMap.LOGGER.logWarning(String.format("Cause: %s.", e.getMessage()));
        }
        return new class_1011(w, h, false);
    }

    public static class_1011 applyColor(class_1011 image, int color) {
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                if (image.method_4311(i, j) != -1) continue;
                int newColor = ColorHelper.multiplyColor((int)image.method_4315(i, j), (int)color);
                image.method_4305(i, j, ColorUtil.toABGR(newColor));
            }
        }
        return image;
    }

    public static void fillImage(class_1011 image, int color) {
        image.method_4326(0, 0, image.method_4307(), image.method_4323(), color);
    }

    public static class_1011 readTile(class_1011 source, int x, int y, int w, int h, boolean closeSource) {
        class_1011 tile = new class_1011(w, h, false);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                tile.method_4305(i, j, source.method_4315(x + i, y + j));
            }
        }
        if (closeSource) {
            source.close();
        }
        return tile;
    }

    public static class_1011 writeTile(class_1011 image, class_1011 tile, int x, int y) {
        int tileWidth = tile.method_4307();
        int tileHeight = tile.method_4323();
        int imageWidth = image.method_4307();
        int imageHeight = image.method_4323();
        if (tileWidth + x <= 0 || tileHeight + y <= 0) {
            return image;
        }
        if (x + tileWidth > imageWidth) {
            tileWidth = imageWidth - x;
        }
        if (y + tileHeight > imageHeight) {
            tileHeight = imageHeight - y;
        }
        for (int i = 0; i < tileWidth; ++i) {
            int xp = x + i;
            if (xp < 0) continue;
            for (int j = 0; j < tileHeight; ++j) {
                int yp = y + j;
                if (yp < 0) continue;
                try {
                    image.method_4305(xp, yp, tile.method_4315(i, j));
                    continue;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return image;
    }

    public static class_1011 fromBufferedImage(BufferedImage image) {
        return null;
    }
}

