/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public final class Logger {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger();
    private String modPref = "[justmap] ";

    private Logger() {
    }

    public static Logger get() {
        return new Logger();
    }

    public void log(Level level, String message) {
        LOGGER.log(level, this.modPref + message);
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, message.toString());
    }

    public void catching(Throwable ex) {
        this.logError(ex.getLocalizedMessage());
        LOGGER.catching(ex);
    }

    public void logInfo(String message) {
        this.log(Level.INFO, message);
    }

    public void logWarning(String message) {
        this.log(Level.WARN, message);
    }

    public void logWarning(String message, Object obj, Exception ex) {
        LOGGER.warn(this.modPref + message, obj, (Object)ex);
    }

    public void logError(String message) {
        this.log(Level.ERROR, message);
    }

    public void logError(String message, Object obj, Exception ex) {
        LOGGER.error(this.modPref + message, obj, (Object)ex);
    }

    public void logError(String message, Exception ex) {
        LOGGER.error(this.modPref + message, (Throwable)ex);
    }
}

