/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util;

import java.io.File;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_642;
import ru.bulldog.justmap.map.data.ChunkStorage;

public class StorageUtil {
    private static class_310 minecraft = class_310.method_1551();
    public static final File MAP_DIR = new File(StorageUtil.minecraft.field_1697, "justmap/");
    private static ChunkStorage storage;
    private static File storageDir;
    private static File filesDir;
    private static int currentDimId;

    public static synchronized class_2487 getCache(class_1923 pos) {
        if (storage == null) {
            StorageUtil.updateCacheStorage();
        }
        try {
            class_2487 data = storage.getNbt(storageDir, pos);
            return data != null ? data : new class_2487();
        }
        catch (Exception ex) {
            return new class_2487();
        }
    }

    public static synchronized void saveCache(class_1923 pos, class_2487 data) {
        if (storage == null) {
            StorageUtil.updateCacheStorage();
        }
        storage.setTagAt(storageDir, pos, data);
    }

    public static void updateCacheStorage() {
        storageDir = new File(StorageUtil.cacheDir(), "chunk-data/");
        if (!storageDir.exists()) {
            storageDir.mkdirs();
        }
        if (storage == null) {
            storage = new ChunkStorage();
        }
    }

    public static File cacheDir() {
        File cacheDir;
        int dimension;
        if (StorageUtil.minecraft.field_1687 != null && currentDimId != (dimension = StorageUtil.minecraft.field_1687.method_8597().method_12460().method_12484())) {
            currentDimId = dimension;
        }
        if (!(cacheDir = new File(StorageUtil.filesDir(), String.format("cache/DIM%d/", currentDimId))).exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static File filesDir() {
        class_310 client = class_310.method_1551();
        class_642 serverInfo = client.method_1558();
        if (client.method_1496()) {
            class_1132 server = client.method_1576();
            String name = StorageUtil.scrubNameFile(server.method_3865());
            filesDir = new File(MAP_DIR, String.format("local/%s/", name));
        } else if (serverInfo != null) {
            String name = StorageUtil.scrubNameFile(serverInfo.field_3752);
            filesDir = new File(MAP_DIR, String.format("servers/%s/", name));
        }
        if (!filesDir.exists()) {
            filesDir.mkdirs();
        }
        return filesDir;
    }

    public static void clearCache(File dir) {
        StorageUtil.deleteDir(dir);
        dir.mkdirs();
    }

    public static void clearCache() {
        StorageUtil.clearCache(StorageUtil.cacheDir());
    }

    private static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            dir.delete();
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                StorageUtil.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    private static String scrubNameFile(String input) {
        input = input.replace("<", "_");
        input = input.replace(">", "_");
        input = input.replace(":", "_");
        input = input.replace("\"", "_");
        input = input.replace("/", "_");
        input = input.replace("\\", "_");
        input = input.replace("//", "_");
        input = input.replace("|", "_");
        input = input.replace("?", "_");
        input = input.replace("*", "_");
        return input;
    }

    static {
        filesDir = new File(MAP_DIR, "undefined/");
        currentDimId = 0;
    }
}

