/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;

public class TaskManager
implements Executor {
    private final Queue<Runnable> workQueue = new ConcurrentLinkedQueue<Runnable>();
    private final Thread worker;
    private boolean running = true;
    private String name = "justmap";
    private static Map<String, TaskManager> managers = new HashMap<String, TaskManager>();

    public static TaskManager getManager(String name) {
        if (managers.containsKey(name)) {
            TaskManager manager = managers.get(name);
            if (!manager.isRunning()) {
                manager = new TaskManager(name);
                managers.replace(name, manager);
            }
            return manager;
        }
        TaskManager manager = new TaskManager(name);
        managers.put(name, manager);
        return manager;
    }

    public static void shutdown() {
        managers.forEach((name, manager) -> {
            if (manager.isRunning()) {
                manager.stop();
            }
        });
    }

    private TaskManager(String name) {
        this.name = this.name + "-" + name;
        this.worker = new Thread(this::work, this.name);
        this.worker.start();
    }

    @Override
    public void execute(Runnable command) {
        this.workQueue.offer(command);
        LockSupport.unpark(this.worker);
    }

    public <T> CompletableFuture<T> run(Function<CompletableFuture<T>, Runnable> function) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.execute(function.apply(completableFuture));
        return completableFuture;
    }

    public void stop() {
        this.execute(() -> {
            this.running = false;
        });
    }

    public int queueSize() {
        return this.workQueue.size();
    }

    public boolean isRunning() {
        return this.running;
    }

    private void work() {
        while (this.running) {
            Runnable nextTask = this.workQueue.poll();
            if (nextTask != null) {
                nextTask.run();
                continue;
            }
            LockSupport.park("Tasks waiting...");
        }
    }
}

