/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util.math;

import ru.bulldog.justmap.util.math.MathUtil;

public class Line {
    public final Point first;
    public final Point second;
    private int lenght;

    public Line(int sx, int sy, int ex, int ey) {
        this(new Point(sx, sy), new Point(ex, ey));
    }

    public Line(Point first, Point second) {
        this.first = first;
        this.second = second;
        this.lenght = first.distance(second);
    }

    public int lenght() {
        return this.lenght;
    }

    public void add(int length) {
        int len = this.lenght + length;
        if (len <= 0) {
            return;
        }
        int cx = this.second.x + (this.second.x - this.first.x) / this.lenght * length;
        int cy = this.second.y + (this.second.y - this.first.y) / this.lenght * length;
        this.second.x = cx;
        this.second.y = cy;
        this.lenght = len;
    }

    public void add(Line line) {
        this.add(line.lenght());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Line)) {
            return false;
        }
        Line line = (Line)obj;
        return this.first.equals(line.first) && this.second.equals(line.second);
    }

    public static class Point {
        public int x;
        public int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int distance(Point target) {
            return (int)Math.sqrt(MathUtil.pow2(target.x - this.x) + MathUtil.pow2(target.y - this.y));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Point)) {
                return false;
            }
            Point point = (Point)obj;
            return this.x == point.x && this.y == point.y;
        }
    }
}

