/*
 * Decompiled with CFR 0.152.
 */
package ru.bulldog.justmap.util.math;

import net.minecraft.class_2338;

public class MathUtil {
    public static int clamp(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static double clamp(double val, double min, double max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static float clamp(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static double logn(double n, double a) {
        return Math.log(a) / Math.log(n);
    }

    public static double pow2(double n) {
        return Math.pow(n, 2.0);
    }

    public static float correctAngle(float angle) {
        int turns = (int)Math.abs(angle / 360.0f);
        if (angle >= 360.0f) {
            return angle - (float)(360 * turns);
        }
        if (angle < 0.0f) {
            return angle + (float)(360 * (turns + 1));
        }
        return angle;
    }

    public static double screenPos(double val, double x1, double x2, double mapWidth) {
        return (val - x1) / (x2 - x1) * mapWidth;
    }

    public static int worldPos(double val, double x1, double x2, double range) {
        return (int)Math.round((val * (x2 - x1) + range * x1) / range);
    }

    public static double getDistance(class_2338 a, class_2338 b) {
        return MathUtil.getDistance(a, b, false);
    }

    public static double getDistance(class_2338 a, class_2338 b, boolean horizontalOnly) {
        int distX = a.method_10263() - b.method_10263();
        int distZ = a.method_10260() - b.method_10260();
        int dist = distX * distX + distZ * distZ;
        if (!horizontalOnly) {
            int distY = a.method_10264() - b.method_10264();
            dist += distY * distY;
        }
        return Math.sqrt(dist);
    }
}

