/*
 * Decompiled with CFR 0.152.
 */
package levelup2.capability;

import levelup2.capability.PlayerCapability;
import levelup2.config.LevelUpConfig;
import levelup2.skills.SkillRegistry;
import levelup2.util.SmeltingBlacklist;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class CapabilityFurnace
extends PlayerCapability.CapabilityProcessorDefault {
    public CapabilityFurnace(TileEntityFurnace tile) {
        super((TileEntity)tile);
    }

    @Override
    public void extraProcessing(EntityPlayer player) {
        int bonus;
        ItemStack stack;
        TileEntityFurnace furnace;
        if (this.tile != null && (furnace = (TileEntityFurnace)this.tile).func_145950_i() && furnace.func_145948_k() && !(stack = furnace.func_70301_a(0)).func_190926_b() && (bonus = SkillRegistry.getSkillLevel(player, "levelup:furnacespeed")) > 0) {
            int time = player.func_70681_au().nextInt(bonus + 1);
            if (time > 0 && furnace.func_174887_a_(2) + time < furnace.func_174887_a_(3)) {
                furnace.func_174885_b(2, furnace.func_174887_a_(2) + time);
            }
            if (furnace.func_174887_a_(2) > furnace.func_174887_a_(3) - 2 && (bonus = SkillRegistry.getSkillLevel(player, "levelup:furnacebonus")) > 0 && this.isDoublingValid(furnace) && player.func_70681_au().nextFloat() < (float)bonus / 40.0f) {
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
                if (!LevelUpConfig.furnaceEjection) {
                    if (furnace.func_70301_a(2).func_190926_b()) {
                        furnace.func_70299_a(2, result);
                    } else {
                        ItemStack product = furnace.func_70301_a(2);
                        if (ItemStack.func_179545_c((ItemStack)result, (ItemStack)product) && product.func_190916_E() + result.func_190916_E() * 2 <= product.func_77976_d()) {
                            furnace.func_70301_a(2).func_190917_f(result.func_190916_E());
                        }
                    }
                } else {
                    this.ejectExtraItem(result);
                }
            }
        }
    }

    private boolean isDoublingValid(TileEntityFurnace tile) {
        ItemStack smeltingItem = tile.func_70301_a(0);
        return !FurnaceRecipes.func_77602_a().func_151395_a(smeltingItem).func_190926_b() && !SmeltingBlacklist.contains(smeltingItem);
    }

    private void ejectExtraItem(ItemStack stack) {
        if (!(stack.func_190926_b() || this.tile.func_145838_q() != Blocks.field_150460_al && this.tile.func_145838_q() != Blocks.field_150470_am)) {
            IBlockState furnace = this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v());
            EnumFacing facing = (EnumFacing)furnace.func_177229_b((IProperty)BlockFurnace.field_176447_a);
            BlockPos offset = this.tile.func_174877_v().func_177972_a(facing);
            EntityItem item = new EntityItem(this.tile.func_145831_w(), (double)offset.func_177958_n() + 0.5, (double)offset.func_177956_o() + 0.5, (double)offset.func_177952_p() + 0.5, stack);
            this.tile.func_145831_w().func_72838_d((Entity)item);
        }
    }
}

